/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.fileng;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.binary.BinaryIndex;
import org.teamapps.universaldb.index.fileng.FileVersionEntry;

public class FileVersionDataIndex {
    private final BinaryIndex versionDataIndex;

    public FileVersionDataIndex(String name, TableIndex table) {
        this.versionDataIndex = new BinaryIndex(name + "-file-version-data", table, false, ColumnType.BINARY);
    }

    public void addVersionEntry(int id, int version, String hash, String fileName, long size) {
        try {
            this.addVersionEntry(id, new FileVersionEntry(version, hash, fileName, size));
        }
        catch (IOException e) {
            throw new RuntimeException("Error: could not add file version entry", e);
        }
    }

    public void addVersionEntry(int id, FileVersionEntry entry) throws IOException {
        if (entry == null) {
            return;
        }
        byte[] bytes = this.versionDataIndex.getValue(id);
        byte[] entryBytes = entry.getEntryValue();
        if (bytes == null) {
            this.versionDataIndex.setValue(id, entryBytes);
        } else {
            byte[] newBytes = new byte[bytes.length + entryBytes.length];
            System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
            System.arraycopy(entryBytes, 0, newBytes, bytes.length, entryBytes.length);
            this.versionDataIndex.setValue(id, newBytes);
        }
    }

    public FileVersionEntry getVersionData(int id, int version) {
        Map<Integer, FileVersionEntry> versions = this.getVersions(id);
        if (versions == null) {
            return null;
        }
        return versions.get(version);
    }

    public Map<Integer, FileVersionEntry> getVersions(int id) {
        byte[] bytes = this.versionDataIndex.getValue(id);
        if (bytes == null) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(bytes));
        HashMap<Integer, FileVersionEntry> versions = new HashMap<Integer, FileVersionEntry>();
        try {
            while (true) {
                FileVersionEntry entry = new FileVersionEntry(dataInputStream);
                versions.put(entry.getVersion(), entry);
            }
        }
        catch (EOFException e) {
            return versions;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void close() {
        this.versionDataIndex.close();
    }

    public void drop() {
        this.versionDataIndex.drop();
    }
}

