/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.pojo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.reference.value.MultiReferenceEditValue;
import org.teamapps.universaldb.index.reference.value.RecordReference;
import org.teamapps.universaldb.index.transaction.request.TransactionRequest;
import org.teamapps.universaldb.index.transaction.request.TransactionRequestRecord;
import org.teamapps.universaldb.index.transaction.request.TransactionRequestRecordValue;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.Entity;

public class EntityChangeSet {
    private final Map<Integer, TransactionRequestRecordValue> changeMap = new HashMap<Integer, TransactionRequestRecordValue>();
    private final Map<Integer, AbstractUdbEntity> changedReferenceMap = new HashMap<Integer, AbstractUdbEntity>();
    private final Map<RecordReference, Entity> entityByReference = new HashMap<RecordReference, Entity>();

    public void addChangeValue(ColumnIndex column, Object value) {
        TransactionRequestRecordValue requestRecordValue = new TransactionRequestRecordValue(column.getMappingId(), column.getType(), value);
        this.changeMap.put(requestRecordValue.getColumnId(), requestRecordValue);
    }

    public void addRecordReference(RecordReference reference, Entity entity) {
        this.entityByReference.put(reference, entity);
    }

    public Map<RecordReference, Entity> getEntityByReference() {
        return this.entityByReference;
    }

    public TransactionRequestRecordValue getChangeValue2(ColumnIndex index) {
        return this.changeMap.get(index.getMappingId());
    }

    public boolean isChanged(ColumnIndex columnIndex) {
        return this.changeMap.containsKey(columnIndex.getMappingId());
    }

    public void removeChange(ColumnIndex columnIndex) {
        this.changeMap.remove(columnIndex);
    }

    public TransactionRequestRecordValue getChangeValue(ColumnIndex index) {
        return this.changeMap.get(index.getMappingId());
    }

    public void setTransactionRequestRecordValues(TransactionRequest transactionRequest, TransactionRequestRecord transactionRequestRecord) {
        ArrayList<AbstractUdbEntity> uncommittedEntityReferences = new ArrayList<AbstractUdbEntity>();
        for (TransactionRequestRecordValue recordValue : this.changeMap.values()) {
            transactionRequestRecord.addRecordValue(recordValue);
            IndexType indexType = recordValue.getIndexType();
            if (recordValue.getValue() == null) continue;
            if (indexType == IndexType.MULTI_REFERENCE) {
                Entity entity;
                MultiReferenceEditValue editValue = (MultiReferenceEditValue)recordValue.getValue();
                for (RecordReference recordReference : editValue.getAddReferences()) {
                    entity = this.entityByReference.get(recordReference);
                    if (entity.getId() == 0) {
                        uncommittedEntityReferences.add((AbstractUdbEntity)entity);
                        continue;
                    }
                    if (recordReference.getRecordId() != 0 || entity.getId() <= 0) continue;
                    recordReference.setRecordId(entity.getId());
                }
                for (RecordReference recordReference : editValue.getSetReferences()) {
                    entity = this.entityByReference.get(recordReference);
                    if (entity.getId() == 0) {
                        uncommittedEntityReferences.add((AbstractUdbEntity)entity);
                        continue;
                    }
                    if (recordReference.getRecordId() != 0 || entity.getId() <= 0) continue;
                    recordReference.setRecordId(entity.getId());
                }
                continue;
            }
            if (indexType != IndexType.REFERENCE) continue;
            RecordReference recordReference = (RecordReference)recordValue.getValue();
            AbstractUdbEntity entity = this.getReferenceChange(recordValue.getColumnId());
            if (entity.getId() == 0) {
                uncommittedEntityReferences.add(entity);
                continue;
            }
            if (recordReference.getRecordId() != 0 || entity.getId() <= 0) continue;
            recordReference.setRecordId(entity.getId());
        }
        for (AbstractUdbEntity entity : uncommittedEntityReferences) {
            entity.saveRecord(transactionRequest);
        }
    }

    public void setReferenceChange(ColumnIndex index, AbstractUdbEntity reference) {
        this.changedReferenceMap.put(index.getMappingId(), reference);
    }

    public AbstractUdbEntity getReferenceChange(int columnId) {
        return this.changedReferenceMap.get(columnId);
    }
}

