/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.log;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.teamapps.protocol.file.FileProvider;
import org.teamapps.protocol.file.FileSink;
import org.teamapps.protocol.schema.MessageObject;
import org.teamapps.protocol.schema.ModelRegistry;
import org.teamapps.universaldb.index.log.DefaultLogIndex;
import org.teamapps.universaldb.index.log.LogIndex;
import org.teamapps.universaldb.index.log.LogIterator;
import org.teamapps.universaldb.index.log.RotatingLogIndex;

public class MessageLog {
    private LogIndex logIndex;
    private FileProvider fileProvider;
    private FileSink fileSink;
    private ModelRegistry modelRegistry;

    public MessageLog(File basePath, String name, boolean rotating, FileProvider fileProvider, FileSink fileSink, ModelRegistry modelRegistry) {
        this.fileProvider = fileProvider;
        this.fileSink = fileSink;
        this.modelRegistry = modelRegistry;
        this.logIndex = rotating ? new RotatingLogIndex(basePath, name) : new DefaultLogIndex(basePath, name);
    }

    public long addMessage(MessageObject message) throws IOException {
        byte[] bytes = message.toBytes(this.fileSink);
        return this.logIndex.writeLog(bytes);
    }

    public MessageObject readMessage(long position) throws IOException {
        byte[] bytes = this.logIndex.readLog(position);
        return new MessageObject(bytes, this.modelRegistry, this.fileProvider, null);
    }

    public Iterator<MessageObject> getMessages(long startPos) {
        final LogIterator logIterator = this.logIndex.readLogs(startPos);
        return new Iterator<MessageObject>(){

            @Override
            public boolean hasNext() {
                return logIterator.hasNext();
            }

            @Override
            public MessageObject next() {
                byte[] bytes = logIterator.next();
                try {
                    return new MessageObject(bytes, MessageLog.this.modelRegistry, MessageLog.this.fileProvider, null);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public void close() {
        this.logIndex.close();
    }
}

