/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.log;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.teamapps.universaldb.index.log.LogIndex;
import org.teamapps.universaldb.index.log.LogIterator;

public class RotatingLogIndex
implements LogIndex {
    private final File basePath;
    private final String name;
    private final int maxLogFileSize;
    private final int scanUpToFileIndex;
    private int currentFileIndex;
    private int currentFilePosition;
    private DataOutputStream dos;

    public RotatingLogIndex(File basePath, String name) {
        this(basePath, name, 1966080000, 10);
    }

    public RotatingLogIndex(File basePath, String name, int maxLogFileSize, int scanUpToFileIndex) {
        this.basePath = basePath;
        this.name = name;
        this.maxLogFileSize = maxLogFileSize;
        this.scanUpToFileIndex = Math.min(1, scanUpToFileIndex);
        this.init();
    }

    private void init() {
        int lastAvailableIndex = -1;
        for (int index = 0; index < this.scanUpToFileIndex || lastAvailableIndex + 1 == index; ++index) {
            if (!this.getLogFile(index).exists()) continue;
            lastAvailableIndex = index;
        }
        try {
            if (lastAvailableIndex < 0) {
                this.currentFileIndex = 0;
                this.currentFilePosition = 0;
                File logFile = this.getLogFile(this.currentFileIndex);
                this.dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(logFile, true), 32000));
            } else {
                this.currentFileIndex = lastAvailableIndex;
                File logFile = this.getLogFile(this.currentFileIndex);
                this.currentFilePosition = (int)logFile.length();
                this.dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(logFile, true), 32000));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening log index: " + this.getLogFile(this.currentFileIndex).getAbsolutePath(), e);
        }
    }

    private File getLogFile(int fileIndex) {
        return new File(this.basePath, this.name + "-" + fileIndex + ".lgx");
    }

    private void checkWritePosition(int length) throws IOException {
        if (this.currentFilePosition + length + 4 >= this.maxLogFileSize) {
            this.dos.close();
            ++this.currentFileIndex;
            this.currentFilePosition = 0;
            File logFile = this.getLogFile(this.currentFileIndex);
            this.dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(logFile, true), 32000));
        }
    }

    @Override
    public synchronized long writeLog(byte[] bytes, boolean committed) {
        try {
            this.checkWritePosition(bytes.length);
            this.dos.writeInt(bytes.length);
            this.dos.write(bytes);
            long storePos = this.getPosition();
            this.currentFilePosition += bytes.length + 4;
            if (committed) {
                this.dos.flush();
            }
            return storePos;
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing log to file:" + this.getLogFile(this.currentFileIndex).getAbsolutePath(), e);
        }
    }

    @Override
    public synchronized byte[] readLog(long storePosition) {
        File logFile = null;
        try {
            int fileIndex = RotatingLogIndex.getFileIndex(storePosition);
            int filePosition = RotatingLogIndex.getFilePos(storePosition);
            logFile = this.getLogFile(fileIndex);
            if (!logFile.exists() || (long)filePosition >= logFile.length()) {
                return null;
            }
            RandomAccessFile ras = new RandomAccessFile(logFile, "r");
            ras.seek(filePosition);
            int size = ras.readInt();
            byte[] bytes = new byte[size];
            for (int read = 0; read < bytes.length; read += ras.read(bytes, read, size - read)) {
            }
            ras.close();
            return bytes;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading log file:" + logFile.getAbsolutePath(), e);
        }
    }

    @Override
    public LogIterator readLogs() {
        List<File> storeFiles = this.getStoreFiles();
        return new LogIterator(storeFiles, 0L, true);
    }

    @Override
    public LogIterator readLogs(long pos) {
        List<File> storeFiles = this.getStoreFiles();
        return new LogIterator(storeFiles, pos, true);
    }

    private List<File> getStoreFiles() {
        ArrayList<File> storeFiles = new ArrayList<File>();
        for (int i = 0; i <= this.currentFileIndex; ++i) {
            storeFiles.add(this.getLogFile(i));
        }
        return storeFiles;
    }

    @Override
    public long getPosition() {
        return RotatingLogIndex.calculatePosition(this.currentFileIndex, this.currentFilePosition);
    }

    @Override
    public boolean isEmpty() {
        return this.currentFileIndex == 0 && this.currentFilePosition == 0;
    }

    @Override
    public void flush() {
        try {
            this.dos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        try {
            this.dos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void drop() {
        this.close();
        for (File storeFile : this.getStoreFiles()) {
            if (!storeFile.exists()) continue;
            storeFile.delete();
        }
    }

    public static long calculatePosition(int fileIndex, int filePos) {
        return (long)fileIndex << 32 | (long)filePos & 0xFFFFFFFFL;
    }

    public static int getFileIndex(long storePosition) {
        return (int)(storePosition >> 32);
    }

    public static int getFilePos(long storePosition) {
        return (int)storePosition;
    }
}

