/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.transaction.request;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.teamapps.universaldb.TableConfig;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.transaction.request.TransactionRequest;
import org.teamapps.universaldb.index.transaction.request.TransactionRequestRecordType;
import org.teamapps.universaldb.index.transaction.request.TransactionRequestRecordValue;

public class TransactionRequestRecord {
    private final TransactionRequestRecordType recordType;
    private final int tableId;
    private final int recordId;
    private final int correlationId;
    private final List<TransactionRequestRecordValue> recordValues = new ArrayList<TransactionRequestRecordValue>();
    private boolean transactionProcessingStarted;

    public static TransactionRequestRecord createOrUpdateRecord(TransactionRequest transactionRequest, TableIndex tableIndex, int recordId, int correlationId, boolean update) {
        TransactionRequestRecordType type;
        TransactionRequestRecordType transactionRequestRecordType = type = update ? TransactionRequestRecordType.UPDATE : TransactionRequestRecordType.CREATE;
        if (!update && recordId > 0) {
            type = TransactionRequestRecordType.CREATE_WITH_ID;
        }
        TransactionRequestRecord requestRecord = new TransactionRequestRecord(type, tableIndex.getMappingId(), recordId, correlationId);
        requestRecord.createMetaData(tableIndex, transactionRequest.getUserId());
        return requestRecord;
    }

    public static TransactionRequestRecord createDeleteRecord(TransactionRequest transactionRequest, TableIndex tableIndex, int recordId) {
        TransactionRequestRecord requestRecord = new TransactionRequestRecord(TransactionRequestRecordType.DELETE, tableIndex.getMappingId(), recordId, 0);
        requestRecord.createMetaData(tableIndex, transactionRequest.getUserId());
        if (recordId <= 0) {
            throw new RuntimeException("Cannot delete record with id:" + recordId);
        }
        return requestRecord;
    }

    public static TransactionRequestRecord createRestoreRecord(TransactionRequest transactionRequest, TableIndex tableIndex, int recordId) {
        TransactionRequestRecord requestRecord = new TransactionRequestRecord(TransactionRequestRecordType.RESTORE, tableIndex.getMappingId(), recordId, 0);
        requestRecord.createMetaData(tableIndex, transactionRequest.getUserId());
        if (recordId <= 0) {
            throw new RuntimeException("Cannot restore record with id:" + recordId);
        }
        return requestRecord;
    }

    public TransactionRequestRecord(TransactionRequestRecordType recordType, int tableId, int recordId, int correlationId) {
        this.recordType = recordType;
        this.tableId = tableId;
        this.recordId = recordId;
        this.correlationId = correlationId;
    }

    public TransactionRequestRecord(DataInputStream dis) throws IOException {
        this.recordType = TransactionRequestRecordType.getById(dis.readByte());
        this.tableId = dis.readInt();
        this.recordId = dis.readInt();
        this.correlationId = dis.readInt();
        int count = dis.readInt();
        for (int i = 0; i < count; ++i) {
            this.recordValues.add(new TransactionRequestRecordValue(dis));
        }
    }

    public void createMetaData(TableIndex tableIndex, int userId) {
        TableConfig config = tableIndex.getTableConfig();
        int changeDate = (int)(System.currentTimeMillis() / 1000L);
        switch (this.recordType) {
            case CREATE: 
            case CREATE_WITH_ID: {
                if (config.trackCreation()) {
                    this.addRecordValue(tableIndex.getColumnIndex("metaCreationDate"), changeDate);
                    this.addRecordValue(tableIndex.getColumnIndex("metaCreatedBy"), userId);
                }
                if (!config.trackModification()) break;
                this.addRecordValue(tableIndex.getColumnIndex("metaModificationDate"), changeDate);
                this.addRecordValue(tableIndex.getColumnIndex("metaModifiedBy"), userId);
                break;
            }
            case UPDATE: {
                if (!config.trackModification()) break;
                this.addRecordValue(tableIndex.getColumnIndex("metaModificationDate"), changeDate);
                this.addRecordValue(tableIndex.getColumnIndex("metaModifiedBy"), userId);
                break;
            }
            case DELETE: {
                if (!config.keepDeleted()) break;
                this.addRecordValue(tableIndex.getColumnIndex("metaDeletionDate"), changeDate);
                this.addRecordValue(tableIndex.getColumnIndex("metaDeletedBy"), userId);
                break;
            }
            case RESTORE: {
                if (!config.keepDeleted()) break;
                this.addRecordValue(tableIndex.getColumnIndex("metaRestoreDate"), changeDate);
                this.addRecordValue(tableIndex.getColumnIndex("metaRestoredBy"), userId);
            }
        }
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeByte(this.recordType.getId());
        dos.writeInt(this.tableId);
        dos.writeInt(this.recordId);
        dos.writeInt(this.correlationId);
        dos.writeInt(this.recordValues.size());
        for (TransactionRequestRecordValue recordValue : this.recordValues) {
            recordValue.write(dos);
        }
    }

    public int getTableId() {
        return this.tableId;
    }

    public int getRecordId() {
        return this.recordId;
    }

    public int getCorrelationId() {
        return this.correlationId;
    }

    public void addRecordValue(ColumnIndex columnIndex, Object value) {
        this.addRecordValue(new TransactionRequestRecordValue(columnIndex.getMappingId(), columnIndex.getType(), value));
    }

    public void addRecordValue(TransactionRequestRecordValue recordValue) {
        this.recordValues.add(recordValue);
    }

    public TransactionRequestRecordType getRecordType() {
        return this.recordType;
    }

    public List<TransactionRequestRecordValue> getRecordValues() {
        return this.recordValues;
    }

    public boolean isTransactionProcessingStarted() {
        return this.transactionProcessingStarted;
    }

    public void setTransactionProcessingStarted(boolean transactionProcessingStarted) {
        this.transactionProcessingStarted = transactionProcessingStarted;
    }
}

