/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.query;

import java.util.BitSet;
import java.util.Collection;
import org.teamapps.universaldb.query.Filter;
import org.teamapps.universaldb.query.IndexPath;

public class RecordIdFilter
implements Filter {
    private final BitSet filterBitset;
    private IndexPath indexPath = new IndexPath();

    public RecordIdFilter(BitSet filterBitset) {
        this.filterBitset = filterBitset;
    }

    public RecordIdFilter(Collection<Integer> ids) {
        this.filterBitset = new BitSet();
        ids.forEach(this.filterBitset::set);
    }

    @Override
    public BitSet filter(BitSet input) {
        BitSet localRecords = this.indexPath.calculatePathBitSet(input);
        BitSet result = this.localFilter(localRecords);
        return this.indexPath.calculateReversePath(result, input);
    }

    @Override
    public BitSet localFilter(BitSet localRecords) {
        localRecords.and(this.filterBitset);
        return localRecords;
    }

    @Override
    public IndexPath getPath() {
        return this.indexPath;
    }

    @Override
    public void prependPath(IndexPath path) {
        path.addPath(this.indexPath);
        this.indexPath = path;
    }

    @Override
    public String explain(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getExplainTabs(level));
        sb.append("custom-filter");
        sb.append("\n");
        return sb.toString();
    }
}

