/*
 * Decompiled with CFR 0.152.
 */
import org.teamapps.universaldb.schema.Database;
import org.teamapps.universaldb.schema.Schema;
import org.teamapps.universaldb.schema.SchemaInfoProvider;
import org.teamapps.universaldb.schema.Table;
import org.teamapps.universaldb.schema.TableOption;

public class Model
implements SchemaInfoProvider {
    @Override
    public Schema getSchema() {
        Schema schema = Schema.create();
        schema.setSchemaName("TestBaseSchema");
        Database database = schema.addDatabase("testDb1");
        Table table = database.addTable("fieldTest", TableOption.CHECKPOINTS, TableOption.HIERARCHY, TableOption.TRACK_CREATION, TableOption.TRACK_MODIFICATION, TableOption.KEEP_DELETED);
        table.addBoolean("booleanField").addShort("shortField").addInteger("intField").addLong("longField").addFloat("floatField").addDouble("doubleField").addText("textField").addTranslatableText("translatableText").addTimestamp("timestampField").addTime("timeField").addDate("dateField").addDateTime("dateTimeField").addLocalDate("localDateField").addEnum("enumField", "firstValue", "secondValue", "thirdValue", "forthValue", "fifthValue").addFile("fileField").addBinary("binaryField").addReference("singleReferenceField", table, false, "backRefSingleReferenceField").addReference("backRefSingleReferenceField", table, false, "singleReferenceField").addReference("singleReferenceNoBackRefField", table, false).addReference("multiReferenceField", table, true, "backRefMultiReferenceField").addReference("backRefMultiReferenceField", table, true, "multiReferenceField").addReference("parent", table, false, "children").addReference("children", table, true, "parent");
        Table fieldTestView = database.addView("fieldTestView", table);
        fieldTestView.addBoolean("booleanField").addShort("shortField").addInteger("intField").addLong("longField").addFloat("floatField").addDouble("doubleField").addText("textField").addTranslatableText("translatableText").addTimestamp("timestampField").addTime("timeField").addDate("dateField").addDateTime("dateTimeField").addLocalDate("localDateField").addEnum("enumField", "firstValue", "secondValue", "thirdValue", "forthValue", "fifthValue").addFile("fileField").addBinary("binaryField");
        Table person = database.addTable("person", new TableOption[0]);
        Table company = database.addTable("company", new TableOption[0]);
        Table contract = database.addTable("contract", new TableOption[0]);
        person.addText("firstName").addText("lastName").addReference("company", company, false, "employees");
        company.addText("name").addReference("employees", person, true, "company").addReference("companyContracts", contract, true, "companies");
        contract.addEnum("contractType", "typeA", "typeB", "typeC").addText("title").addReference("companies", company, true, "companyContracts");
        Table personView = database.addView("personView", person);
        Table personView2 = database.addView("personView2", person);
        Table companyView = database.addView("companyView", company);
        personView.addText("firstName").addText("lastName").addReference("company", companyView, false);
        personView2.addText("lastName").addReference("company", companyView, false);
        companyView.addText("name").addReference("employees", personView, true);
        Table personWithViewRef = database.addTable("personWithViewRef", new TableOption[0]);
        personWithViewRef.addText("name").addInteger("value").addReference("companyView", companyView, false);
        Table cascadeTest1 = database.addTable("cascadeTest1", TableOption.CHECKPOINTS, TableOption.HIERARCHY, TableOption.TRACK_CREATION, TableOption.TRACK_MODIFICATION, TableOption.KEEP_DELETED);
        Table cascadeTest2 = database.addTable("cascadeTest2", TableOption.CHECKPOINTS, TableOption.HIERARCHY, TableOption.TRACK_CREATION, TableOption.TRACK_MODIFICATION, TableOption.KEEP_DELETED);
        Table cascadeTest3 = database.addTable("cascadeTest3NoKeep", TableOption.TRACK_CREATION, TableOption.TRACK_MODIFICATION);
        Table cascadeTest4 = database.addTable("cascadeTest4NoKeep", new TableOption[0]);
        Table cascadeTest5 = database.addTable("cascadeTest5NoKeep", new TableOption[0]);
        cascadeTest1.addText("name");
        cascadeTest1.addReference("ref2s", cascadeTest2, true, "ref1", true);
        cascadeTest1.addReference("otherRef2s", cascadeTest2, true, "otherRef1", false);
        cascadeTest1.addReference("ref3NoKeep", cascadeTest3, false, "ref1", true);
        cascadeTest1.addReference("ref4NoKeep", cascadeTest4, false, "ref1", true);
        cascadeTest1.addReference("ref5NoKeep", cascadeTest5, false, "ref1", false);
        cascadeTest2.addText("name");
        cascadeTest2.addReference("ref1", cascadeTest1, false, "ref2s", false);
        cascadeTest2.addReference("otherRef1", cascadeTest1, false, "otherRef2s", false);
        cascadeTest3.addText("name");
        cascadeTest3.addReference("ref1", cascadeTest1, false, "ref3NoKeep", false);
        cascadeTest4.addText("name");
        cascadeTest4.addReference("ref1", cascadeTest1, false, "ref4NoKeep", false);
        cascadeTest5.addText("name");
        cascadeTest5.addReference("ref1", cascadeTest1, false, "ref5NoKeep", true);
        Table entityA = database.addTable("entityA", new TableOption[0]);
        Table entityB = database.addTable("entityB", new TableOption[0]);
        entityA.addText("value").addReference("entityB", entityB, false, "entityA");
        entityB.addText("value").addReference("entityA", entityA, false, "entityB");
        return schema;
    }
}

