/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.log;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.teamapps.protocol.file.FileProvider;
import org.teamapps.protocol.file.FileSink;
import org.teamapps.protocol.schema.MessageObject;
import org.teamapps.protocol.schema.PojoObjectDecoder;
import org.teamapps.universaldb.index.log.ChunkedLogIndex;
import org.teamapps.universaldb.index.log.LocalFileStore;

public class ChunkedIndexMessageStore<TYPE extends MessageObject> {
    private final ChunkedLogIndex messageIndex;
    private final PojoObjectDecoder<TYPE> pojoObjectDecoder;
    private LocalFileStore fileStore;
    private BiConsumer<TYPE, Integer> messageIdHandler;

    public ChunkedIndexMessageStore(File path, String name, int entriesPerChunk, boolean rotatingLogIndex, boolean withFileStore, PojoObjectDecoder<TYPE> pojoObjectDecoder) {
        File basePath = new File(path, name);
        basePath.mkdir();
        this.messageIndex = new ChunkedLogIndex(basePath, "messages", entriesPerChunk, rotatingLogIndex);
        if (withFileStore) {
            this.fileStore = new LocalFileStore(basePath, "file-store");
        }
        this.pojoObjectDecoder = pojoObjectDecoder;
    }

    public void setMessageIdHandler(BiConsumer<TYPE, Integer> messageIdHandler) {
        this.messageIdHandler = messageIdHandler;
    }

    public synchronized long addMessage(TYPE message) {
        try {
            byte[] bytes = message.toBytes((FileSink)this.fileStore);
            if (this.messageIdHandler != null) {
                this.messageIdHandler.accept(message, this.messageIndex.getLogEntryCount() + 1);
            }
            return this.messageIndex.writeLog(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public TYPE readMessage(long position) {
        if (position >= 0L) {
            byte[] bytes = this.messageIndex.readLog(position);
            return (TYPE)this.pojoObjectDecoder.decode(bytes, (FileProvider)this.fileStore);
        }
        return null;
    }

    public List<TYPE> readLastMessages(int messageCount) {
        List<byte[]> bytes = this.messageIndex.readLastLogEntries(messageCount);
        return bytes.stream().map(b -> this.pojoObjectDecoder.decode(b, (FileProvider)this.fileStore)).collect(Collectors.toList());
    }

    public TYPE getLastMessage() {
        byte[] bytes = this.messageIndex.getLastEntry();
        return (TYPE)(bytes != null ? this.pojoObjectDecoder.decode(bytes, (FileProvider)this.fileStore) : null);
    }

    public void close() {
        this.messageIndex.close();
    }

    public int getMessageCount() {
        return this.messageIndex.getLogEntryCount();
    }

    public int getChunkCount() {
        return this.messageIndex.getChunkCount();
    }

    public int getMessagesInCurrentChunk() {
        return this.messageIndex.getMessagesInCurrentChunk();
    }
}

