/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.log;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.teamapps.universaldb.index.log.DefaultLogIndex;
import org.teamapps.universaldb.index.log.LogIndex;
import org.teamapps.universaldb.index.log.LogIterator;
import org.teamapps.universaldb.index.log.RotatingLogIndex;

public class ChunkedLogIndex {
    private final LogIndex logIndex;
    private final int entriesPerChunk;
    private long lastEntryPosition = -1L;
    private long[] chunks;
    private int currentChunkIndex;
    private int messagesInCurrentChunk;

    public ChunkedLogIndex(File path, String name, int entriesPerChunk, boolean rotatingLogIndex) {
        File basePath = new File(path, name);
        basePath.mkdir();
        this.logIndex = rotatingLogIndex ? new RotatingLogIndex(basePath, name) : new DefaultLogIndex(basePath, name);
        this.entriesPerChunk = entriesPerChunk;
        long[] logPositions = this.logIndex.readLogPositions();
        int totalEntries = logPositions.length;
        this.chunks = new long[Math.max(10000, totalEntries / entriesPerChunk * 2)];
        this.currentChunkIndex = 0;
        if (totalEntries > 0) {
            this.lastEntryPosition = logPositions[logPositions.length - 1];
            this.currentChunkIndex = -1;
            for (int i = 0; i < totalEntries; i += entriesPerChunk) {
                ++this.currentChunkIndex;
                this.chunks[this.currentChunkIndex] = logPositions[i];
            }
        }
        this.messagesInCurrentChunk = totalEntries - this.currentChunkIndex * entriesPerChunk;
    }

    public int getMessagesInCurrentChunk() {
        return this.messagesInCurrentChunk;
    }

    public synchronized long writeLog(byte[] bytes) {
        long position;
        this.lastEntryPosition = position = this.logIndex.writeLog(bytes);
        ++this.messagesInCurrentChunk;
        if (this.messagesInCurrentChunk > this.entriesPerChunk) {
            ++this.currentChunkIndex;
            if (this.currentChunkIndex == this.chunks.length) {
                long[] newChunks = new long[this.chunks.length * 2];
                System.arraycopy(this.chunks, 0, newChunks, 0, this.chunks.length);
                this.chunks = newChunks;
            }
            this.chunks[this.currentChunkIndex] = position;
            this.messagesInCurrentChunk = 1;
        }
        return position;
    }

    public byte[] readLog(long pos) {
        return this.logIndex.readLog(pos);
    }

    public byte[] getLastEntry() {
        if (this.lastEntryPosition >= 0L) {
            return this.logIndex.readLog(this.lastEntryPosition);
        }
        return null;
    }

    public List<byte[]> readLastLogEntries(int numberOfEntries) {
        int i;
        int chunkCount = ((numberOfEntries = Math.min(numberOfEntries, this.getLogEntryCount())) - 1) / this.entriesPerChunk;
        if (chunkCount * this.entriesPerChunk + this.messagesInCurrentChunk < numberOfEntries) {
            ++chunkCount;
        }
        int offset = chunkCount * this.entriesPerChunk + this.messagesInCurrentChunk - numberOfEntries;
        long startPos = this.getPositionByChunkChunkCount(chunkCount);
        LogIterator logIterator = this.logIndex.readLogs(startPos);
        ArrayList<byte[]> logs = new ArrayList<byte[]>();
        for (i = 0; i < offset; ++i) {
            logIterator.next();
        }
        for (i = 0; i < numberOfEntries; ++i) {
            logs.add(logIterator.next());
        }
        logIterator.closeSave();
        return logs;
    }

    public int getLogEntryCount() {
        return this.currentChunkIndex * this.entriesPerChunk + this.messagesInCurrentChunk;
    }

    public int getChunkCount() {
        return this.currentChunkIndex + 1;
    }

    public long getPositionByChunkChunkCount(int chunkCount) {
        return this.chunks[Math.max(0, this.currentChunkIndex - chunkCount)];
    }

    public void close() {
        this.logIndex.close();
    }

    public LogIndex getLogIndex() {
        return this.logIndex;
    }
}

