/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.log;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.teamapps.universaldb.index.log.IndexMessage;
import org.teamapps.universaldb.index.log.RotatingLogIndex;

public class LogIterator
implements Iterator<byte[]>,
AutoCloseable {
    private final List<File> logFiles;
    private int currentFileIndex = -1;
    private DataInputStream dis;
    private byte[] nextLog;
    private long currentReadPos;

    public LogIterator(List<File> logFiles, long startPosition, boolean rotatingLogIndex) {
        this.logFiles = logFiles;
        this.seekLogPosition(startPosition, rotatingLogIndex);
        this.readLog();
    }

    private void seekLogPosition(long startPosition, boolean rotatingLogIndex) {
        try {
            long skipBytes = startPosition;
            if (rotatingLogIndex) {
                this.currentFileIndex = RotatingLogIndex.getFileIndex(startPosition);
                int filePos = RotatingLogIndex.getFilePos(startPosition);
                if (this.currentFileIndex >= this.logFiles.size()) {
                    return;
                }
                skipBytes = filePos;
            } else {
                this.currentFileIndex = 0;
            }
            this.dis = new DataInputStream(new BufferedInputStream(new FileInputStream(this.logFiles.get(this.currentFileIndex)), 64000));
            if (skipBytes > 0L) {
                this.dis.skipNBytes(skipBytes);
                this.currentReadPos = RotatingLogIndex.calculatePosition(this.currentFileIndex, (int)skipBytes);
            } else if (!rotatingLogIndex) {
                this.dis.readInt();
                this.currentReadPos = 4L;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readLog() {
        try {
            this.nextLog = null;
            if (this.dis == null) {
                ++this.currentFileIndex;
                if (this.currentFileIndex >= this.logFiles.size()) {
                    return;
                }
                this.dis = new DataInputStream(new BufferedInputStream(new FileInputStream(this.logFiles.get(this.currentFileIndex)), 64000));
                this.currentReadPos = RotatingLogIndex.calculatePosition(this.currentFileIndex, 0);
            }
            int size = this.dis.readInt();
            this.currentReadPos += (long)(size + 4);
            byte[] bytes = new byte[size];
            this.dis.readFully(bytes);
            this.nextLog = bytes;
        }
        catch (EOFException ignore) {
            this.closeStream();
            this.dis = null;
            this.readLog();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readMessages(List<IndexMessage> messages) {
        if (messages.isEmpty() || this.logFiles.isEmpty()) {
            return;
        }
        long position = 0L;
        int index = 0;
        while (this.hasNext()) {
            IndexMessage message = messages.get(index);
            boolean addMessage = message.getPosition() == position || index == 0;
            position = this.currentReadPos;
            byte[] bytes = this.next();
            if (!addMessage) continue;
            message.setMessage(bytes);
            if (++index < messages.size()) continue;
            break;
        }
        messages.sort(Comparator.comparingInt(IndexMessage::getId));
        this.closeSave();
    }

    @Override
    public boolean hasNext() {
        if (this.nextLog != null) {
            return true;
        }
        this.closeStream();
        return false;
    }

    @Override
    public byte[] next() {
        byte[] bytes = this.nextLog;
        this.readLog();
        return bytes;
    }

    public long getCurrentReadPosition() {
        return this.currentReadPos;
    }

    @Override
    public void close() throws Exception {
        if (this.dis != null) {
            this.dis.close();
        }
    }

    public void closeSave() {
        try {
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void closeStream() {
        try {
            if (this.dis == null) {
                return;
            }
            this.dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

