/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.log;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.teamapps.protocol.file.FileProvider;
import org.teamapps.protocol.file.FileSink;
import org.teamapps.protocol.schema.MessageObject;
import org.teamapps.protocol.schema.PojoObjectDecoder;
import org.teamapps.universaldb.index.buffer.PrimitiveEntryAtomicStore;
import org.teamapps.universaldb.index.buffer.RecordIndex;
import org.teamapps.universaldb.index.log.IndexMessage;
import org.teamapps.universaldb.index.log.LocalFileStore;
import org.teamapps.universaldb.index.log.LogIndex;
import org.teamapps.universaldb.index.log.RotatingLogIndex;

public class MessageStore<TYPE extends MessageObject> {
    private final RecordIndex records;
    private final PrimitiveEntryAtomicStore messagePositionStore;
    private final LogIndex logIndex;
    private final LocalFileStore fileStore;
    private final PojoObjectDecoder<TYPE> pojoObjectDecoder;
    private final BiConsumer<TYPE, Integer> messageIdHandler;
    private final Function<TYPE, Integer> messageToIdFunction;

    public MessageStore(File path, String name, boolean withFileStore, PojoObjectDecoder<TYPE> pojoObjectDecoder, BiConsumer<TYPE, Integer> messageIdHandler, Function<TYPE, Integer> messageToIdFunction) {
        File basePath = new File(path, name);
        basePath.mkdir();
        this.records = new RecordIndex(basePath, "records");
        this.messagePositionStore = new PrimitiveEntryAtomicStore(basePath, "positions");
        this.logIndex = new RotatingLogIndex(basePath, "messages");
        this.fileStore = withFileStore ? new LocalFileStore(basePath, "file-store") : null;
        this.pojoObjectDecoder = pojoObjectDecoder;
        this.messageIdHandler = messageIdHandler;
        this.messageToIdFunction = messageToIdFunction;
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
    }

    public int getMessageCount() {
        return this.records.getCount();
    }

    private int getNextRecordId() {
        return this.records.createRecord();
    }

    public long getStoreSize() {
        return this.logIndex.getStoreSize();
    }

    public void saveMessage(TYPE message) {
        boolean create = false;
        Integer id = this.messageToIdFunction.apply(message);
        if (id == null || id == 0) {
            id = this.getNextRecordId();
            create = true;
        }
        this.addMessage(id, message, create);
    }

    public int addMessage(TYPE message) {
        int id = this.getNextRecordId();
        this.addMessage(id, message, true);
        return id;
    }

    private synchronized void addMessage(int id, TYPE message, boolean create) {
        try {
            if (create) {
                this.messageIdHandler.accept(message, id);
            }
            byte[] bytes = message.toBytes((FileSink)this.fileStore);
            long position = this.logIndex.writeLog(bytes);
            this.messagePositionStore.setLong(id, position);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void updateMessage(TYPE message) {
        Integer id = this.messageToIdFunction.apply(message);
        this.addMessage(id, message, false);
    }

    public void deleteMessage(TYPE message) {
        Integer id = this.messageToIdFunction.apply(message);
        this.deleteMessage(id);
    }

    public void deleteMessage(int id) {
        this.records.setBoolean(id, false);
        this.messagePositionStore.setLong(id, Math.abs(this.getMessagePositionStoreLong(id)) * -1L);
    }

    public void undeleteMessage(TYPE message) {
        Integer id = this.messageToIdFunction.apply(message);
        this.undeleteMessage(id);
    }

    public void undeleteMessage(int id) {
        this.records.setBoolean(id, true);
        this.messagePositionStore.setLong(id, Math.abs(this.getMessagePositionStoreLong(id)));
    }

    public TYPE readMessage(int id) {
        long position = this.getMessagePositionStoreLong(id);
        if (position >= 0L) {
            byte[] bytes = this.logIndex.readLog(position);
            return (TYPE)this.pojoObjectDecoder.decode(bytes, (FileProvider)this.fileStore);
        }
        return null;
    }

    private long getMessagePositionStoreLong(int id) {
        return this.messagePositionStore.getLong(id);
    }

    public List<TYPE> readLastMessages(int messageCount) {
        List<Integer> allRecords = this.records.getRecords();
        List<Integer> lastMessageIds = allRecords.subList(Math.max(allRecords.size() - messageCount, 0), allRecords.size());
        return this.readMessagesByMessageIds(lastMessageIds);
    }

    public List<TYPE> readAfterMessageId(int messageId) {
        return this.readAfterMessageId(messageId, Integer.MAX_VALUE);
    }

    public List<TYPE> readAfterMessageId(int messageId, int maxMessages) {
        List<Integer> messageIds = this.records.getRecords().stream().filter(id -> id > messageId).limit(maxMessages).collect(Collectors.toList());
        return this.readMessagesByMessageIds(messageIds);
    }

    public List<TYPE> readBeforeMessageId(int messageId, int messageCount) {
        List<Integer> messageIds = this.records.getRecords().stream().filter(id -> id < messageId).limit(messageCount).collect(Collectors.toList());
        return this.readMessagesByMessageIds(messageIds);
    }

    private List<TYPE> readMessagesByMessageIds(List<Integer> messageIds) {
        if (messageIds.isEmpty()) {
            return Collections.emptyList();
        }
        List<IndexMessage> indexMessages = messageIds.stream().map(id -> new IndexMessage((int)id, this.getMessagePositionStoreLong((int)id))).collect(Collectors.toList());
        return this.readIndexMessages(indexMessages);
    }

    private List<TYPE> readIndexMessages(List<IndexMessage> messages) {
        this.logIndex.readLogs(messages);
        return messages.stream().map(msg -> this.pojoObjectDecoder.decode(msg.getMessage(), (FileProvider)this.fileStore)).collect(Collectors.toList());
    }

    public List<TYPE> readAllMessages() {
        List<IndexMessage> indexMessages = this.records.getRecords().stream().map(id -> new IndexMessage((int)id, this.getMessagePositionStoreLong((int)id))).collect(Collectors.toList());
        return this.readIndexMessages(indexMessages);
    }

    public void close() {
        try {
            this.records.close();
            this.messagePositionStore.close();
            this.logIndex.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void drop() {
        try {
            this.records.drop();
            this.messagePositionStore.drop();
            this.logIndex.drop();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

