/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.transaction;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.index.buffer.PrimitiveEntryAtomicStore;
import org.teamapps.universaldb.index.log.DefaultLogIndex;
import org.teamapps.universaldb.index.log.LogIndex;
import org.teamapps.universaldb.index.log.LogIterator;
import org.teamapps.universaldb.index.log.RotatingLogIndex;
import org.teamapps.universaldb.index.transaction.resolved.ResolvedTransaction;
import org.teamapps.universaldb.index.transaction.schema.SchemaUpdate;
import org.teamapps.universaldb.schema.Schema;

public class TransactionIndex {
    private static final int FIRST_SYSTEM_START = 1;
    private static final int LAST_SYSTEM_START = 2;
    private static final int TIMESTAMP_SHUTDOWN = 3;
    private static final int LAST_TRANSACTION_ID = 4;
    private static final int LAST_TRANSACTION_STORE_ID = 5;
    private static final int LAST_TRANSACTION_REQUEST_ID = 6;
    private static final int TRANSACTIONS_COUNT = 7;
    private static final int NODE_ID = 8;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final File path;
    private LogIndex transactionLog;
    private LogIndex schemaLog;
    private PrimitiveEntryAtomicStore databaseStats;
    private volatile boolean active = true;
    private Schema currentSchema;

    public static void exportEmptyIndexWithModel(File baseInputPath, File baseOutputPath) {
        new TransactionIndex(baseInputPath, baseOutputPath);
    }

    private TransactionIndex(File basePath, File baseOutputPath) {
        this.path = new File(basePath, "transactions");
        this.path.mkdir();
        this.transactionLog = new RotatingLogIndex(this.path, "transactions");
        this.schemaLog = new DefaultLogIndex(this.path, "schemas");
        this.databaseStats = new PrimitiveEntryAtomicStore(this.path, "db-stats");
        List<SchemaUpdate> schemaUpdates = this.getSchemaUpdates();
        this.currentSchema = this.getSchemaUpdates().get(schemaUpdates.size() - 1).getSchema();
        try {
            TransactionIndex newTransactionIndex = new TransactionIndex(baseOutputPath);
            newTransactionIndex.writeSchemaUpdate(new SchemaUpdate(this.currentSchema, 0L, System.currentTimeMillis()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TransactionIndex(File basePath) {
        this.path = new File(basePath, "transactions");
        this.path.mkdir();
        this.transactionLog = new RotatingLogIndex(this.path, "transactions");
        this.schemaLog = new DefaultLogIndex(this.path, "schemas");
        this.databaseStats = new PrimitiveEntryAtomicStore(this.path, "db-stats");
        this.init();
        this.checkIndex();
    }

    private void init() {
        if (this.getNodeId() == 0L) {
            this.databaseStats.setLong(8, TransactionIndex.createId());
        }
        if (this.getSystemFirstStart() == 0L) {
            this.databaseStats.setLong(1, System.currentTimeMillis());
        }
        this.databaseStats.setLong(2, System.currentTimeMillis());
        if (!this.schemaLog.isEmpty()) {
            List<SchemaUpdate> schemaUpdates = this.getSchemaUpdates();
            this.currentSchema = this.getSchemaUpdates().get(schemaUpdates.size() - 1).getSchema();
        }
        logger.info(UniversalDB.SKIP_DB_LOGGING, "STARTED TRANSACTION INDEX: node-id: {}, last-transaction-id: {}, last-transaction-store-id: {}, transaction-count: {}, last-request-id: {}, schema-updates: {}", new Object[]{this.getNodeIdAsString(), this.getLastTransactionId(), this.getLastTransactionStoreId(), this.getTransactionCount(), this.getLastTransactionRequestId(), this.getSchemaUpdates().size()});
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.active = false;
                logger.info(UniversalDB.SKIP_DB_LOGGING, "SHUTTING DOWN TRANSACTION INDEX: node-id: {}, last-transaction-id: {}, last-transaction-store-id: {}, transaction-count: {}, last-request-id: {}", new Object[]{this.getNodeIdAsString(), this.getLastTransactionId(), this.getLastTransactionStoreId(), this.getTransactionCount(), this.getLastTransactionRequestId()});
                this.databaseStats.setLong(3, System.currentTimeMillis());
                this.transactionLog.close();
                this.schemaLog.close();
                this.databaseStats.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }));
    }

    private boolean checkIndex() {
        LogIterator logIterator = this.transactionLog.readLogs();
        long expectedTransactionId = 1L;
        boolean ok = true;
        logger.info(UniversalDB.SKIP_DB_LOGGING, "Checking transaction index...");
        while (logIterator.hasNext()) {
            ResolvedTransaction transaction = ResolvedTransaction.createResolvedTransaction(logIterator.next());
            if (expectedTransactionId != transaction.getTransactionId()) {
                logger.error(UniversalDB.SKIP_DB_LOGGING, "Wrong transaction id: {}, expected: {}", (Object)transaction.getTransactionId(), (Object)expectedTransactionId);
                ok = false;
            }
            expectedTransactionId = transaction.getTransactionId() + 1L;
        }
        logger.info(UniversalDB.SKIP_DB_LOGGING, "Transaction index check result: {}", (Object)ok);
        if (!ok) {
            throw new RuntimeException("Error in transaction log!");
        }
        return ok;
    }

    public boolean isEmpty() {
        return this.transactionLog.isEmpty();
    }

    public synchronized long createTransactionRequestId() {
        long requestId = this.getLastTransactionRequestId() + 1L;
        this.databaseStats.setLong(6, requestId);
        return requestId;
    }

    public long getSystemFirstStart() {
        return this.databaseStats.getLong(1);
    }

    public long getSystemLastStart() {
        return this.databaseStats.getLong(2);
    }

    public long getLastTransactionId() {
        return this.databaseStats.getLong(4);
    }

    public long getLastTransactionStoreId() {
        return this.databaseStats.getLong(5);
    }

    public long getTransactionCount() {
        return this.databaseStats.getLong(7);
    }

    public long getLastTransactionRequestId() {
        return this.databaseStats.getLong(6);
    }

    public long getNodeId() {
        return this.databaseStats.getLong(8);
    }

    public String getNodeIdAsString() {
        return Long.toHexString(this.getNodeId()).toUpperCase();
    }

    public ResolvedTransaction getLastTransaction() {
        if (this.transactionLog.isEmpty()) {
            return null;
        }
        byte[] bytes = this.transactionLog.readLog(this.getLastTransactionStoreId());
        return ResolvedTransaction.createResolvedTransaction(bytes);
    }

    public synchronized boolean isValidSchema(Schema schema) {
        if (this.currentSchema != null) {
            if (!this.currentSchema.isCompatibleWith(schema)) {
                return false;
            }
            Schema schemaCopy = Schema.parse(this.currentSchema.getSchemaDefinition());
            schemaCopy.merge(schema);
            schemaCopy.mapSchema();
            if (!schemaCopy.checkModel()) {
                return false;
            }
        }
        return true;
    }

    public synchronized boolean isSchemaUpdate(Schema schema) {
        if (this.currentSchema == null) {
            return true;
        }
        Schema schemaCopy = Schema.parse(this.currentSchema.getSchemaDefinition());
        schemaCopy.merge(schema);
        schemaCopy.mapSchema();
        return !this.currentSchema.getSchemaDefinition().equals(schemaCopy.getSchemaDefinition());
    }

    public synchronized void writeSchemaUpdate(SchemaUpdate schemaUpdate) throws IOException {
        this.schemaLog.writeLog(schemaUpdate.getBytes());
        this.currentSchema = schemaUpdate.getSchema();
        logger.info(UniversalDB.SKIP_DB_LOGGING, "Updating schema");
    }

    public synchronized Schema getCurrentSchema() {
        return this.currentSchema;
    }

    public synchronized void writeTransaction(ResolvedTransaction transaction) throws Exception {
        if (!this.active) {
            throw new RuntimeException("Error transaction index already shut down");
        }
        if (transaction.getTransactionId() != this.getLastTransactionId() + 1L) {
            throw new RuntimeException(String.format("Error wrong transaction id: %s, last transaction id: %s", transaction.getTransactionId(), this.getLastTransactionId()));
        }
        this.transactionLog.writeLog(transaction.getBytes());
        this.databaseStats.setLong(4, transaction.getTransactionId());
        this.databaseStats.setLong(5, this.transactionLog.getPosition());
        this.databaseStats.setLong(7, this.getTransactionCount() + 1L);
    }

    public synchronized List<SchemaUpdate> getSchemaUpdates() {
        if (this.schemaLog.isEmpty()) {
            return Collections.emptyList();
        }
        return this.schemaLog.readAllLogs().stream().map(SchemaUpdate::new).collect(Collectors.toList());
    }

    public Stream<ResolvedTransaction> getTransactions(long lastTransactionId) {
        LogIterator logIterator = this.transactionLog.readLogs();
        Stream<byte[]> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(logIterator, 16), false);
        return stream.map(ResolvedTransaction::createResolvedTransaction).filter(transaction -> transaction.getTransactionId() > lastTransactionId);
    }

    public LogIterator getLogIterator() {
        return this.transactionLog.readLogs();
    }

    private static long createId() {
        long id;
        SecureRandom secureRandom = new SecureRandom();
        while (Long.toHexString(id = Math.abs(secureRandom.nextLong())).length() != 16) {
        }
        return id;
    }
}

