/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.pojo;

import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.bool.BooleanFilter;
import org.teamapps.universaldb.index.bool.BooleanIndex;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.index.text.TextFilter;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.universaldb.pojo.EntityBitSetList;
import org.teamapps.universaldb.query.CustomEntityFilter;
import org.teamapps.universaldb.query.Filter;
import org.teamapps.universaldb.query.IndexFilter;
import org.teamapps.universaldb.query.IndexPath;
import org.teamapps.universaldb.query.OrFilter;
import org.teamapps.universaldb.query.RecordIdFilter;
import org.teamapps.universaldb.query.Sorting;
import org.teamapps.universaldb.record.EntityBuilder;

public class AbstractUdbQuery<ENTITY extends Entity<ENTITY>> {
    private final TableIndex tableIndex;
    private final EntityBuilder<ENTITY> entityBuilder;
    private Filter filter;

    public AbstractUdbQuery(TableIndex tableIndex, EntityBuilder<ENTITY> entityBuilder) {
        this.tableIndex = tableIndex;
        this.entityBuilder = entityBuilder;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void and(AbstractUdbQuery query) {
        Filter andFilter = query.getFilter();
        this.filter = this.filter == null ? andFilter : this.filter.and(andFilter);
    }

    public void prependPath(IndexPath path) {
        this.filter.prependPath(path);
    }

    public void or(Filter orFilter) {
        this.filter = this.filter == null ? orFilter : this.filter.or(orFilter);
    }

    public void and(Filter andFilter) {
        this.filter = this.filter == null ? andFilter : this.filter.and(andFilter);
    }

    public void and(IndexFilter andFilter) {
        this.filter = this.filter == null ? andFilter : this.filter.and(andFilter);
    }

    public void and(CustomEntityFilter andFilter) {
        this.filter = this.filter == null ? andFilter : this.filter.and(andFilter);
    }

    public void or(IndexFilter orFilter) {
        this.filter = this.filter == null ? orFilter : this.filter.or(orFilter);
    }

    public void andOr(AbstractUdbQuery ... orFilters) {
        OrFilter orFilter = new OrFilter();
        for (AbstractUdbQuery query : orFilters) {
            orFilter.or(query.getFilter());
        }
        this.filter = this.filter == null ? orFilter : this.filter.and(orFilter);
    }

    public void andOr(IndexFilter ... orFilters) {
        OrFilter orFilter = new OrFilter();
        for (IndexFilter filter : orFilters) {
            orFilter.or(filter);
        }
        this.filter = this.filter == null ? orFilter : this.filter.and(orFilter);
    }

    public BitSet filter(BitSet input) {
        if (this.filter == null) {
            return input;
        }
        return this.filter.filter(input);
    }

    public void addFullTextFilter(TextFilter textFilter, String ... fieldNames) {
        this.and(this.tableIndex.createFullTextFilter(textFilter, fieldNames));
    }

    public void addFullTextQuery(String query, String ... fieldNames) {
        this.and(this.tableIndex.createFullTextFilter(query, fieldNames));
    }

    public void addTextFilter(String columnName, TextFilter filter) {
        TextIndex textIndex = (TextIndex)this.tableIndex.getColumnIndex(columnName);
        IndexFilter indexFilter = textIndex.createFilter(filter);
        this.and(indexFilter);
    }

    public void addNumericFilter(String columnName, NumericFilter filter) {
        ColumnIndex columnIndex = this.tableIndex.getColumnIndex(columnName);
        IndexFilter indexFilter = columnIndex.createFilter(filter);
        this.and(indexFilter);
    }

    public void addBooleanFilter(String columnName, BooleanFilter booleanFilter) {
        BooleanIndex booleanIndex = (BooleanIndex)this.tableIndex.getColumnIndex(columnName);
        IndexFilter indexFilter = booleanIndex.createFilter(booleanFilter);
        this.and(indexFilter);
    }

    public List<ENTITY> execute() {
        BitSet result = this.filter(this.tableIndex.getRecordBitSet());
        return new EntityBitSetList<ENTITY>(this.entityBuilder, result);
    }

    public boolean matches(Entity<ENTITY> entity) {
        BitSet bitSet = new BitSet();
        bitSet.set(entity.getId());
        BitSet result = this.filter(bitSet);
        return result.get(entity.getId());
    }

    public List<ENTITY> execute(boolean deletedRecords) {
        return deletedRecords ? this.executeOnDeletedRecords() : this.execute();
    }

    public List<ENTITY> executeOnDeletedRecords() {
        if (!this.tableIndex.getTableConfig().keepDeleted()) {
            throw new RuntimeException("Query error: this table has no 'keep deleted' option set.");
        }
        BitSet result = this.filter(this.tableIndex.getDeletedRecordsBitSet());
        return new EntityBitSetList<ENTITY>(this.entityBuilder, result);
    }

    public ENTITY executeExpectSingleton() {
        BitSet result = this.filter(this.tableIndex.getRecordBitSet());
        int id = result.nextSetBit(1);
        if (id < 0) {
            return null;
        }
        return (ENTITY)((Entity)this.entityBuilder.build(id));
    }

    public void filterById(BitSet ids) {
        this.and(new RecordIdFilter(ids));
    }

    public void filterById(Collection<Integer> ids) {
        this.and(new RecordIdFilter(ids));
    }

    public BitSet executeToBitSet() {
        return this.filter(this.tableIndex.getRecordBitSet());
    }

    public List<ENTITY> execute(String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return this.execute(false, sortFieldName, ascending, userContext, path);
    }

    public List<ENTITY> execute(boolean deletedRecords, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        if (deletedRecords && !this.tableIndex.getTableConfig().keepDeleted()) {
            throw new RuntimeException("Query error: this table has no 'keep deleted' option set.");
        }
        BitSet recordBitSet = deletedRecords ? this.tableIndex.getDeletedRecordsBitSet() : this.tableIndex.getRecordBitSet();
        BitSet result = this.filter(recordBitSet);
        if (sortFieldName == null || sortFieldName.isBlank()) {
            return new EntityBitSetList<ENTITY>(this.entityBuilder, result);
        }
        return AbstractUdbEntity.sort(this.tableIndex, this.entityBuilder, result, sortFieldName, ascending, userContext, path);
    }

    public List<ENTITY> execute(int startIndex, int length, Sorting sorting, UserContext userContext) {
        if (sorting == null) {
            return this.execute().stream().skip(startIndex).limit(length).collect(Collectors.toList());
        }
        return this.execute(sorting.getSortFieldName(), sorting.getSortDirection().isAscending(), userContext, sorting.getSortFieldPath()).stream().skip(startIndex).limit(length).collect(Collectors.toList());
    }

    public TableIndex getTableIndex() {
        return this.tableIndex;
    }

    public EntityBuilder<ENTITY> getEntityBuilder() {
        return this.entityBuilder;
    }

    public String toString() {
        Filter filter = this.getFilter();
        if (filter == null) {
            return "EMPTY QUERY";
        }
        return filter.toString();
    }
}

