/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.generator;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.pojo.template.PojoTemplate;
import org.teamapps.universaldb.schema.Column;
import org.teamapps.universaldb.schema.Database;
import org.teamapps.universaldb.schema.Schema;
import org.teamapps.universaldb.schema.Table;

public class PojoCodeGenerator {
    public static final String UDB_PREFIX = "Udb";
    public static final String QUERY_SUFFIX = "Query";

    public void generateCode(Schema schema, File basePath) throws IOException {
        File baseDir = this.createBaseDir(basePath, schema.getPojoNamespace());
        this.createSchemaInterface(schema, baseDir);
        for (Database Database2 : schema.getDatabases()) {
            this.createDbPojos(Database2, baseDir, schema.getPojoNamespace());
        }
    }

    public void createSchemaInterface(Schema schema, File baseDir) throws IOException {
        PojoTemplate tpl = PojoTemplate.createSchemaInterface();
        tpl.setValue("package", schema.getPojoNamespace());
        String[] lines = schema.getSchemaDefinition().split("\n");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (i > 0) {
                sb.append(tpl.tabs(4));
            }
            if (i + 1 == lines.length) {
                sb.append("\"").append(line).append("\\n\";").append("\n");
                continue;
            }
            sb.append("\"").append(line).append("\\n\" + ").append("\n");
        }
        tpl.setValue("type", schema.getSchemaName());
        tpl.setValue("schema", sb.toString());
        tpl.writeTemplate(schema.getSchemaName(), baseDir);
    }

    private void createDbPojos(Database db, File baseDir, String packageName) throws IOException {
        File dbPojoDir = new File(baseDir, db.getName().toLowerCase());
        dbPojoDir.mkdir();
        for (Table table : db.getAllTables()) {
            this.createTablePojo(table, dbPojoDir, packageName + "." + db.getName().toLowerCase());
            this.createTableQueryPojo(table, dbPojoDir, packageName + "." + db.getName().toLowerCase());
        }
    }

    private void createTablePojo(Table table, File dbPojoDir, String packageName) throws IOException {
        PojoTemplate tpl = table.isView() ? PojoTemplate.createEntityViewInterface() : PojoTemplate.createEntityInterface();
        PojoTemplate udbTpl = table.isView() ? PojoTemplate.createUdbEntityView() : PojoTemplate.createUdbEntity();
        String type = tpl.firstUpper(table.getName());
        String udbType = UDB_PREFIX + type;
        String query = type + QUERY_SUFFIX;
        String udbQuery = UDB_PREFIX + query;
        String imports = "";
        tpl.setValue("package", packageName);
        tpl.setValue("type", type);
        tpl.setValue("udbType", udbType);
        tpl.setValue("query", query);
        tpl.setValue("udbQuery", udbQuery);
        tpl.setValue("imports", imports);
        udbTpl.setValue("package", packageName);
        udbTpl.setValue("type", type);
        udbTpl.setValue("udbType", udbType);
        udbTpl.setValue("imports", imports);
        ArrayList<CallSite> staticFieldNames = new ArrayList<CallSite>();
        ArrayList<Object> staticFields = new ArrayList<Object>();
        ArrayList<CallSite> staticFieldSetters = new ArrayList<CallSite>();
        staticFields.add("\tprotected static TableIndex table;");
        for (Column column : table.getColumns()) {
            String staticFieldName = "FIELD_" + tpl.createConstantName(column.getName());
            staticFieldNames.add((CallSite)((Object)("\tfinal static String " + staticFieldName + " = \"" + column.getName() + "\";")));
            staticFields.add("\tprotected static " + tpl.getIndexTypeName(column.getType()) + " " + column.getName() + ";");
            staticFieldSetters.add((CallSite)((Object)("\t\t" + column.getName() + " = (" + tpl.getIndexTypeName(column.getType()) + ") tableIndex.getColumnIndex(" + staticFieldName + ");")));
            int version = 0;
            boolean loop1 = true;
            boolean loop2 = true;
            boolean loop3 = true;
            boolean loop4 = true;
            while (loop1 || loop2 || loop3 || loop4) {
                loop1 = tpl.addInterfaceGetMethod(column, ++version);
                loop2 = !table.isView() ? tpl.addInterfaceSetMethod(column, table, version) : false;
                loop3 = udbTpl.addUdbEntityGetMethod(column, version);
                if (!table.isView()) {
                    loop4 = udbTpl.addUdbEntitySetMethod(column, table, version);
                    continue;
                }
                loop4 = false;
            }
            if (column.getType() != ColumnType.ENUM) continue;
            PojoTemplate enumTpl = PojoTemplate.createEnum();
            String enumType = enumTpl.firstUpper(column.getName());
            enumTpl.setValue("package", packageName);
            enumTpl.setValue("type", enumType);
            ArrayList<CallSite> enumValues = new ArrayList<CallSite>();
            for (String enumValue : column.getEnumValues()) {
                enumValues.add((CallSite)((Object)("\t" + enumTpl.createConstantName(enumValue) + ",")));
            }
            enumTpl.setValue("enumValues", enumValues.stream().collect(Collectors.joining("\n")));
            enumTpl.writeTemplate(enumType, dbPojoDir);
        }
        tpl.setValue("staticFieldNames", staticFieldNames.stream().collect(Collectors.joining("\n")));
        udbTpl.setValue("staticFields", staticFields.stream().collect(Collectors.joining("\n")));
        udbTpl.setValue("staticFieldSetters", staticFieldSetters.stream().collect(Collectors.joining("\n")));
        tpl.writeTemplate(type, dbPojoDir);
        udbTpl.writeTemplate(udbType, dbPojoDir);
    }

    private void createTableQueryPojo(Table table, File dbPojoDir, String packageName) throws IOException {
        PojoTemplate tpl = PojoTemplate.createQueryInterface();
        PojoTemplate udbTpl = PojoTemplate.createUdbQuery();
        String type = tpl.firstUpper(table.getName());
        String udbType = UDB_PREFIX + type;
        String query = type + QUERY_SUFFIX;
        String udbQuery = UDB_PREFIX + query;
        String imports = "";
        tpl.setValue("package", packageName);
        tpl.setValue("type", type);
        tpl.setValue("udbType", udbType);
        tpl.setValue("query", query);
        tpl.setValue("udbQuery", udbQuery);
        tpl.setValue("imports", imports);
        udbTpl.setValue("package", packageName);
        udbTpl.setValue("type", type);
        udbTpl.setValue("udbType", udbType);
        udbTpl.setValue("query", query);
        udbTpl.setValue("udbQuery", udbQuery);
        udbTpl.setValue("imports", imports);
        for (Column column : table.getColumns()) {
            tpl.addSubQueryInterfaceMethod(column, query);
            tpl.addQueryInterfaceMethod(column, query, false);
            tpl.addQueryInterfaceMethod(column, query, true);
            udbTpl.addUdbSubQueryMethod(column, query, type);
            udbTpl.addUdbQueryMethod(column, query, type, false);
            udbTpl.addUdbQueryMethod(column, query, type, true);
        }
        tpl.writeTemplate(query, dbPojoDir);
        udbTpl.writeTemplate(udbQuery, dbPojoDir);
    }

    private File createBaseDir(File basePath, String nameSpace) {
        nameSpace = nameSpace.toLowerCase();
        String[] parts = nameSpace.split("\\.");
        basePath.mkdir();
        File path = basePath;
        for (String part : parts) {
            path = new File(path, part);
            path.mkdir();
        }
        System.out.println("name-space:" + nameSpace + ", path:" + path.getPath());
        return path;
    }
}

