/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.buffer;

import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.agrona.concurrent.AtomicBuffer;
import org.teamapps.universaldb.index.buffer.AbstractBlockEntryAtomicStore;
import org.teamapps.universaldb.index.buffer.BlockChainEntry;
import org.teamapps.universaldb.index.buffer.BlockChainType;

public class BlockChainAtomicStore
extends AbstractBlockEntryAtomicStore {
    public BlockChainAtomicStore(File path, String name) {
        super(path, name);
    }

    public int getEntryCount(int id) {
        BlockChainEntry block = this.getBlock(this.getBlockPosition(id));
        return block != null ? block.getTotalCount() : 0;
    }

    @Override
    public boolean isEmpty(int id) {
        return this.getBlockPosition(id) == 0L;
    }

    public List<Integer> getEntries(int id) {
        long position = this.getBlockPosition(id);
        BlockChainEntry startEntry = this.getBlock(position);
        if (startEntry != null) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            startEntry.readBlockEntries(list);
            BlockChainEntry chainEntry = startEntry;
            while ((chainEntry = this.getNextBlock(chainEntry)) != null) {
                chainEntry.readBlockEntries(list);
            }
            if (position != this.getBlockPosition(id)) {
                return this.getEntries(id);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public boolean containsEntry(int id, int entry) {
        long position = this.getBlockPosition(id);
        BlockChainEntry startEntry = this.getBlock(position);
        if (startEntry != null) {
            if (startEntry.containsBlockEntry(entry)) {
                if (position != this.getBlockPosition(id)) {
                    return this.containsEntry(id, entry);
                }
                return true;
            }
            BlockChainEntry chainEntry = startEntry;
            while ((chainEntry = this.getNextBlock(chainEntry)) != null) {
                if (!chainEntry.containsBlockEntry(entry)) continue;
                if (position != this.getBlockPosition(id)) {
                    return this.containsEntry(id, entry);
                }
                return true;
            }
            if (position != this.getBlockPosition(id)) {
                return this.containsEntry(id, entry);
            }
        }
        return false;
    }

    public boolean containsEntry(int id, BitSet bitSet) {
        long position = this.getBlockPosition(id);
        BlockChainEntry startEntry = this.getBlock(position);
        if (startEntry != null) {
            if (startEntry.containsBlockEntry(bitSet)) {
                if (position != this.getBlockPosition(id)) {
                    return this.containsEntry(id, bitSet);
                }
                return true;
            }
            BlockChainEntry chainEntry = startEntry;
            while ((chainEntry = this.getNextBlock(chainEntry)) != null) {
                if (!chainEntry.containsBlockEntry(bitSet)) continue;
                if (position != this.getBlockPosition(id)) {
                    return this.containsEntry(id, bitSet);
                }
                return true;
            }
            if (position != this.getBlockPosition(id)) {
                return this.containsEntry(id, bitSet);
            }
        }
        return false;
    }

    public int removeEntries(int id, List<Integer> entries) {
        if (entries == null || entries.isEmpty()) {
            return 0;
        }
        HashSet<Integer> removeSet = new HashSet<Integer>(entries);
        long position = this.getBlockPosition(id);
        BlockChainEntry startEntry = this.getBlock(position);
        int removedEntryCount = 0;
        if (startEntry != null) {
            removedEntryCount += startEntry.removeBlockEntries(removeSet);
            BlockChainEntry chainEntry = startEntry;
            while ((chainEntry = this.getNextBlock(chainEntry)) != null) {
                removedEntryCount += chainEntry.removeBlockEntries(removeSet);
            }
            startEntry.subtractTotalCont(removedEntryCount);
            return removedEntryCount;
        }
        return 0;
    }

    public void removeEntry(int id, int value) {
        this.removeEntries(id, Collections.singletonList(value));
    }

    public void removeAllEntries(int id) {
        this.setEntries(id, null);
    }

    public void addEntries(int id, List<Integer> entries) {
        if (id <= 0 || entries == null || entries.isEmpty()) {
            return;
        }
        long position = this.getBlockPosition(id);
        if (position > 0L) {
            BlockChainEntry startEntry = this.getBlock(position);
            if (!startEntry.getChainType().isChain() && startEntry.getAvailableSpace() < entries.size()) {
                ArrayList<Integer> allEntries = new ArrayList<Integer>();
                startEntry.readBlockEntries(allEntries);
                allEntries.addAll(entries);
                this.setEntries(id, allEntries);
                return;
            }
            int length = Math.min(entries.size(), startEntry.getAvailableSpace());
            int writtenEntries = startEntry.writeBlockEntries(0, length, entries);
            BlockChainEntry previousEntry = startEntry;
            while (writtenEntries < entries.size()) {
                if (!previousEntry.getChainType().isChain()) {
                    throw new RuntimeException("Error: try to write to chain that is a single block, id:" + id + ", position:" + position);
                }
                BlockChainEntry block = previousEntry.getNextBlockPosition() > 0L ? this.getBlock(previousEntry.getNextBlockPosition()) : this.createBlock(previousEntry.getChainType());
                length = Math.min(entries.size() - writtenEntries, block.getAvailableSpace());
                if (length > 0) {
                    writtenEntries += block.writeBlockEntries(writtenEntries, length, entries);
                }
                previousEntry.writeNextBlockPosition(block.getPosition());
                previousEntry = block;
            }
            startEntry.addTotalCount(entries.size());
        } else {
            this.setEntries(id, entries);
        }
    }

    public void addEntry(int id, int value) {
        this.addEntries(id, Collections.singletonList(value));
    }

    public void setEntries(int id, List<Integer> entries) {
        if (id <= 0) {
            return;
        }
        long removePosition = this.getBlockPosition(id);
        if (entries != null && !entries.isEmpty()) {
            BlockChainEntry chainEntry;
            BlockChainType chainType = BlockChainType.getTypeBySize(entries.size());
            BlockChainEntry newEntry = this.createBlock(chainType);
            int length = Math.min(entries.size(), chainType.getItems());
            BlockChainEntry previousEntry = newEntry;
            for (int writtenEntries = newEntry.writeBlockEntries(0, length, entries); writtenEntries < entries.size(); writtenEntries += chainEntry.writeBlockEntries(writtenEntries, length, entries)) {
                chainEntry = this.createBlock(chainType);
                length = Math.min(entries.size() - writtenEntries, chainType.getItems());
                previousEntry.writeNextBlockPosition(chainEntry.getPosition());
                previousEntry = chainEntry;
            }
            newEntry.writeTotalCount(entries.size());
            this.setBlockPosition(id, newEntry.getPosition());
        } else {
            this.setBlockPosition(id, 0L);
        }
        if (removePosition > 0L) {
            while (removePosition > 0L) {
                BlockChainEntry block = this.getBlock(removePosition);
                assert (block != null);
                removePosition = block.getNextBlockPosition();
                block.clearEntry();
                this.removeBlock(block);
            }
        }
    }

    private BlockChainEntry getBlock(long position) {
        if (position <= 0L) {
            return null;
        }
        int bufferIndex = this.getBufferIndex(position);
        int offset = this.getOffset(position, bufferIndex);
        AtomicBuffer atomicBuffer = this.getBuffer(bufferIndex);
        int length = atomicBuffer.getInt(offset, byteOrder);
        BlockChainType chainType = BlockChainType.getTypeByLength(length);
        return new BlockChainEntry(position, offset, atomicBuffer, chainType, byteOrder);
    }

    private BlockChainEntry getNextBlock(BlockChainEntry entry) {
        long position = entry.getNextBlockPosition();
        if (position > 0L) {
            return this.getBlock(position);
        }
        return null;
    }

    private BlockChainEntry createBlock(BlockChainType chainType) {
        int length = chainType.getBlockLength();
        Long freeSlot = this.getFreeSlot(length);
        if (freeSlot != null) {
            long position = freeSlot;
            int bufferIndex = this.getBufferIndex(position);
            int offset = this.getOffset(position, bufferIndex);
            AtomicBuffer atomicBuffer = this.getBuffer(bufferIndex);
            if (atomicBuffer.getInt(offset) != -1 * length) {
                throw new RuntimeException("Try to reuse deleted block entry that already exists, pos:" + position + ", index:" + String.valueOf(this));
            }
            atomicBuffer.putInt(offset, length, byteOrder);
            return new BlockChainEntry(position, offset, atomicBuffer, chainType, byteOrder);
        }
        long position = this.findNextBlockPosition(this.getFreeSpacePosition(), length + 4);
        this.setFreeSpacePosition(position + (long)length + 4L);
        this.ensureCapacity(position + (long)length + 4L);
        int bufferIndex = this.getBufferIndex(position);
        int offset = this.getOffset(position, bufferIndex);
        AtomicBuffer atomicBuffer = this.getBuffer(bufferIndex);
        atomicBuffer.putInt(offset, length, byteOrder);
        return new BlockChainEntry(position, offset, atomicBuffer, chainType, byteOrder);
    }

    private void removeBlock(BlockChainEntry entry) {
        entry.clearEntry();
        this.removeEntry(entry.getPosition());
    }
}

