/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.message;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Set;
import org.teamapps.message.protocol.file.FileDataReader;
import org.teamapps.message.protocol.file.LocalFileStore;
import org.teamapps.message.protocol.message.Message;
import org.teamapps.message.protocol.model.PojoObjectDecoder;
import org.teamapps.universaldb.message.CloseableIterator;

public class MessageStoreIterator<MESSAGE extends Message>
implements CloseableIterator<MESSAGE> {
    private final File storeFile;
    private final PojoObjectDecoder<MESSAGE> messageDecoder;
    private final LocalFileStore localFileStore;
    private final DataInputStream dis;
    private final boolean readDeleted;
    private Set<Long> requestedPositions;
    private MESSAGE message;
    private long currentPosition;

    public MessageStoreIterator(boolean readDeleted, long startPos, File storeFile, PojoObjectDecoder<MESSAGE> messageDecoder, LocalFileStore localFileStore) throws IOException {
        this(null, readDeleted, startPos, storeFile, messageDecoder, localFileStore);
    }

    public MessageStoreIterator(Set<Long> requestedPositions, boolean readDeleted, long startPos, File storeFile, PojoObjectDecoder<MESSAGE> messageDecoder, LocalFileStore localFileStore) throws IOException {
        this.readDeleted = readDeleted;
        this.storeFile = storeFile;
        this.messageDecoder = messageDecoder;
        this.localFileStore = localFileStore;
        this.requestedPositions = requestedPositions;
        this.dis = new DataInputStream(new BufferedInputStream(new FileInputStream(storeFile), 8192));
        this.currentPosition = startPos > 4L ? startPos : 4L;
        this.dis.skipNBytes(this.currentPosition);
    }

    private void readNext() {
        while (!this.readMessage()) {
        }
    }

    private boolean readMessage() {
        try {
            boolean deleted = this.dis.readBoolean();
            long previousPos = this.dis.readLong();
            long nextPos = this.dis.readLong();
            int length = this.dis.readInt();
            byte[] bytes = new byte[length];
            this.dis.readFully(bytes);
            boolean skip = this.requestedPositions != null && !this.requestedPositions.contains(this.currentPosition);
            this.currentPosition += (long)(length + 21);
            if (skip || nextPos > 0L || this.readDeleted != deleted) {
                return false;
            }
            this.message = this.messageDecoder.decode(bytes, (FileDataReader)this.localFileStore);
            return true;
        }
        catch (EOFException eof) {
            this.closeSave();
            return true;
        }
        catch (IOException e) {
            this.closeSave();
            e.printStackTrace();
            return true;
        }
    }

    @Override
    public void close() throws Exception {
        this.dis.close();
    }

    @Override
    public boolean hasNext() {
        if (this.message == null) {
            this.readNext();
        }
        return this.message != null;
    }

    @Override
    public MESSAGE next() {
        MESSAGE result = this.message;
        this.message = null;
        return result;
    }
}

