/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.universaldb.TableConfig;
import org.teamapps.universaldb.index.MappedObject;
import org.teamapps.universaldb.schema.Schema;
import org.teamapps.universaldb.schema.Table;
import org.teamapps.universaldb.schema.TableOption;

public class Database
implements MappedObject {
    private final Schema schema;
    private final String name;
    private final List<Table> tables = new ArrayList<Table>();
    private int mappingId;

    public Database(Schema schema, String name) {
        this.schema = schema;
        this.name = name;
    }

    public Table addTable(String name, TableOption ... options) {
        List<TableOption> tableOptions = options == null ? Collections.emptyList() : Arrays.asList(options);
        return this.addTable(name, tableOptions);
    }

    public Table addTable(String name, List<TableOption> tableOptions) {
        Schema.checkName(name);
        Table table = new Table(this, name, TableConfig.create(tableOptions));
        return this.addTable(table);
    }

    public Table addTable(Table table) {
        this.tables.add(table);
        return table;
    }

    public Table addView(String name, String referencedTablePath) {
        Table view = new Table(this, name, TableConfig.create(new TableOption[0]), true, referencedTablePath);
        return this.addTable(view);
    }

    public Table addView(String name, Table referencedTable) {
        Table view = new Table(this, name, TableConfig.create(new TableOption[0]), true, referencedTable.getFQN());
        return this.addTable(view);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public List<Table> getAllTables() {
        return this.tables;
    }

    public List<Table> getTables() {
        return this.tables.stream().filter(table -> !table.isView()).collect(Collectors.toList());
    }

    public Table getTable(String name) {
        return this.tables.stream().filter(table -> !table.isView()).filter(table -> table.getName().equals(name)).findFirst().orElse(null);
    }

    public List<Table> getViewTables() {
        return this.tables.stream().filter(Table::isView).collect(Collectors.toList());
    }

    @Override
    public String getFQN() {
        return this.name;
    }

    @Override
    public int getMappingId() {
        return this.mappingId;
    }

    @Override
    public void setMappingId(int mappingId) {
        this.mappingId = mappingId;
    }

    public String createDefinition(boolean ignoreMapping) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append(" as DATABASE").append(this.createMappingDefinition(this.mappingId, ignoreMapping)).append("\n");
        this.tables.forEach(table -> sb.append(table.createDefinition(ignoreMapping)));
        return sb.toString();
    }

    protected String createMappingDefinition(int mappingId, boolean ignoreMapping) {
        if (mappingId == 0) {
            return "";
        }
        return " [" + mappingId + "]";
    }

    public boolean isCompatibleWith(Database database) {
        Map<String, Table> tableMap = this.tables.stream().collect(Collectors.toMap(Table::getName, table -> table));
        for (Table table2 : database.getTables()) {
            Table localTable = tableMap.get(table2.getName());
            if (localTable != null) {
                if (localTable.getMappingId() > 0 && table2.getMappingId() > 0 && localTable.getMappingId() != table2.getMappingId()) {
                    return false;
                }
                boolean compatibleWith = localTable.isCompatibleWith(table2);
                if (compatibleWith) continue;
                return false;
            }
            if (table2.getMappingId() == 0 || !this.getSchema().getMappingIds().contains(table2.getMappingId())) continue;
            return false;
        }
        return true;
    }

    public void merge(Database database) {
        if (!this.isCompatibleWith(database)) {
            throw new RuntimeException("Error: cannot merge incompatible databases:" + this.getName() + " with " + database.getName());
        }
        Map<String, Table> tableMap = this.tables.stream().collect(Collectors.toMap(Table::getName, table -> table));
        for (Table table2 : database.getTables()) {
            Table localTable = tableMap.get(table2.getName());
            if (localTable == null) {
                this.addTable(table2);
                continue;
            }
            if (localTable.getMappingId() == 0) {
                localTable.setMappingId(table2.getMappingId());
            }
            localTable.merge(table2);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Database: ").append(this.name).append("\n");
        for (Table table : this.tables) {
            sb.append(table.toString()).append("\n");
        }
        return sb.toString();
    }
}

