/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.log;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.message.protocol.file.FileDataReader;
import org.teamapps.message.protocol.file.FileDataWriter;
import org.teamapps.message.protocol.message.Message;
import org.teamapps.message.protocol.model.PojoObjectDecoder;
import org.teamapps.universaldb.index.buffer.PrimitiveEntryAtomicStore;
import org.teamapps.universaldb.index.buffer.RecordIndex;
import org.teamapps.universaldb.index.log.LocalFileStore;
import org.teamapps.universaldb.index.log.LogIndex;
import org.teamapps.universaldb.index.log.PositionIndexedMessage;
import org.teamapps.universaldb.index.log.RotatingLogIndex;

public class MessageStoreLEGACY<TYPE extends Message> {
    private final RecordIndex records;
    private final PrimitiveEntryAtomicStore messagePositionStore;
    private final LogIndex logIndex;
    private final LocalFileStore fileStore;
    private final PojoObjectDecoder<TYPE> pojoObjectDecoder;

    public MessageStoreLEGACY(File path, String name, boolean withFileStore, PojoObjectDecoder<TYPE> pojoObjectDecoder) {
        File basePath = new File(path, name);
        basePath.mkdir();
        this.records = new RecordIndex(basePath, "records");
        this.messagePositionStore = new PrimitiveEntryAtomicStore(basePath, "positions");
        this.logIndex = new RotatingLogIndex(basePath, "messages");
        this.fileStore = withFileStore ? new LocalFileStore(basePath, "file-store") : null;
        this.pojoObjectDecoder = pojoObjectDecoder;
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
    }

    public int getMessageCount() {
        return this.records.getCount();
    }

    private int getNextRecordId() {
        return this.records.createRecord();
    }

    public long getStoreSize() {
        return this.logIndex.getStoreSize();
    }

    public synchronized void saveMessage(TYPE message) {
        int recordId = message.getRecordId();
        if (recordId <= 0) {
            recordId = this.getNextRecordId();
            message.setRecordId(recordId);
        }
        this.addMessage(recordId, message);
    }

    private synchronized void addMessage(int id, TYPE message) {
        try {
            byte[] bytes = message.toBytes((FileDataWriter)this.fileStore);
            long position = this.logIndex.writeLog(bytes);
            this.messagePositionStore.setLong(id, position);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void deleteMessage(TYPE message) {
        this.deleteMessage(message.getRecordId());
    }

    public synchronized void deleteMessage(int id) {
        this.records.setBoolean(id, false);
        this.messagePositionStore.setLong(id, Math.abs(this.getMessagePosition(id)) * -1L);
    }

    public synchronized void undeleteMessage(TYPE message) {
        this.undeleteMessage(message.getRecordId());
    }

    public synchronized void undeleteMessage(int id) {
        this.records.setBoolean(id, true);
        this.messagePositionStore.setLong(id, Math.abs(this.getMessagePosition(id)));
    }

    public TYPE readMessage(int id) {
        long position = this.getMessagePosition(id);
        if (position >= 0L) {
            byte[] bytes = this.logIndex.readLog(position);
            return (TYPE)((Message)this.pojoObjectDecoder.decode(bytes, (FileDataReader)this.fileStore));
        }
        return null;
    }

    private long getMessagePosition(int id) {
        return this.messagePositionStore.getLong(id);
    }

    public List<TYPE> readLastMessages(int messageCount) {
        List<Integer> allRecords = this.records.getRecords();
        List<Integer> lastMessageIds = allRecords.subList(Math.max(allRecords.size() - messageCount, 0), allRecords.size());
        return this.readMessagesByMessageIds(lastMessageIds);
    }

    public List<TYPE> readAfterMessageId(int messageId) {
        return this.readAfterMessageId(messageId, Integer.MAX_VALUE);
    }

    public List<TYPE> readAfterMessageId(int messageId, int maxMessages) {
        List<Integer> messageIds = this.records.getRecords().stream().filter(id -> id > messageId).limit(maxMessages).collect(Collectors.toList());
        return this.readMessagesByMessageIds(messageIds);
    }

    public List<TYPE> readBeforeMessageId(int messageId, int messageCount) {
        List<Integer> messageIds = this.records.getRecords().stream().filter(id -> id < messageId).limit(messageCount).collect(Collectors.toList());
        return this.readMessagesByMessageIds(messageIds);
    }

    private List<TYPE> readMessagesByMessageIds(List<Integer> messageIds) {
        if (messageIds.isEmpty()) {
            return Collections.emptyList();
        }
        List<PositionIndexedMessage> positionIndexedMessages = messageIds.stream().map(id -> new PositionIndexedMessage((int)id, this.getMessagePosition((int)id))).collect(Collectors.toList());
        return this.readIndexMessages(positionIndexedMessages);
    }

    private List<TYPE> readIndexMessages(List<PositionIndexedMessage> messages) {
        this.logIndex.readLogs(messages);
        return messages.stream().map(msg -> (Message)this.pojoObjectDecoder.decode(msg.getMessage(), (FileDataReader)this.fileStore)).collect(Collectors.toList());
    }

    public List<TYPE> readAllMessages() {
        List<PositionIndexedMessage> positionIndexedMessages = this.records.getRecords().stream().map(id -> new PositionIndexedMessage((int)id, this.getMessagePosition((int)id))).collect(Collectors.toList());
        return this.readIndexMessages(positionIndexedMessages);
    }

    public void close() {
        try {
            this.records.close();
            this.messagePositionStore.close();
            this.logIndex.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void drop() {
        try {
            this.records.drop();
            this.messagePositionStore.drop();
            this.logIndex.drop();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

