/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.reference.multi;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.AbstractIndex;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.FullTextIndexingOptions;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.buffer.BlockChainAtomicStore;
import org.teamapps.universaldb.index.reference.CyclicReferenceUpdate;
import org.teamapps.universaldb.index.reference.ReferenceIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceFilter;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.reference.value.MultiReferenceEditValue;
import org.teamapps.universaldb.index.reference.value.MultiReferenceValue;
import org.teamapps.universaldb.index.reference.value.RecordReference;
import org.teamapps.universaldb.index.reference.value.ReferenceIteratorValue;
import org.teamapps.universaldb.index.reference.value.ResolvedMultiReferenceUpdate;

public class MultiReferenceIndex
extends AbstractIndex<MultiReferenceValue, MultiReferenceFilter>
implements ReferenceIndex {
    private final BlockChainAtomicStore referenceStore;
    private TableIndex referencedTable;
    private boolean cyclicReferences;
    private boolean cascadeDeleteReferences;
    private SingleReferenceIndex reverseSingleIndex;
    private MultiReferenceIndex reverseMultiIndex;
    private boolean ensureNoDuplicates = true;

    public MultiReferenceIndex(String name, TableIndex table, ColumnType columnType) {
        super(name, table, columnType, FullTextIndexingOptions.NOT_INDEXED);
        this.referenceStore = new BlockChainAtomicStore(table.getDataPath(), name);
    }

    public void setReferencedTable(TableIndex referencedTable, ColumnIndex reverseIndex, boolean cascadeDeleteReferences) {
        this.referencedTable = referencedTable;
        if (reverseIndex != null) {
            if (reverseIndex instanceof SingleReferenceIndex) {
                this.reverseSingleIndex = (SingleReferenceIndex)reverseIndex;
            } else {
                this.reverseMultiIndex = (MultiReferenceIndex)reverseIndex;
            }
            this.cyclicReferences = true;
        }
        this.cascadeDeleteReferences = cascadeDeleteReferences;
    }

    @Override
    public IndexType getType() {
        return IndexType.MULTI_REFERENCE;
    }

    @Override
    public TableIndex getReferencedTable() {
        return this.referencedTable;
    }

    @Override
    public boolean isCascadeDeleteReferences() {
        return this.cascadeDeleteReferences;
    }

    @Override
    public boolean isMultiReference() {
        return true;
    }

    @Override
    public ColumnIndex getReferencedColumn() {
        if (this.reverseSingleIndex != null) {
            return this.reverseSingleIndex;
        }
        return this.reverseMultiIndex;
    }

    @Override
    public MultiReferenceValue getGenericValue(int id) {
        List<Integer> entries = this.referenceStore.getEntries(id);
        return entries != null ? new ReferenceIteratorValue(entries) : null;
    }

    @Override
    public void setGenericValue(int id, MultiReferenceValue value) {
        if (value != null && value.isEditValue()) {
            this.setReferenceEditValue(id, (MultiReferenceEditValue)value);
        }
    }

    @Override
    public void removeValue(int id) {
        this.removeAllReferences(id, false);
    }

    @Override
    public boolean isEmpty(int id) {
        return this.referenceStore.isEmpty(id);
    }

    public int getReferencesCount(int id) {
        return this.referenceStore.getEntryCount(id);
    }

    public List<Integer> getReferencesAsList(int id) {
        return this.referenceStore.getEntries(id);
    }

    public boolean containsReference(int id, int reference) {
        return this.referenceStore.containsEntry(id, reference);
    }

    public boolean containsReference(int id, BitSet reference) {
        return this.referenceStore.containsEntry(id, reference);
    }

    public BitSet getReferencesAsBitSet(int id) {
        BitSet bitSet = new BitSet();
        List<Integer> entries = this.referenceStore.getEntries(id);
        if (entries != null) {
            entries.forEach(bitSet::set);
        }
        return bitSet;
    }

    public List<CyclicReferenceUpdate> setReferenceEditValue(int id, MultiReferenceEditValue editValue) {
        ArrayList<CyclicReferenceUpdate> cyclicReferenceUpdates = new ArrayList<CyclicReferenceUpdate>();
        if (!editValue.getSetReferences().isEmpty()) {
            List<Integer> references = RecordReference.createRecordIdsList(editValue.getSetReferences());
            List<CyclicReferenceUpdate> cyclicUpdates = this.setReferences(id, references, false);
            cyclicReferenceUpdates.addAll(cyclicUpdates);
        } else if (editValue.isRemoveAll()) {
            List<CyclicReferenceUpdate> cyclicUpdates = this.removeAllReferences(id, false);
            cyclicReferenceUpdates.addAll(cyclicUpdates);
            if (!editValue.getAddReferences().isEmpty()) {
                List<Integer> references = RecordReference.createRecordIdsList(editValue.getAddReferences());
                cyclicUpdates = this.addReferences(id, references, false);
                cyclicReferenceUpdates.addAll(cyclicUpdates);
            }
        } else {
            List<CyclicReferenceUpdate> cyclicUpdates;
            List<Integer> references;
            if (!editValue.getRemoveReferences().isEmpty()) {
                references = RecordReference.createRecordIdsList(editValue.getRemoveReferences());
                cyclicUpdates = this.removeReferences(id, references, false);
                cyclicReferenceUpdates.addAll(cyclicUpdates);
            }
            if (!editValue.getAddReferences().isEmpty()) {
                references = RecordReference.createRecordIdsList(editValue.getAddReferences());
                cyclicUpdates = this.addReferences(id, references, false);
                cyclicReferenceUpdates.addAll(cyclicUpdates);
            }
        }
        return cyclicReferenceUpdates;
    }

    public void setResolvedReferenceEditValue(int id, ResolvedMultiReferenceUpdate editValue) {
        switch (editValue.getType()) {
            case REMOVE_ALL_REFERENCES: {
                this.removeAllReferences(id, false);
                break;
            }
            case SET_REFERENCES: {
                this.setReferences(id, editValue.getSetReferences(), false);
                break;
            }
            case ADD_REMOVE_REFERENCES: {
                this.removeReferences(id, editValue.getRemoveReferences(), false);
                this.addReferences(id, editValue.getAddReferences(), false);
            }
        }
    }

    public List<CyclicReferenceUpdate> setReferences(int id, List<Integer> references, boolean cyclic) {
        List<Integer> previousEntries;
        ArrayList<CyclicReferenceUpdate> cyclicReferenceUpdates = new ArrayList<CyclicReferenceUpdate>();
        if (this.cyclicReferences && !cyclic && !(previousEntries = this.referenceStore.getEntries(id)).isEmpty()) {
            this.removeCyclicReferences(id, previousEntries, cyclicReferenceUpdates);
        }
        this.referenceStore.setEntries(id, references);
        if (this.cyclicReferences && !cyclic) {
            this.addCyclicReferences(id, references, cyclicReferenceUpdates);
        }
        return cyclicReferenceUpdates;
    }

    public List<CyclicReferenceUpdate> addReferences(int id, List<Integer> references, boolean cyclic) {
        ArrayList<CyclicReferenceUpdate> cyclicReferenceUpdates = new ArrayList<CyclicReferenceUpdate>();
        if (this.ensureNoDuplicates && !this.referenceStore.isEmpty(id)) {
            HashSet<Integer> existingSet = new HashSet<Integer>(this.referenceStore.getEntries(id));
            references = references.stream().filter(value -> !existingSet.contains(value)).collect(Collectors.toList());
        }
        this.referenceStore.addEntries(id, references);
        if (this.cyclicReferences && !cyclic) {
            this.addCyclicReferences(id, references, cyclicReferenceUpdates);
        }
        return cyclicReferenceUpdates;
    }

    public List<CyclicReferenceUpdate> removeReferences(int id, List<Integer> references, boolean cyclic) {
        ArrayList<CyclicReferenceUpdate> cyclicReferenceUpdates = new ArrayList<CyclicReferenceUpdate>();
        if (this.referenceStore.isEmpty(id)) {
            return cyclicReferenceUpdates;
        }
        this.referenceStore.removeEntries(id, references);
        if (this.cyclicReferences && !cyclic) {
            this.removeCyclicReferences(id, references, cyclicReferenceUpdates);
        }
        return cyclicReferenceUpdates;
    }

    public List<CyclicReferenceUpdate> removeAllReferences(int id, boolean cyclic) {
        ArrayList<CyclicReferenceUpdate> cyclicReferenceUpdates = new ArrayList<CyclicReferenceUpdate>();
        if (this.referenceStore.isEmpty(id)) {
            return cyclicReferenceUpdates;
        }
        if (cyclic || !this.cyclicReferences) {
            this.referenceStore.removeAllEntries(id);
        } else {
            List<Integer> removeEntries = this.referenceStore.getEntries(id);
            this.referenceStore.removeAllEntries(id);
            this.removeCyclicReferences(id, removeEntries, cyclicReferenceUpdates);
        }
        return cyclicReferenceUpdates;
    }

    private void addCyclicReferences(int id, List<Integer> references, List<CyclicReferenceUpdate> cyclicReferenceUpdates) {
        if (this.reverseSingleIndex != null) {
            for (Integer reference : references) {
                int previousValue = this.reverseSingleIndex.getValue(reference);
                if (previousValue > 0 && previousValue != id) {
                    this.removeReferences(previousValue, Collections.singletonList(reference), true);
                }
                this.reverseSingleIndex.setIndexValue(reference, id);
                cyclicReferenceUpdates.add(new CyclicReferenceUpdate(this.reverseSingleIndex, false, reference, id));
            }
        } else {
            for (Integer reference : references) {
                this.reverseMultiIndex.addReferences(reference, Collections.singletonList(id), true);
                cyclicReferenceUpdates.add(new CyclicReferenceUpdate(this.reverseMultiIndex, false, reference, id));
            }
        }
    }

    private void removeCyclicReferences(int id, List<Integer> references, List<CyclicReferenceUpdate> cyclicReferenceUpdates) {
        if (this.reverseSingleIndex != null) {
            for (Integer reference : references) {
                int previousValue = this.reverseSingleIndex.getValue(reference);
                if (id != previousValue) continue;
                this.reverseSingleIndex.setIndexValue(reference, 0);
                cyclicReferenceUpdates.add(new CyclicReferenceUpdate(this.reverseSingleIndex, true, reference, id));
            }
        } else {
            for (Integer reference : references) {
                this.reverseMultiIndex.removeReferences(reference, Collections.singletonList(id), true);
                cyclicReferenceUpdates.add(new CyclicReferenceUpdate(this.reverseMultiIndex, true, reference, id));
            }
        }
    }

    @Override
    public List<SortEntry> sortRecords(List<SortEntry> sortEntries, boolean ascending, UserContext userContext) {
        int order = ascending ? 1 : -1;
        sortEntries.sort((o1, o2) -> {
            int value1 = this.getReferencesCount(o1.getLeafId());
            int value2 = this.getReferencesCount(o2.getLeafId());
            return Integer.compare(value1, value2) * order;
        });
        return sortEntries;
    }

    @Override
    public void dumpIndex(DataOutputStream dataOutputStream, BitSet records) throws IOException {
        int id = records.nextSetBit(0);
        while (id >= 0) {
            List<Integer> references = this.getReferencesAsList(id);
            dataOutputStream.writeInt(id);
            dataOutputStream.writeInt(references.size());
            for (Integer reference : references) {
                dataOutputStream.writeInt(reference);
            }
            id = records.nextSetBit(id + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreIndex(DataInputStream dataInputStream) throws IOException {
        boolean cyclicReferencesValue = this.cyclicReferences;
        this.cyclicReferences = false;
        try {
            int id = dataInputStream.readInt();
            int count = dataInputStream.readInt();
            ArrayList<Integer> references = new ArrayList<Integer>();
            for (int i = 0; i < count; ++i) {
                references.add(dataInputStream.readInt());
            }
            this.setReferences(id, references, true);
        }
        catch (EOFException eOFException) {
        }
        finally {
            this.cyclicReferences = cyclicReferencesValue;
        }
    }

    @Override
    public BitSet filter(BitSet records, MultiReferenceFilter filter) {
        switch (filter.getType()) {
            case EQUALS: {
                return this.filterEquals(records, filter.getReferencesSet());
            }
            case NOT_EQUALS: {
                return this.filterNotEquals(records, filter.getReferencesSet());
            }
            case IS_EMPTY: {
                return this.filterIsEmpty(records);
            }
            case IS_NOT_EMPTY: {
                return this.filterIsNotEmpty(records);
            }
            case CONTAINS_ANY: {
                return this.filterContainsAny(records, filter.getReferencesSet());
            }
            case CONTAINS_NONE: {
                return this.filterContainsNone(records, filter.getReferencesSet());
            }
            case CONTAINS_ALL: {
                return this.filterContainsAll(records, filter.getReferencesSet());
            }
            case CONTAINS_ANY_NOT: {
                return this.filterContainsAnyNot(records, filter.getReferencesSet());
            }
            case ENTRY_COUNT_EQUALS: {
                return this.filterEntryCountEquals(records, filter.getCountFilter());
            }
            case ENTRY_COUNT_GREATER: {
                return this.filterEntryCountGreater(records, filter.getCountFilter());
            }
            case ENTRY_COUNT_LESSER: {
                return this.filterEntryCountSmaller(records, filter.getCountFilter());
            }
        }
        return null;
    }

    @Override
    public void close() {
        this.referenceStore.close();
    }

    @Override
    public void drop() {
        this.referenceStore.drop();
    }

    public BitSet filterEquals(BitSet bitSet, Set<Integer> compareIds) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            HashSet<Integer> referenceSet;
            int count = this.referenceStore.getEntryCount(id);
            if (count == compareIds.size() && (referenceSet = new HashSet<Integer>(this.referenceStore.getEntries(id))).equals(compareIds)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterNotEquals(BitSet bitSet, Set<Integer> compareIds) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int count = this.referenceStore.getEntryCount(id);
            if (count != compareIds.size()) {
                result.set(id);
            } else {
                HashSet<Integer> referenceSet = new HashSet<Integer>(this.referenceStore.getEntries(id));
                if (!referenceSet.equals(compareIds)) {
                    result.set(id);
                }
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterIsEmpty(BitSet bitSet) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            if (this.referenceStore.isEmpty(id)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterIsNotEmpty(BitSet bitSet) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            if (!this.referenceStore.isEmpty(id)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    private BitSet filterContainsAny(BitSet bitSet, Set<Integer> compareIds) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            List<Integer> entries = this.referenceStore.getEntries(id);
            for (Integer entry : entries) {
                if (!compareIds.contains(entry)) continue;
                result.set(id);
                break;
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    private BitSet filterContainsNone(BitSet bitSet, Set<Integer> compareIds) {
        BitSet result = this.filterContainsAny(bitSet, compareIds);
        return MultiReferenceIndex.negateInput(bitSet, result);
    }

    public BitSet filterContainsAll(BitSet bitSet, Set<Integer> compareIds) {
        BitSet result = new BitSet();
        BitSet compareSet = new BitSet();
        compareIds.forEach(compareSet::set);
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            BitSet referencesAsBitSet = this.getReferencesAsBitSet(id);
            referencesAsBitSet.and(compareSet);
            if (referencesAsBitSet.equals(compareSet)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterContainsAnyNot(BitSet bitSet, Set<Integer> compareIds) {
        BitSet containsAll = this.filterContainsAll(bitSet, compareIds);
        return MultiReferenceIndex.negateInput(bitSet, containsAll);
    }

    public BitSet filterEntryCountEquals(BitSet bitSet, int count) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            if (this.referenceStore.getEntryCount(id) == count) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterEntryCountGreater(BitSet bitSet, int count) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            if (this.referenceStore.getEntryCount(id) > count) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterEntryCountSmaller(BitSet bitSet, int count) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            if (this.referenceStore.getEntryCount(id) < count) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }
}

