/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.text;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.teamapps.universaldb.index.file.FileUtil;
import org.teamapps.universaldb.index.text.FullTextIndexValue;
import org.teamapps.universaldb.index.text.SearchCollector;
import org.teamapps.universaldb.index.text.SearchIndexUtil;
import org.teamapps.universaldb.index.text.TextFieldFilter;
import org.teamapps.universaldb.index.translation.TranslatableText;

public class CollectionTextSearchIndex {
    public static final String ID = "id";
    private String name;
    private File dir;
    private IndexWriter writer;
    private Analyzer queryAnalyzer;
    private StringField idSearchField;
    private NumericDocValuesField idField;
    private FieldType fieldType;

    public CollectionTextSearchIndex(File path, String name) {
        try {
            this.name = name;
            this.dir = new File(path, name);
            FSDirectory directory = FSDirectory.open((Path)this.dir.toPath());
            StandardAnalyzer analyzer = new StandardAnalyzer();
            this.queryAnalyzer = new StandardAnalyzer();
            IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)analyzer);
            iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            iwc.setRAMBufferSizeMB(32.0);
            this.writer = new IndexWriter((Directory)directory, iwc);
            this.idSearchField = new StringField(ID, "", Field.Store.NO);
            this.idField = new NumericDocValuesField(ID, 0L);
            this.fieldType = SearchIndexUtil.createIndexFieldType();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.commit(true)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setRecordValues(int id, List<FullTextIndexValue> values, boolean update) {
        try {
            this.idSearchField.setStringValue("" + id);
            this.idField.setLongValue((long)id);
            Document doc = new Document();
            doc.add((IndexableField)this.idSearchField);
            doc.add((IndexableField)this.idField);
            for (FullTextIndexValue fullTextIndexValue : values) {
                if (fullTextIndexValue.isTranslatableText()) {
                    TranslatableText translatableText = fullTextIndexValue.getTranslatableText();
                    Map<String, String> translationMap = translatableText.getTranslationMap();
                    for (String language : translationMap.keySet()) {
                        String value = translationMap.get(language) != null ? translationMap.get(language) : "";
                        Field field = new Field(fullTextIndexValue.getFieldName() + "_" + language, (CharSequence)value, (IndexableFieldType)this.fieldType);
                        doc.add((IndexableField)field);
                    }
                    Field field = new Field(fullTextIndexValue.getFieldName(), (CharSequence)translatableText.getText(), (IndexableFieldType)this.fieldType);
                    doc.add((IndexableField)field);
                    continue;
                }
                Field field = new Field(fullTextIndexValue.getFieldName(), (CharSequence)fullTextIndexValue.getValueNonNull(), (IndexableFieldType)this.fieldType);
                doc.add((IndexableField)field);
            }
            if (update) {
                Term term = new Term(ID, "" + id);
                this.writer.updateDocument(term, (Iterable)doc);
            } else {
                this.writer.addDocument((Iterable)doc);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setFileContent(int id, String fieldName, String content, boolean update) {
        try {
            this.idSearchField.setStringValue(id + "-" + fieldName);
            this.idField.setLongValue((long)id);
            Document doc = new Document();
            doc.add((IndexableField)this.idSearchField);
            doc.add((IndexableField)this.idField);
            doc.add((IndexableField)new Field(fieldName, (CharSequence)content, (IndexableFieldType)this.fieldType));
            if (update) {
                Term term = new Term(ID, "" + id);
                this.writer.updateDocument(term, (Iterable)doc);
            } else {
                this.writer.addDocument((Iterable)doc);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void delete(int id, List<String> fileFieldNames) {
        try {
            Term term = new Term(ID, "" + id);
            this.writer.deleteDocuments(new Term[]{term});
            if (fileFieldNames != null && !fileFieldNames.isEmpty()) {
                for (String name : fileFieldNames) {
                    Term fileFieldTerm = new Term(ID, id + "-" + name);
                    this.writer.deleteDocuments(new Term[]{fileFieldTerm});
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public BitSet filter(BitSet bitSet, List<TextFieldFilter> filters, boolean andFilter) {
        try {
            if (filters == null || filters.isEmpty()) {
                return bitSet;
            }
            DirectoryReader reader = DirectoryReader.open((IndexWriter)this.writer, (boolean)false, (boolean)false);
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            SearchCollector collector = new SearchCollector();
            BooleanClause.Occur occur = andFilter ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD;
            BooleanQuery.Builder fieldQueries = new BooleanQuery.Builder();
            for (TextFieldFilter filter : filters) {
                if (filter.isTranslatableField()) {
                    BooleanQuery.Builder translatableQueries = new BooleanQuery.Builder();
                    Query originalLanguage = SearchIndexUtil.createQuery(filter.getFilterType(), filter.getFieldName(), filter.getValue(), this.queryAnalyzer);
                    translatableQueries.add(originalLanguage, BooleanClause.Occur.SHOULD);
                    for (String language : filter.getRankedLanguages()) {
                        Query query = SearchIndexUtil.createQuery(filter.getFilterType(), filter.getFieldName() + "_" + language, filter.getValue(), this.queryAnalyzer);
                        translatableQueries.add(query, BooleanClause.Occur.SHOULD);
                    }
                    fieldQueries.add((Query)translatableQueries.build(), occur);
                    continue;
                }
                Query query = SearchIndexUtil.createQuery(filter.getFilterType(), filter.getFieldName(), filter.getValue(), this.queryAnalyzer);
                fieldQueries.add(query, occur);
            }
            BooleanQuery query = fieldQueries.build();
            searcher.search((Query)query, (Collector)collector);
            BitSet resultIds = collector.getResultIds();
            resultIds.and(bitSet);
            reader.close();
            return resultIds;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized void commit(boolean close) {
        try {
            if (this.writer != null && this.writer.isOpen()) {
                this.writer.commit();
                if (close) {
                    this.writer.close();
                    this.writer = null;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public int getMaxDoc() {
        if (this.writer == null) {
            return -1;
        }
        return this.writer.getDocStats().maxDoc;
    }

    public void deleteAllDocuments() throws IOException {
        this.writer.deleteAll();
        this.writer.commit();
    }

    public void drop() {
        this.commit(true);
        FileUtil.deleteFileRecursive(this.dir);
    }
}

