/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.transaction.resolved;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teamapps.universaldb.index.transaction.TransactionType;
import org.teamapps.universaldb.index.transaction.request.TransactionRequest;
import org.teamapps.universaldb.index.transaction.resolved.ResolvedTransactionRecord;
import org.teamapps.universaldb.index.transaction.schema.SchemaUpdate;
import org.teamapps.universaldb.schema.Schema;
import org.teamapps.universaldb.util.DataStreamUtil;

public class ResolvedTransaction {
    private final long nodeId;
    private final long requestId;
    private final long transactionId;
    private final TransactionType transactionType;
    private final int userId;
    private final long timestamp;
    private final List<ResolvedTransactionRecord> transactionRecords;
    private Schema schema;
    private Map<Integer, Integer> recordIdByCorrelationId;

    public static ResolvedTransaction createResolvedTransaction(byte[] bytes) {
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            return new ResolvedTransaction(dis);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot parse transaction", e);
        }
    }

    public static ResolvedTransaction createFromRequest(long transactionId, TransactionRequest request) {
        if (request.getTransactionType() == TransactionType.DATA_UPDATE) {
            return new ResolvedTransaction(request.getNodeId(), request.getRequestId(), transactionId, request.getUserId(), request.getTimestamp());
        }
        return new ResolvedTransaction(request.getNodeId(), request.getRequestId(), transactionId, request.getUserId(), request.getTimestamp(), null);
    }

    public static ResolvedTransaction recreateNewId(long transactionId, ResolvedTransaction resolvedTransaction) {
        return new ResolvedTransaction(transactionId, resolvedTransaction);
    }

    public ResolvedTransaction(long nodeId, long requestId, long transactionId, int userId, long timestamp) {
        this.nodeId = nodeId;
        this.requestId = requestId;
        this.transactionId = transactionId;
        this.transactionType = TransactionType.DATA_UPDATE;
        this.userId = userId;
        this.timestamp = timestamp;
        this.transactionRecords = new ArrayList<ResolvedTransactionRecord>();
        this.recordIdByCorrelationId = new HashMap<Integer, Integer>();
        this.schema = null;
    }

    public ResolvedTransaction(long nodeId, long requestId, long transactionId, int userId, long timestamp, Schema schema) {
        this.nodeId = nodeId;
        this.requestId = requestId;
        this.transactionId = transactionId;
        this.transactionType = TransactionType.MODEL_UPDATE;
        this.userId = userId;
        this.timestamp = timestamp;
        this.transactionRecords = null;
        this.recordIdByCorrelationId = null;
        this.schema = schema;
    }

    private ResolvedTransaction(long transactionId, ResolvedTransaction transaction) {
        this.nodeId = transaction.getNodeId();
        this.requestId = transaction.getRequestId();
        this.transactionId = transactionId;
        this.transactionType = transaction.getTransactionType();
        this.userId = transaction.getUserId();
        this.timestamp = transaction.getTimestamp();
        this.transactionRecords = transaction.getTransactionRecords();
        this.schema = transaction.getSchema();
        this.recordIdByCorrelationId = transaction.getRecordIdByCorrelationId();
    }

    public ResolvedTransaction(DataInputStream dis) throws IOException {
        this.nodeId = dis.readLong();
        this.requestId = dis.readLong();
        this.transactionId = dis.readLong();
        this.transactionType = TransactionType.getById(dis.readUnsignedByte());
        this.userId = dis.readInt();
        this.timestamp = dis.readLong();
        if (this.transactionType == TransactionType.DATA_UPDATE) {
            this.transactionRecords = new ArrayList<ResolvedTransactionRecord>();
            this.recordIdByCorrelationId = new HashMap<Integer, Integer>();
            this.schema = null;
            int count = dis.readInt();
            for (int i = 0; i < count; ++i) {
                this.transactionRecords.add(new ResolvedTransactionRecord(dis));
            }
            int correlationIds = dis.readInt();
            if (correlationIds > 0) {
                for (int i = 0; i < correlationIds; ++i) {
                    this.recordIdByCorrelationId.put(dis.readInt(), dis.readInt());
                }
            }
        } else {
            this.transactionRecords = null;
            this.recordIdByCorrelationId = null;
            this.schema = new Schema(dis);
        }
    }

    public void write(DataOutputStream dos, boolean withCorrelationIds) throws IOException {
        dos.writeLong(this.nodeId);
        dos.writeLong(this.requestId);
        dos.writeLong(this.transactionId);
        dos.writeByte(this.transactionType.getId());
        dos.writeInt(this.userId);
        dos.writeLong(this.timestamp);
        if (this.transactionType == TransactionType.DATA_UPDATE) {
            dos.writeInt(this.transactionRecords.size());
            for (ResolvedTransactionRecord resolvedTransactionRecord : this.transactionRecords) {
                resolvedTransactionRecord.write(dos);
            }
            if (withCorrelationIds && !this.recordIdByCorrelationId.isEmpty()) {
                dos.writeInt(this.recordIdByCorrelationId.size());
                for (Map.Entry entry : this.recordIdByCorrelationId.entrySet()) {
                    dos.writeInt((Integer)entry.getKey());
                    dos.writeInt((Integer)entry.getValue());
                }
            } else {
                dos.writeInt(0);
            }
        } else {
            DataStreamUtil.writeStringWithLengthHeader(dos, this.schema.getSchemaDefinition());
        }
    }

    public byte[] getBytes() throws IOException {
        return this.getBytes(false);
    }

    public byte[] getBytes(boolean withCorrelationIds) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.write(dos, withCorrelationIds);
        return bos.toByteArray();
    }

    public void addTransactionRecord(ResolvedTransactionRecord transactionRecord) {
        this.transactionRecords.add(transactionRecord);
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public int getUserId() {
        return this.userId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public List<ResolvedTransactionRecord> getTransactionRecords() {
        return this.transactionRecords;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public SchemaUpdate getSchemaUpdate() {
        return new SchemaUpdate(this.schema, this.transactionId, this.timestamp);
    }

    public Map<Integer, Integer> getRecordIdByCorrelationId() {
        return this.recordIdByCorrelationId;
    }

    public void setRecordIdByCorrelationId(Map<Integer, Integer> recordIdByCorrelationId) {
        this.recordIdByCorrelationId = recordIdByCorrelationId;
    }
}

