/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.pojo;

import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.bool.BooleanIndex;
import org.teamapps.universaldb.index.numeric.DoubleIndex;
import org.teamapps.universaldb.index.numeric.FloatIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.index.numeric.ShortIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.reference.value.MultiReferenceEditValue;
import org.teamapps.universaldb.index.reference.value.RecordReference;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.index.transaction.request.TransactionRequest;
import org.teamapps.universaldb.index.transaction.request.TransactionRequestRecord;
import org.teamapps.universaldb.index.transaction.request.TransactionRequestRecordValue;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.universaldb.index.translation.TranslatableTextIndex;
import org.teamapps.universaldb.index.versioning.RecordUpdate;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.universaldb.pojo.EntityChangeSet;
import org.teamapps.universaldb.record.EntityBuilder;
import org.teamapps.universaldb.schema.Table;

public abstract class AbstractUdbEntity<ENTITY extends Entity>
implements Entity<ENTITY>,
EntityBuilder<ENTITY> {
    private static final Logger log = LoggerFactory.getLogger(AbstractUdbEntity.class);
    private static final AtomicInteger correlationIdGenerator = new AtomicInteger();
    private static final int MAX_CORRELATION_ID = 2000000000;
    private static UniversalDB database;
    private final TableIndex tableIndex;
    private int id;
    private boolean createEntity;
    private int correlationId;
    private EntityChangeSet entityChangeSet;
    private TransactionRequest transactionRequest;

    public static void setDatabase(UniversalDB database) {
        AbstractUdbEntity.database = database;
    }

    public static <ENTITY> List<ENTITY> createEntityList(EntityBuilder<ENTITY> entityBuilder, List<Integer> recordIds) {
        ArrayList<ENTITY> list = new ArrayList<ENTITY>();
        for (Integer recordId : recordIds) {
            list.add(entityBuilder.build(recordId));
        }
        return list;
    }

    public static <ENTITY extends Entity> List<ENTITY> sort(TableIndex table, List<ENTITY> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        SingleReferenceIndex[] referencePath = AbstractUdbEntity.getReferenceIndices(table, path);
        ColumnIndex column = AbstractUdbEntity.getSortColumn(table, sortFieldName, referencePath);
        if (column == null) {
            return list;
        }
        List<SortEntry> sortEntries = SortEntry.createSortEntries(list, referencePath);
        sortEntries = column.sortRecords(sortEntries, ascending, userContext);
        return sortEntries.stream().map(SortEntry::getEntity).collect(Collectors.toList());
    }

    public static <ENTITY extends Entity> List<ENTITY> sort(TableIndex table, EntityBuilder<ENTITY> builder, BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        SingleReferenceIndex[] referencePath = AbstractUdbEntity.getReferenceIndices(table, path);
        ColumnIndex column = AbstractUdbEntity.getSortColumn(table, sortFieldName, referencePath);
        if (column == null) {
            return AbstractUdbEntity.createUnsortedList(recordIds, builder);
        }
        List<SortEntry> sortEntries = SortEntry.createSortEntries(recordIds, referencePath);
        sortEntries = column.sortRecords(sortEntries, ascending, userContext);
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (SortEntry entry : sortEntries) {
            list.add((Entity)builder.build(entry.getId()));
        }
        return list;
    }

    private static <ENTITY extends Entity> List<ENTITY> createUnsortedList(BitSet records, EntityBuilder<ENTITY> builder) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        int id = records.nextSetBit(0);
        while (id >= 0) {
            list.add((Entity)builder.build(id));
            id = records.nextSetBit(id + 1);
        }
        return list;
    }

    private static SingleReferenceIndex[] getReferenceIndices(TableIndex table, String[] path) {
        SingleReferenceIndex[] referencePath = null;
        if (path != null && path.length > 0) {
            referencePath = new SingleReferenceIndex[path.length];
            TableIndex pathTable = table;
            for (int i = 0; i < path.length; ++i) {
                referencePath[i] = (SingleReferenceIndex)pathTable.getColumnIndex(path[i]);
                pathTable = referencePath[i].getReferencedTable();
            }
        }
        return referencePath;
    }

    private static ColumnIndex getSortColumn(TableIndex table, String sortFieldName, SingleReferenceIndex[] referencePath) {
        ColumnIndex column = referencePath != null && referencePath.length > 0 ? referencePath[referencePath.length - 1].getReferencedTable().getColumnIndex(sortFieldName) : table.getColumnIndex(sortFieldName);
        return column;
    }

    public AbstractUdbEntity(TableIndex tableIndex) {
        this.tableIndex = tableIndex;
        this.createEntity = true;
        this.createCorrelationId();
    }

    public AbstractUdbEntity(TableIndex tableIndex, int id, boolean createEntity) {
        this.tableIndex = tableIndex;
        this.id = id;
        this.createEntity = createEntity;
        if (createEntity) {
            this.createCorrelationId();
        }
    }

    private void createCorrelationId() {
        if (this.correlationId > 0) {
            return;
        }
        this.correlationId = correlationIdGenerator.incrementAndGet();
        if (this.correlationId == 2000000000) {
            correlationIdGenerator.set(0);
        }
    }

    @Override
    public int getId() {
        if (this.id == 0 && this.transactionRequest != null) {
            this.id = this.transactionRequest.getResolvedRecordIdByCorrelationId(this.correlationId);
        }
        return this.id;
    }

    public int createdBy() {
        ColumnIndex columnIndex = this.tableIndex.getColumnIndex("metaCreatedBy");
        return columnIndex != null ? this.getIntValue((IntegerIndex)columnIndex) : 0;
    }

    @Override
    public List<RecordUpdate> getRecordUpdates() {
        try {
            return this.tableIndex.getRecordVersioningIndex().readRecordUpdates(this.id);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected int getCorrelationId() {
        return this.correlationId;
    }

    @Override
    public Object getEntityValue(String fieldName) {
        if ("id".equals(fieldName)) {
            return this.getId();
        }
        ColumnIndex index = this.tableIndex.getColumnIndex(fieldName);
        if (index != null) {
            return index.getGenericValue(this.getId());
        }
        return null;
    }

    @Override
    public void setEntityValue(String fieldName, Object value) {
        ColumnIndex index = this.tableIndex.getColumnIndex(fieldName);
        if (index != null) {
            this.setChangeValue(index, value, null);
        }
    }

    protected void setChangeValue(ColumnIndex index, Object value, TableIndex tableIndex) {
        this.checkChangeSet();
        this.entityChangeSet.addChangeValue(index, value);
    }

    protected void setSingleReferenceValue(SingleReferenceIndex index, Entity reference, TableIndex tableIndex) {
        int currentValue;
        AbstractUdbEntity entity = (AbstractUdbEntity)reference;
        RecordReference recordReference = null;
        if (entity != null) {
            recordReference = new RecordReference(entity.getId(), entity.getCorrelationId());
        }
        if ((currentValue = index.getValue(this.getId())) == 0 && entity != null || currentValue > 0 && entity == null || entity != null && (entity.getId() == 0 || entity.getId() != currentValue)) {
            this.checkChangeSet();
            this.entityChangeSet.addChangeValue(index, recordReference);
            this.entityChangeSet.setReferenceChange(index, entity);
        }
    }

    protected <OTHER_ENTITY extends Entity> List<OTHER_ENTITY> createEntityList(ColumnIndex index, EntityBuilder<OTHER_ENTITY> entityBuilder) {
        TransactionRequestRecordValue changeValue = this.getChangeValue(index);
        MultiReferenceEditValue editValue = (MultiReferenceEditValue)changeValue.getValue();
        MultiReferenceIndex multiReferenceIndex = (MultiReferenceIndex)index;
        return this.createEntityList(editValue, multiReferenceIndex.getReferencesAsList(this.id), entityBuilder);
    }

    protected <OTHER_ENTITY extends Entity> List<OTHER_ENTITY> createEntityList(MultiReferenceEditValue editValue, List<Integer> referencedRecords, EntityBuilder<OTHER_ENTITY> entityBuilder) {
        Map<RecordReference, Entity> entityByReference = this.entityChangeSet.getEntityByReference();
        ArrayList<Entity<Object>> list = new ArrayList<Entity<Object>>();
        if (!editValue.getSetReferences().isEmpty() || editValue.isRemoveAll()) {
            List<RecordReference> references = editValue.isRemoveAll() ? editValue.getAddReferences() : editValue.getSetReferences();
            references.forEach(reference -> {
                Entity entity = (Entity)entityByReference.get(reference);
                if (entity == null && reference.getRecordId() > 0) {
                    entity = (Entity)entityBuilder.build(reference.getRecordId());
                }
                if (entity != null) {
                    list.add(entity);
                } else {
                    log.error("Cannot add reference to list: no record id and no matching correlation id!");
                }
            });
            return list;
        }
        HashSet removeSet = new HashSet();
        editValue.getRemoveReferences().forEach(reference -> {
            if (reference.getRecordId() > 0) {
                removeSet.add(reference.getRecordId());
            } else {
                Entity entity = (Entity)entityByReference.get(reference);
                if (entity != null) {
                    removeSet.add(entity.getId());
                }
            }
        });
        ArrayList addEntities = new ArrayList();
        editValue.getAddReferences().forEach(reference -> {
            Entity entity = (Entity)entityByReference.get(reference);
            if (entity == null && reference.getRecordId() > 0) {
                entity = (Entity)entityBuilder.build(reference.getRecordId());
            }
            if (entity != null) {
                addEntities.add(entity);
            }
        });
        HashSet addEntitySet = new HashSet();
        addEntities.forEach(entity -> addEntitySet.add(entity.getId()));
        for (Integer recordId : referencedRecords) {
            if (removeSet.contains(recordId) || addEntitySet.contains(recordId)) continue;
            list.add((Entity)entityBuilder.build(recordId));
        }
        list.addAll(addEntities);
        return list;
    }

    protected TransactionRequestRecordValue getChangeValue(ColumnIndex index) {
        if (this.entityChangeSet == null) {
            return null;
        }
        return this.entityChangeSet.getChangeValue(index);
    }

    protected Object getChangedValue(ColumnIndex index) {
        if (this.entityChangeSet == null) {
            return null;
        }
        return this.entityChangeSet.getChangeValue(index).getValue();
    }

    protected AbstractUdbEntity getReferenceChangeValue(ColumnIndex index) {
        if (this.entityChangeSet == null) {
            return null;
        }
        return this.entityChangeSet.getReferenceChange(index.getMappingId());
    }

    protected void addMultiReferenceValue(List<? extends Entity> entities, MultiReferenceIndex multiReferenceIndex) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        MultiReferenceEditValue editValue = this.getOrCreateMultiReferenceEditValue(multiReferenceIndex);
        List<RecordReference> references = this.createRecordReferences(entities);
        editValue.addReferences(references);
    }

    protected void removeMultiReferenceValue(List<? extends Entity> entities, MultiReferenceIndex multiReferenceIndex) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        MultiReferenceEditValue editValue = this.getOrCreateMultiReferenceEditValue(multiReferenceIndex);
        List<RecordReference> references = this.createRecordReferences(entities);
        editValue.removeReferences(references);
    }

    protected void setMultiReferenceValue(List<? extends Entity> entities, MultiReferenceIndex multiReferenceIndex) {
        if (entities == null || entities.isEmpty()) {
            if (this.getChangeValue(multiReferenceIndex) != null || !multiReferenceIndex.isEmpty(this.getId())) {
                this.removeAllMultiReferenceValue(multiReferenceIndex);
            }
        } else {
            Set entityIdSet;
            if (this.getChangeValue(multiReferenceIndex) == null && multiReferenceIndex.getReferencesCount(this.getId()) == entities.size() && entities.stream().allMatch(Entity::isStored) && (entityIdSet = entities.stream().map(Entity::getId).collect(Collectors.toSet())).containsAll(multiReferenceIndex.getReferencesAsList(this.getId()))) {
                return;
            }
            MultiReferenceEditValue editValue = this.getOrCreateMultiReferenceEditValue(multiReferenceIndex);
            List<RecordReference> references = this.createRecordReferences(entities);
            editValue.setReferences(references);
        }
    }

    protected void removeAllMultiReferenceValue(MultiReferenceIndex multiReferenceIndex) {
        MultiReferenceEditValue editValue = this.getOrCreateMultiReferenceEditValue(multiReferenceIndex);
        editValue.setRemoveAll();
    }

    private List<RecordReference> createRecordReferences(List<? extends Entity> entities) {
        ArrayList<RecordReference> references = new ArrayList<RecordReference>();
        for (Entity entity : entities) {
            AbstractUdbEntity udbEntity = (AbstractUdbEntity)entity;
            RecordReference recordReference = new RecordReference(udbEntity.getId(), udbEntity.getCorrelationId());
            references.add(recordReference);
            this.entityChangeSet.addRecordReference(recordReference, entity);
        }
        return references;
    }

    private MultiReferenceEditValue getOrCreateMultiReferenceEditValue(MultiReferenceIndex multiReferenceIndex) {
        MultiReferenceEditValue editValue;
        TransactionRequestRecordValue changeValue = this.getChangeValue(multiReferenceIndex);
        if (changeValue != null) {
            editValue = (MultiReferenceEditValue)changeValue.getValue();
        } else {
            editValue = new MultiReferenceEditValue();
            this.setChangeValue(multiReferenceIndex, editValue, this.tableIndex);
        }
        return editValue;
    }

    public boolean getBooleanValue(BooleanIndex index) {
        if (this.isChanged(index)) {
            return (Boolean)this.getChangedValue(index);
        }
        return index.getValue(this.getId());
    }

    public void setBooleanValue(boolean value, BooleanIndex index) {
        if (this.getBooleanValue(index) != value) {
            this.setChangeValue(index, value, this.tableIndex);
        }
    }

    public short getShortValue(ShortIndex index) {
        if (this.isChanged(index)) {
            return (Short)this.getChangedValue(index);
        }
        return index.getValue(this.getId());
    }

    public void setShortValue(short value, ShortIndex index) {
        if (this.getShortValue(index) != value) {
            this.setChangeValue(index, value, this.tableIndex);
        }
    }

    public int getIntValue(IntegerIndex index) {
        if (this.isChanged(index)) {
            return (Integer)this.getChangedValue(index);
        }
        return index.getValue(this.getId());
    }

    public void setIntValue(int value, IntegerIndex index) {
        if (this.getIntValue(index) != value) {
            this.setChangeValue(index, value, this.tableIndex);
        }
    }

    public long getLongValue(LongIndex index) {
        if (this.isChanged(index)) {
            return (Long)this.getChangedValue(index);
        }
        return index.getValue(this.getId());
    }

    public void setLongValue(long value, LongIndex index) {
        if (this.getLongValue(index) != value) {
            this.setChangeValue(index, value, this.tableIndex);
        }
    }

    public float getFloatValue(FloatIndex index) {
        if (this.isChanged(index)) {
            return ((Float)this.getChangedValue(index)).floatValue();
        }
        return index.getValue(this.getId());
    }

    public void setFloatValue(float value, FloatIndex index) {
        if (this.getFloatValue(index) != value) {
            this.setChangeValue(index, Float.valueOf(value), this.tableIndex);
        }
    }

    public double getDoubleValue(DoubleIndex index) {
        if (this.isChanged(index)) {
            return (Double)this.getChangedValue(index);
        }
        return index.getValue(this.getId());
    }

    public void setDoubleValue(double value, DoubleIndex index) {
        if (this.getDoubleValue(index) != value) {
            this.setChangeValue(index, value, this.tableIndex);
        }
    }

    public String getTextValue(TextIndex index) {
        if (this.isChanged(index)) {
            return (String)this.getChangedValue(index);
        }
        return index.getValue(this.getId());
    }

    public void setTextValue(String value, TextIndex index) {
        if (value != null && value.isEmpty()) {
            value = null;
        }
        if (!Objects.equals(this.getTextValue(index), value)) {
            this.setChangeValue(index, value, this.tableIndex);
        }
    }

    public TranslatableText getTranslatableTextValue(TranslatableTextIndex index) {
        if (this.isChanged(index)) {
            return (TranslatableText)this.getChangedValue(index);
        }
        return index.getValue(this.getId());
    }

    public void setTranslatableTextValue(TranslatableText value, TranslatableTextIndex index) {
        this.setChangeValue(index, value, this.tableIndex);
    }

    public Instant getTimestampValue(IntegerIndex index) {
        int value = this.isChanged(index) ? ((Integer)this.getChangedValue(index)).intValue() : index.getValue(this.getId());
        return value == 0 ? null : Instant.ofEpochSecond(value);
    }

    public int getTimestampAsEpochSecond(IntegerIndex index) {
        if (this.isChanged(index)) {
            return (Integer)this.getChangedValue(index);
        }
        return index.getValue(this.getId());
    }

    public long getTimestampAsEpochMilli(IntegerIndex index) {
        if (this.isChanged(index)) {
            return ((Integer)this.getChangedValue(index)).longValue() * 1000L;
        }
        return (long)index.getValue(this.getId()) * 1000L;
    }

    public void setTimestampValue(Instant value, IntegerIndex index) {
        if (!Objects.equals(this.getTimestampValue(index), value)) {
            Integer intValue = value != null ? (int)value.getEpochSecond() : 0;
            this.setChangeValue(index, intValue, this.tableIndex);
        }
    }

    public void setTimestampAsEpochSecond(int value, IntegerIndex index) {
        if (this.getTimestampAsEpochSecond(index) != value) {
            this.setChangeValue(index, value, this.tableIndex);
        }
    }

    public void setTimestampAsEpochMilli(long value, IntegerIndex index) {
        if (this.getTimestampAsEpochMilli(index) != value) {
            int intValue = (int)(value / 1000L);
            this.setChangeValue(index, intValue, this.tableIndex);
        }
    }

    public Instant getTimeValue(IntegerIndex index) {
        int value = this.isChanged(index) ? ((Integer)this.getChangedValue(index)).intValue() : index.getValue(this.getId());
        return value == 0 ? null : Instant.ofEpochSecond(value);
    }

    public void setTimeValue(Instant value, IntegerIndex index) {
        if (!Objects.equals(this.getTimeValue(index), value)) {
            Integer intValue = value != null ? (int)value.getEpochSecond() : 0;
            this.setChangeValue(index, intValue, this.tableIndex);
        }
    }

    public Instant getDateValue(LongIndex index) {
        long value = this.isChanged(index) ? ((Long)this.getChangedValue(index)).longValue() : index.getValue(this.getId());
        return value == 0L ? null : Instant.ofEpochMilli(value);
    }

    public long getDateAsEpochMilli(LongIndex index) {
        if (this.isChanged(index)) {
            return (Long)this.getChangedValue(index);
        }
        return index.getValue(this.getId());
    }

    public void setDateValue(Instant value, LongIndex index) {
        if (!Objects.equals(this.getDateValue(index), value)) {
            Long longValue = value != null ? value.toEpochMilli() : 0L;
            this.setChangeValue(index, longValue, this.tableIndex);
        }
    }

    public void setDateAsEpochMilli(long value, LongIndex index) {
        if (this.getDateAsEpochMilli(index) != value) {
            this.setChangeValue(index, value, this.tableIndex);
        }
    }

    public Instant getDateTimeValue(LongIndex index) {
        long value = this.isChanged(index) ? ((Long)this.getChangedValue(index)).longValue() : index.getValue(this.getId());
        return value == 0L ? null : Instant.ofEpochMilli(value);
    }

    public long getDateTimeAsEpochMilli(LongIndex index) {
        if (this.isChanged(index)) {
            return (Long)this.getChangedValue(index);
        }
        return index.getValue(this.getId());
    }

    public void setDateTimeValue(Instant value, LongIndex index) {
        if (!Objects.equals(this.getDateTimeValue(index), value)) {
            Long longValue = value != null ? value.toEpochMilli() : 0L;
            this.setChangeValue(index, longValue, this.tableIndex);
        }
    }

    public void setDateTimeAsEpochMilli(long value, LongIndex index) {
        if (this.getDateTimeAsEpochMilli(index) != value) {
            this.setChangeValue(index, value, this.tableIndex);
        }
    }

    public LocalDate getLocalDateValue(LongIndex index) {
        long value = this.isChanged(index) ? ((Long)this.getChangedValue(index)).longValue() : index.getValue(this.getId());
        return value == 0L ? null : LocalDate.ofInstant(Instant.ofEpochMilli(value), ZoneOffset.UTC);
    }

    public void setLocalDateValue(LocalDate value, LongIndex index) {
        long longValue = value != null ? value.atStartOfDay(ZoneOffset.UTC).toEpochSecond() * 1000L : 0L;
        LocalDate currentValue = this.getLocalDateValue(index);
        if (!(Objects.equals(currentValue, value) || currentValue == null && longValue == 0L)) {
            this.setChangeValue(index, longValue, this.tableIndex);
        }
    }

    public void setLocalDateAsEpochMilli(long value, LongIndex index) {
        if (index.getValue(this.getId()) != value) {
            this.setChangeValue(index, value, this.tableIndex);
        }
    }

    public <ENUM extends Enum<ENUM>> ENUM getEnumValue(ShortIndex index, ENUM[] values) {
        short shortValue = this.isChanged(index) ? ((Short)this.getChangedValue(index)).shortValue() : index.getValue(this.getId());
        return shortValue == 0 ? null : (ENUM)values[shortValue - 1];
    }

    public <ENUM extends Enum<ENUM>> void setEnumValue(ShortIndex index, ENUM value) {
        short shortValue = (short)(value != null ? value.ordinal() + 1 : 0);
        if (this.getShortValue(index) != shortValue) {
            this.setChangeValue(index, shortValue, this.tableIndex);
        }
    }

    public <OTHER_ENTITY extends Entity> List<OTHER_ENTITY> getMultiReferenceValue(MultiReferenceIndex index, EntityBuilder<OTHER_ENTITY> entityBuilder) {
        if (this.isChanged(index)) {
            return this.createEntityList(index, entityBuilder);
        }
        if (!index.isEmpty(this.getId())) {
            return AbstractUdbEntity.createEntityList(entityBuilder, index.getReferencesAsList(this.getId()));
        }
        return Collections.emptyList();
    }

    public <OTHER_ENTITY extends Entity> int getMultiReferenceValueCount(MultiReferenceIndex index, EntityBuilder<OTHER_ENTITY> entityBuilder) {
        if (this.isChanged(index)) {
            return this.createEntityList(index, entityBuilder).size();
        }
        return index.getReferencesCount(this.getId());
    }

    public <OTHER_ENTITY extends Entity> BitSet getMultiReferenceValueAsBitSet(MultiReferenceIndex index, EntityBuilder<OTHER_ENTITY> entityBuilder) {
        if (this.isChanged(index)) {
            BitSet bitSet = new BitSet();
            this.createEntityList(index, entityBuilder).stream().map(Entity::getId).forEach(bitSet::set);
            return bitSet;
        }
        return index.getReferencesAsBitSet(this.getId());
    }

    public boolean isChanged(ColumnIndex index) {
        return this.entityChangeSet != null && this.entityChangeSet.isChanged(index);
    }

    @Override
    public void clearChanges() {
        this.entityChangeSet = null;
    }

    @Override
    public boolean isChanged(String fieldName) {
        return this.isChanged(this.tableIndex.getColumnIndex(fieldName));
    }

    @Override
    public void clearFieldChanges(String fieldName) {
        if (this.entityChangeSet != null) {
            this.entityChangeSet.removeChange(this.tableIndex.getColumnIndex(fieldName));
        }
    }

    @Override
    public boolean isModified() {
        return this.entityChangeSet != null;
    }

    private void checkChangeSet() {
        if (this.entityChangeSet == null) {
            this.entityChangeSet = new EntityChangeSet();
            this.createCorrelationId();
        }
    }

    public void saveRecord() {
        if (this.entityChangeSet != null) {
            this.transactionRequest = database.createTransactionRequest();
            this.saveRecord(this.transactionRequest);
            database.executeTransaction(this.transactionRequest);
            if (this.id == 0) {
                this.id = this.transactionRequest.getResolvedRecordIdByCorrelationId(this.correlationId);
            }
        }
    }

    public void saveRecord(TransactionRequest transactionRequest) {
        if (this.entityChangeSet != null) {
            this.transactionRequest = transactionRequest;
            boolean update = !this.createEntity;
            TransactionRequestRecord record = TransactionRequestRecord.createOrUpdateRecord(transactionRequest, this.tableIndex, this.id, this.correlationId, update);
            this.entityChangeSet.setTransactionRequestRecordValues(transactionRequest, record);
            transactionRequest.addRecord(record);
            this.clearChanges();
            this.createEntity = false;
        }
    }

    public TableIndex getTableIndex() {
        return this.tableIndex;
    }

    @Override
    public int getTableId() {
        return this.tableIndex.getMappingId();
    }

    @Override
    public String getQualifiedName() {
        return this.tableIndex.getFQN();
    }

    public void deleteRecord() {
        TransactionRequest transactionRequest = database.createTransactionRequest();
        transactionRequest.addRecord(TransactionRequestRecord.createDeleteRecord(transactionRequest, this.tableIndex, this.id));
        this.clearChanges();
        database.executeTransaction(transactionRequest);
    }

    public void restoreDeletedRecord() {
        TransactionRequest transactionRequest = database.createTransactionRequest();
        transactionRequest.addRecord(TransactionRequestRecord.createRestoreRecord(transactionRequest, this.tableIndex, this.id));
        database.executeTransaction(transactionRequest);
    }

    @Override
    public boolean isRestorable() {
        return this.tableIndex.getTableConfig().keepDeleted();
    }

    @Override
    public boolean isStored() {
        return this.getId() > 0 && this.tableIndex.isStored(this.id);
    }

    @Override
    public boolean isDeleted() {
        return this.getId() > 0 && this.tableIndex.isDeleted(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractUdbEntity that = (AbstractUdbEntity)o;
        if (this.getId() > 0 && this.getId() == that.getId()) {
            return true;
        }
        return this.getCorrelationId() > 0 && this.getCorrelationId() == that.getCorrelationId();
    }

    public int hashCode() {
        if (this.getId() > 0) {
            return this.getId();
        }
        return this.getCorrelationId();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.tableIndex.getName()).append(": ").append(this.getId()).append("\n");
        ArrayList sortedFields = new ArrayList();
        sortedFields.addAll(this.tableIndex.getColumnIndices().stream().filter(column -> !Table.isReservedMetaName(column.getName())).collect(Collectors.toList()));
        sortedFields.addAll(this.tableIndex.getColumnIndices().stream().filter(column -> Table.isReservedMetaName(column.getName())).collect(Collectors.toList()));
        for (ColumnIndex column2 : sortedFields) {
            sb.append("\t").append(column2.getName()).append(": ").append(column2.getStringValue(this.getId()));
            if (this.isChanged(column2)) {
                TransactionRequestRecordValue changeValue = this.getChangeValue(column2);
                sb.append(" -> ").append(changeValue.getValue());
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

