/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashSet;
import java.util.Set;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResizableAtomicMappedBuffer {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Set<String> bufferPathSet = new HashSet<String>();
    private final File file;
    private int bufferSize;
    private AtomicBuffer buffer;

    public ResizableAtomicMappedBuffer(File file, int bufferSize) {
        this.file = file;
        this.bufferSize = file.exists() ? (int)Math.max((long)bufferSize, file.length()) : bufferSize;
        this.createBuffer();
    }

    private void createBuffer() {
        this.checkPath();
        this.file.getParentFile().mkdir();
        this.updateBufferSize();
    }

    private void checkPath() {
        String path = this.file.getPath();
        if (bufferPathSet.contains(path)) {
            System.err.println("ERROR: trying to create a second buffer for the same path!:" + path);
            throw new RuntimeException("ERROR: trying to create a second buffer for the same path!:" + path);
        }
        bufferPathSet.add(path);
    }

    public void ensureSize(int size) {
        if (size > this.bufferSize) {
            this.bufferSize *= 2;
            this.updateBufferSize();
        }
    }

    public AtomicBuffer getBuffer() {
        return this.buffer;
    }

    private void updateBufferSize() {
        try {
            RandomAccessFile ras = new RandomAccessFile(this.file, "rw");
            if (!this.file.exists() || this.file.length() < (long)this.bufferSize) {
                ras.seek(this.bufferSize - 4);
                ras.write(new byte[4]);
            }
            MappedByteBuffer mappedByteBuffer = ras.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.bufferSize);
            try {
                ras.close();
            }
            catch (Throwable t) {
                logger.warn("Error releasing RAS file on buffer creation:" + t.getMessage() + ", file:" + String.valueOf(this.file));
            }
            AtomicBuffer oldBuffer = this.buffer;
            this.buffer = new UnsafeBuffer((ByteBuffer)mappedByteBuffer);
            ResizableAtomicMappedBuffer.releaseBufferUnsafe(oldBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException("ERROR: updating buffer size of buffer:" + this.file.getPath(), e);
        }
    }

    public static void releaseBufferUnsafe(AtomicBuffer atomicBuffer) {
        try {
            MappedByteBuffer buffer = (MappedByteBuffer)atomicBuffer.byteBuffer();
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            Object unsafe = unsafeField.get(null);
            Method invokeCleaner = unsafeClass.getMethod("invokeCleaner", ByteBuffer.class);
            invokeCleaner.invoke(unsafe, buffer);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

