/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCache {
    private static int MAX_FILES = 100000;
    private static long MAX_CACHE_SIZE = 10000000000L;
    private final Logger log = LoggerFactory.getLogger(FileCache.class);
    private final File tempPath;
    private final Map<String, File> fileMap = new LinkedHashMap<String, File>(1000, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, File> eldest) {
            if (FileCache.this.cacheSize > MAX_CACHE_SIZE || this.size() > MAX_FILES) {
                FileCache.this.cacheSize -= eldest.getValue().length();
                FileCache.this.removeFile(eldest.getValue());
                return true;
            }
            return false;
        }
    };
    private long cacheSize;

    public FileCache(File tempPath) {
        this.tempPath = new File(tempPath, "file-cache");
        tempPath.mkdir();
    }

    public File getFile(String filePath) {
        return this.fileMap.get(filePath);
    }

    public void addFile(File file, String filePath) throws IOException {
        if (file.length() > MAX_CACHE_SIZE) {
            return;
        }
        if (this.getFile(filePath) != null) {
            return;
        }
        File cacheFilePath = this.createCacheFilePath(filePath);
        if (cacheFilePath.exists()) {
            this.fileMap.put(filePath, file);
            return;
        }
        Files.copy(file.toPath(), cacheFilePath.toPath(), new CopyOption[0]);
        this.cacheSize += cacheFilePath.length();
        this.fileMap.put(filePath, cacheFilePath);
    }

    public void putFinishedCacheFile(File file, String filePath) {
        this.cacheSize += file.length();
        this.fileMap.put(filePath, file);
    }

    private void removeFile(File file) {
        file.delete();
    }

    public File createCacheFilePath(String filePath) {
        File path = new File(this.tempPath, filePath);
        File dir = path.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
            this.log.info("Create file cache dir:" + dir.getPath());
        }
        return path;
    }

    private File createPathFromHash(String hash) {
        File dir = new File(this.tempPath, hash.substring(0, 2));
        if (!dir.exists()) {
            dir.mkdir();
        }
        return new File(dir, hash);
    }
}

