/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.bool;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.AbstractIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.FullTextIndexingOptions;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.bool.BooleanFilter;
import org.teamapps.universaldb.index.buffer.PrimitiveEntryAtomicStore;
import org.teamapps.universaldb.transaction.DataType;

public class BooleanIndex
extends AbstractIndex<Boolean, BooleanFilter> {
    private PrimitiveEntryAtomicStore atomicStore;
    private int maxSetId;
    private int numberOfSetIds;

    public BooleanIndex(String name, TableIndex tableIndex, ColumnType columnType) {
        super(name, tableIndex, columnType, FullTextIndexingOptions.NOT_INDEXED);
        this.atomicStore = new PrimitiveEntryAtomicStore(tableIndex.getDataPath(), name);
        this.recalculateMaxSetIndex();
        this.recalculateNumberOfSetIds();
    }

    private void recalculateMaxSetIndex() {
        int maximumId = (int)(this.atomicStore.getTotalCapacity() * 8L) - 1;
        int maxId = 0;
        for (int id = maximumId; id > 0; --id) {
            if (!this.getValue(id)) continue;
            maxId = id;
            break;
        }
        this.maxSetId = maxId;
    }

    private void recalculateNumberOfSetIds() {
        int count = 0;
        for (int id = 1; id <= this.maxSetId; ++id) {
            if (!this.getValue(id)) continue;
            ++count;
        }
        this.numberOfSetIds = count;
    }

    @Override
    public IndexType getType() {
        return IndexType.BOOLEAN;
    }

    @Override
    public Boolean getGenericValue(int id) {
        return this.getValue(id);
    }

    @Override
    public void setGenericValue(int id, Boolean value) {
        this.setValue(id, value);
    }

    @Override
    public void removeValue(int id) {
        this.setValue(id, false);
    }

    @Override
    public void close() {
        this.atomicStore.close();
    }

    @Override
    public void drop() {
        this.atomicStore.drop();
    }

    @Override
    public BitSet filter(BitSet records, BooleanFilter booleanFilter) {
        if (booleanFilter.getFilterValue()) {
            return this.filterEquals(records, true);
        }
        return this.filterEquals(records, false);
    }

    public boolean getValue(int id) {
        return this.atomicStore.getBoolean(id);
    }

    public void setValue(int id, boolean value) {
        if (id > 0 && value != this.getValue(id)) {
            this.numberOfSetIds = value ? ++this.numberOfSetIds : --this.numberOfSetIds;
        }
        this.atomicStore.setBoolean(id, value);
        if (value) {
            if (id > this.maxSetId) {
                this.maxSetId = id;
            }
        } else if (id == this.maxSetId) {
            this.recalculateMaxSetIndex();
        }
    }

    @Override
    public void writeTransactionValue(Boolean value, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.getMappingId());
        dataOutputStream.writeByte(DataType.BOOLEAN.getId());
        dataOutputStream.writeBoolean(value);
    }

    @Override
    public Boolean readTransactionValue(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readBoolean();
    }

    @Override
    public List<SortEntry> sortRecords(List<SortEntry> sortEntries, boolean ascending, UserContext userContext) {
        int order = ascending ? 1 : -1;
        sortEntries.sort((o1, o2) -> {
            boolean value1 = this.getValue(o1.getLeafId());
            boolean value2 = this.getValue(o2.getLeafId());
            return Boolean.compare(value1, value2) * order;
        });
        return sortEntries;
    }

    @Override
    public void dumpIndex(DataOutputStream dataOutputStream, BitSet records) throws IOException {
        int id = records.nextSetBit(0);
        while (id >= 0) {
            boolean value = this.getValue(id);
            dataOutputStream.writeInt(id);
            dataOutputStream.writeBoolean(value);
            id = records.nextSetBit(id + 1);
        }
    }

    @Override
    public void restoreIndex(DataInputStream dataInputStream) throws IOException {
        try {
            int id = dataInputStream.readInt();
            boolean value = dataInputStream.readBoolean();
            this.setValue(id, value);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public BitSet filterEquals(BitSet bitSet, boolean compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            boolean value = this.getValue(id);
            if (value == compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterNotEquals(BitSet bitSet, boolean compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            boolean value = this.getValue(id);
            if (value != compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public int getCount() {
        return this.numberOfSetIds;
    }

    public BitSet getBitSet() {
        BitSet bitSet = new BitSet(this.maxSetId);
        for (int i = 1; i <= this.maxSetId; ++i) {
            if (!this.getValue(i)) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    public int getMaxId() {
        return this.maxSetId;
    }

    public int getNextId() {
        return this.maxSetId + 1;
    }
}

