/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.file;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.teamapps.universaldb.index.file.AbstractFileStore;
import org.teamapps.universaldb.index.file.FileUtil;

public class LocalFileStore
extends AbstractFileStore {
    private final File storePath;
    private final boolean encrypt;

    public LocalFileStore(File storePath) {
        this.storePath = storePath;
        this.encrypt = false;
        storePath.mkdir();
    }

    public LocalFileStore(File storePath, boolean encrypt) {
        this.storePath = storePath;
        this.encrypt = encrypt;
    }

    @Override
    public File getFile(String path, String uuid, String hash) {
        try {
            File filePath = this.createPathFromUuid(path, uuid);
            if (this.encrypt) {
                File tempFile = File.createTempFile("temp", ".bin");
                FileUtil.decryptAndDecompress(filePath, tempFile, hash);
                return tempFile;
            }
            return filePath;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setFile(String path, String uuid, String hash, File file) {
        try {
            File storeFile = this.createPathFromUuid(path, uuid);
            if (this.encrypt) {
                FileUtil.compressAndEncrypt(file, storeFile, hash);
            } else {
                Files.copy(file.toPath(), storeFile.toPath(), new CopyOption[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void removeFile(String path, String uuid) {
        File storeFile = this.createPathFromUuid(path, uuid);
        if (storeFile.exists()) {
            storeFile.delete();
        }
    }

    @Override
    public boolean fileExists(String path, String uuid) {
        File storeFile = this.createPathFromUuid(path, uuid);
        return storeFile.exists();
    }

    private File createPathFromUuid(String path, String uuid) {
        File dir = new File(this.storePath, path + "/" + uuid.substring(0, 4));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir, uuid);
    }
}

