/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.fileng;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import org.teamapps.universaldb.index.fileng.FileFullTextContentEntry;

public class FileFullTextContentEntryIterator
implements Iterator<FileFullTextContentEntry> {
    private final DataInputStream dataInputStream;
    private FileFullTextContentEntry nextEntry;

    public FileFullTextContentEntryIterator(File indexFile) throws IOException {
        DataInputStream dataInputStream;
        this.dataInputStream = dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(indexFile), 128000));
        this.fetchNext();
    }

    @Override
    public boolean hasNext() {
        return this.nextEntry != null;
    }

    @Override
    public FileFullTextContentEntry next() {
        FileFullTextContentEntry next = this.nextEntry;
        this.fetchNext();
        return next;
    }

    private void fetchNext() {
        try {
            this.nextEntry = new FileFullTextContentEntry(this.dataInputStream);
        }
        catch (EOFException e) {
            this.nextEntry = null;
            this.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.dataInputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

