/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.fileng;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.teamapps.universaldb.util.DataStreamUtil;

public class FileVersionEntry {
    private final int version;
    private final long size;
    private final String hash;
    private final String fileName;

    public FileVersionEntry(int version, String hash, String fileName, long size) {
        this.version = version;
        this.hash = hash;
        this.fileName = fileName;
        this.size = size;
    }

    public FileVersionEntry(DataInputStream dataInputStream) throws IOException {
        this.version = dataInputStream.readInt();
        this.size = dataInputStream.readLong();
        this.hash = DataStreamUtil.readStringWithLengthHeader(dataInputStream);
        this.fileName = DataStreamUtil.readStringWithLengthHeader(dataInputStream);
    }

    public byte[] getEntryValue() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt(this.version);
        dos.writeLong(this.size);
        DataStreamUtil.writeStringWithLengthHeader(dos, this.hash);
        DataStreamUtil.writeStringWithLengthHeader(dos, this.fileName);
        return bos.toByteArray();
    }

    public int getVersion() {
        return this.version;
    }

    public long getSize() {
        return this.size;
    }

    public String getHash() {
        return this.hash;
    }

    public String getFileName() {
        return this.fileName;
    }
}

