/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.fileng;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.teamapps.universaldb.index.fileng.FileStore;
import org.teamapps.universaldb.index.fileng.FileValue;

public class LocalStoreFileValue
implements FileValue {
    private final int id;
    private final FileStore fileStore;
    private final File file;

    public LocalStoreFileValue(int id, FileStore fileStore, File file) {
        this.id = id;
        this.fileStore = fileStore;
        this.file = file;
    }

    @Override
    public String getHash() {
        return this.fileStore.getHash(this.id);
    }

    @Override
    public String getFileName() {
        return this.fileStore.getFileName(this.id);
    }

    @Override
    public long getSize() {
        return this.fileStore.getSize(this.id);
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Override
    public File getAsFile() {
        return this.file;
    }

    @Override
    public int getVersion() {
        return this.fileStore.getVersion(this.id);
    }

    @Override
    public File getFileVersion(int version) {
        return this.fileStore.getFileVersion(this.id, version);
    }
}

