/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.fileng;

import io.minio.MinioClient;
import java.io.File;
import java.io.InputStream;
import org.teamapps.universaldb.index.fileng.RemoteFileStore;

public class S3FileStore
implements RemoteFileStore {
    private final String bucketName;
    private final String url;
    private final String accessKey;
    private final String secretKey;
    private MinioClient minioClient;

    public S3FileStore(String bucketName, String url, String accessKey, String secretKey) throws Exception {
        this.bucketName = bucketName;
        this.url = url;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.connect();
    }

    private void connect() throws Exception {
        this.minioClient = new MinioClient(this.url, this.accessKey, this.secretKey);
        this.createBucket(this.bucketName);
    }

    public void createBucket(String bucket) throws Exception {
        if (!this.minioClient.bucketExists(bucket)) {
            this.minioClient.makeBucket(bucket);
        }
    }

    @Override
    public InputStream getInputStream(String path) throws Exception {
        return this.minioClient.getObject(this.bucketName, path);
    }

    @Override
    public File getFile(String path) throws Exception {
        this.minioClient.statObject(this.bucketName, path);
        File tempFile = File.createTempFile("temp", ".bin");
        this.minioClient.getObject(this.bucketName, path, tempFile.getPath());
        return tempFile;
    }

    @Override
    public void setInputStream(String path, InputStream inputStream, long length) throws Exception {
        this.minioClient.putObject(this.bucketName, path, inputStream, Long.valueOf(length), null, null, "application/octet-stream");
    }

    @Override
    public void setFile(String path, File file) throws Exception {
        this.minioClient.putObject(this.bucketName, path, file.getPath(), Long.valueOf(file.length()), null, null, "application/octet-stream");
    }

    @Override
    public boolean fileExists(String path) {
        try {
            this.minioClient.statObject(this.bucketName, path);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void removeFile(String path) throws Exception {
        this.minioClient.removeObject(this.bucketName, path);
    }
}

