/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.buffer;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractResizingAtomicStore {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    protected static final int MIN_FILE_SIZE = 120000;
    protected static final int MAX_FILE_SIZE = 1966080000;
    private final File path;
    private final String name;
    private final long maxTotalSize;
    private AtomicBuffer[] buffers;
    private int lastBufferSize;
    private long totalCapacity;

    public AbstractResizingAtomicStore(File path, String name) {
        this.path = path;
        this.name = name;
        this.maxTotalSize = 15728640000L;
        this.init();
    }

    private void init() {
        this.buffers = new AtomicBuffer[1];
        if (!this.getStoreFile(0).exists()) {
            this.updateBufferSize(0, 120000);
        } else {
            for (int index = 0; index == 0 || this.getStoreFile(index).exists(); ++index) {
                File storeFile = this.getStoreFile(index);
                this.updateBufferSize(index, (int)storeFile.length());
            }
        }
    }

    protected void ensureCapacity(int id, int byteLength) {
        this.ensureCapacity(((long)id + 1L) * (long)byteLength);
    }

    protected long findNextBlockPosition(long position, int blockSize) {
        int bufferIndex = this.getBufferIndex(position);
        int offset = this.getOffset(position, bufferIndex);
        if (blockSize > this.lastBufferSize - offset && this.lastBufferSize == 1966080000) {
            return (long)this.buffers.length * 1966080000L + (long)blockSize;
        }
        return position;
    }

    protected AtomicBuffer getBuffer(int index) {
        return this.buffers[index];
    }

    protected AtomicBuffer[] getBuffers() {
        return this.buffers;
    }

    protected int getBufferIndex(long position) {
        return (int)(position / 1966080000L);
    }

    protected int getOffset(long position, int bufferIndex) {
        return (int)(position - (long)bufferIndex * 1966080000L);
    }

    protected int getOffset(int id, int bufferIndex, int entriesPerFile, int byteLength) {
        return (id - bufferIndex * entriesPerFile) * byteLength;
    }

    protected int getMaximumId(int byteLength) {
        return (int)(this.totalCapacity / (long)byteLength) - 1;
    }

    protected void ensureCapacity(long size) {
        if (size > this.totalCapacity) {
            if (size > this.maxTotalSize) {
                throw new RuntimeException("Index size exceeding maximum, requested size: " + size + ", index:" + this.toString());
            }
            while (size > this.totalCapacity) {
                if (this.lastBufferSize < 1966080000) {
                    this.updateBufferSize(this.buffers.length - 1, this.lastBufferSize * 2);
                    continue;
                }
                this.updateBufferSize(this.buffers.length, 491520000);
            }
        }
    }

    private void updateBufferSize(int bufferIndex, int bufferSize) {
        File file = this.getStoreFile(bufferIndex);
        try {
            RandomAccessFile ras = new RandomAccessFile(file, "rw");
            if (!file.exists() || file.length() < (long)bufferSize) {
                ras.seek(bufferSize - 4);
                ras.write(new byte[4]);
            }
            MappedByteBuffer mappedByteBuffer = ras.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, bufferSize);
            try {
                ras.close();
            }
            catch (Throwable t) {
                logger.warn("Error releasing RAS file on buffer creation:" + t.getMessage() + ", file:" + file);
            }
            if (this.buffers.length >= bufferIndex) {
                AtomicBuffer[] newBuffers = new AtomicBuffer[bufferIndex + 1];
                System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
                this.buffers = newBuffers;
            }
            UnsafeBuffer buffer = new UnsafeBuffer((ByteBuffer)mappedByteBuffer);
            this.buffers[bufferIndex] = buffer;
            this.lastBufferSize = bufferSize;
            this.totalCapacity = 1966080000L * (long)bufferIndex + (long)bufferSize;
        }
        catch (IOException e) {
            throw new RuntimeException("ERROR: updating buffer size of buffer:" + file.getPath(), e);
        }
    }

    public File getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public long getTotalCapacity() {
        return this.totalCapacity;
    }

    private File getStoreFile(int index) {
        return new File(this.getPath(), this.getName() + "-" + index + ".idx");
    }

    public void flush() {
        for (AtomicBuffer buffer : this.buffers) {
            MappedByteBuffer byteBuffer = (MappedByteBuffer)buffer.byteBuffer();
            byteBuffer.force();
        }
    }

    public void close() {
        this.flush();
    }

    public void drop() {
        try {
            this.buffers = null;
            for (int index = 0; index == 0 || this.getStoreFile(index).exists(); ++index) {
                File storeFile = this.getStoreFile(index);
                storeFile.delete();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "ResizingAtomicMappedBuffer{path=" + this.path + ", name='" + this.name + "', totalCapacity=" + this.totalCapacity + "}";
    }
}

