/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.distribute;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.teamapps.universaldb.distribute.TransactionMessageType;
import org.teamapps.universaldb.util.DataStreamUtil;

public class TransactionMessageKey {
    private static AtomicLong localTransactionKeyGenerator = new AtomicLong();
    private final TransactionMessageType messageType;
    private final String clientId;
    private final long packetKey;
    private final long transactionKeyOfCallingNode;
    private String masterClientId;
    private long masterOffset;

    public static TransactionMessageKey createFromKey(TransactionMessageKey key, long packetKey, String masterClientId, long masterOffset) {
        return new TransactionMessageKey(key.getMessageType(), key.getClientId(), packetKey, key.getTransactionKeyOfCallingNode(), masterClientId, masterOffset);
    }

    public TransactionMessageKey(TransactionMessageType messageType, String clientId, long packetKey) {
        this.messageType = messageType;
        this.clientId = clientId;
        this.packetKey = packetKey;
        this.transactionKeyOfCallingNode = localTransactionKeyGenerator.incrementAndGet();
    }

    public TransactionMessageKey(TransactionMessageType messageType, String clientId, long packetKey, long transactionKeyOfCallingNode, String masterClientId, long masterOffset) {
        this.messageType = messageType;
        this.clientId = clientId;
        this.packetKey = packetKey;
        this.transactionKeyOfCallingNode = transactionKeyOfCallingNode;
        this.masterClientId = masterClientId;
        this.masterOffset = masterOffset;
    }

    public TransactionMessageKey(byte[] bytes) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(bytes));
        this.messageType = TransactionMessageType.values()[dataInputStream.readInt()];
        this.transactionKeyOfCallingNode = dataInputStream.readLong();
        this.clientId = DataStreamUtil.readStringWithLengthHeader(dataInputStream);
        this.packetKey = dataInputStream.readLong();
        this.masterClientId = DataStreamUtil.readStringWithLengthHeader(dataInputStream);
        this.masterOffset = dataInputStream.readLong();
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this.messageType.ordinal());
        dataOutputStream.writeLong(this.transactionKeyOfCallingNode);
        DataStreamUtil.writeStringWithLengthHeader(dataOutputStream, this.clientId);
        dataOutputStream.writeLong(this.packetKey);
        DataStreamUtil.writeStringWithLengthHeader(dataOutputStream, this.masterClientId);
        dataOutputStream.writeLong(this.masterOffset);
        return byteArrayOutputStream.toByteArray();
    }

    public TransactionMessageType getMessageType() {
        return this.messageType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public long getPacketKey() {
        return this.packetKey;
    }

    public String getMasterClientId() {
        return this.masterClientId;
    }

    public long getMasterOffset() {
        return this.masterOffset;
    }

    public long getTransactionKeyOfCallingNode() {
        return this.transactionKeyOfCallingNode;
    }

    public String toString() {
        return "TransactionMessageKey{messageType=" + this.messageType + ", clientId='" + this.clientId + "', packetKey=" + this.packetKey + ", transactionKeyOfCallingNode=" + this.transactionKeyOfCallingNode + ", masterClientId='" + this.masterClientId + "', masterOffset=" + this.masterOffset + "}";
    }
}

