/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.pojo.Entity;

public class SortEntry<ENTITY extends Entity> {
    private final int id;
    private final int leafId;
    private ENTITY entity;

    public SortEntry(int id) {
        this.id = id;
        this.leafId = id;
    }

    public SortEntry(int id, int leafId) {
        this.id = id;
        this.leafId = leafId;
    }

    public SortEntry(int id, int leafId, ENTITY entity) {
        this.id = id;
        this.leafId = leafId;
        this.entity = entity;
    }

    public int getId() {
        return this.id;
    }

    public int getLeafId() {
        return this.leafId;
    }

    public ENTITY getEntity() {
        return this.entity;
    }

    public void setEntity(ENTITY entity) {
        this.entity = entity;
    }

    public static <ENTITY extends Entity> List<SortEntry<ENTITY>> createSortEntries(List<ENTITY> entities, SingleReferenceIndex ... path) {
        ArrayList<SortEntry<ENTITY>> entries = new ArrayList<SortEntry<ENTITY>>();
        boolean noPath = path == null || path.length == 0;
        for (Entity entity : entities) {
            SingleReferenceIndex singleReferenceIndex;
            if (noPath) {
                entries.add(new SortEntry<Entity>(entity.getId(), entity.getId(), entity));
                continue;
            }
            int recordId = entity.getId();
            SingleReferenceIndex[] singleReferenceIndexArray = path;
            int n = singleReferenceIndexArray.length;
            for (int i = 0; i < n && (recordId = (singleReferenceIndex = singleReferenceIndexArray[i]).getValue(recordId)) != 0; ++i) {
            }
            entries.add(new SortEntry<Entity>(entity.getId(), recordId, entity));
        }
        return entries;
    }

    public static List<SortEntry> createSortEntries(BitSet records, SingleReferenceIndex ... path) {
        ArrayList<SortEntry> entries = new ArrayList<SortEntry>();
        boolean noPath = path == null || path.length == 0;
        int id = records.nextSetBit(0);
        while (id >= 0) {
            if (noPath) {
                entries.add(new SortEntry(id));
            } else {
                SingleReferenceIndex singleReferenceIndex;
                int recordId = id;
                SingleReferenceIndex[] singleReferenceIndexArray = path;
                int n = singleReferenceIndexArray.length;
                for (int i = 0; i < n && (recordId = (singleReferenceIndex = singleReferenceIndexArray[i]).getValue(recordId)) != 0; ++i) {
                }
                entries.add(new SortEntry(id, recordId));
            }
            id = records.nextSetBit(id + 1);
        }
        return entries;
    }
}

