/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.transaction.TransactionRecord;
import org.teamapps.universaldb.transaction.TransactionRecordValue;

public class TableTransactionIndex {
    private LongIndex positionIndex;
    private long currentPosition;
    private File indexFile;
    private File transactionFile;
    private BufferedOutputStream outputStream;

    public TableTransactionIndex(File path, String tableName) throws IOException {
        this.transactionFile = new File(path, tableName + ".traidx");
        this.outputStream = new BufferedOutputStream(new FileOutputStream(this.transactionFile, true));
        if (this.transactionFile.length() == 0L) {
            this.outputStream.write(tableName.getBytes(StandardCharsets.UTF_8));
            this.outputStream.flush();
        }
        this.currentPosition = this.transactionFile.length();
    }

    public void writeTransactionRecord(TransactionRecord transactionRecord) throws IOException {
        int id = transactionRecord.getRecordId();
        if (id <= 0) {
            throw new RuntimeException("Transaction record with wrong ID:" + id + ", path:" + this.transactionFile.getPath());
        }
        long previousPosition = this.positionIndex.getValue(id);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        List<TransactionRecordValue> recordValues = transactionRecord.getRecordValues();
        dos.writeLong(previousPosition);
        dos.writeInt(id);
        dos.writeBoolean(transactionRecord.isUpdate());
        dos.writeBoolean(transactionRecord.isDeleteRecord());
        dos.writeLong(transactionRecord.getRecordTransactionId());
        dos.writeInt(recordValues.size());
        for (TransactionRecordValue recordValue : recordValues) {
            recordValue.writeTransactionValue(dos);
        }
        byte[] bytes = bos.toByteArray();
        this.currentPosition += (long)bytes.length;
        this.outputStream.write(bytes);
    }

    public List<Map<String, Object>> readRecordTransactions(int id) throws IOException {
        long position = this.positionIndex.getValue(id);
        ArrayList<Map<String, Object>> changeMap = new ArrayList<Map<String, Object>>();
        if (position <= 0L) {
            return changeMap;
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.transactionFile, "r");
        FileChannel channel = randomAccessFile.getChannel();
        channel.position(position);
        return changeMap;
    }

    private Map<String, Object> readRecordTransaction(int id, long position) {
        return null;
    }

    public void close() {
        try {
            this.outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void drop() {
        try {
            this.outputStream.close();
            this.transactionFile.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

