/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.buffer;

import java.io.File;
import org.agrona.concurrent.AtomicBuffer;
import org.teamapps.universaldb.index.buffer.AbstractResizingAtomicStore;

public class PrimitiveEntryAtomicStore
extends AbstractResizingAtomicStore {
    protected static final int BYTE_ENTRIES_PER_FILE = 1966080000;
    protected static final int SHORT_ENTRIES_PER_FILE = 983040000;
    protected static final int INTEGER_ENTRIES_PER_FILE = 491520000;
    protected static final int LONG_ENTRIES_PER_FILE = 245760000;
    private static final byte[] BIT_MASKS = new byte[8];

    public PrimitiveEntryAtomicStore(File path, String name) {
        super(path, name);
    }

    public boolean getBoolean(int id) {
        int bit;
        if ((long)id > this.getTotalCapacity() * 8L) {
            return false;
        }
        AtomicBuffer buffer = this.getBuffer(0);
        byte b = buffer.getByte(id / 8);
        return (b & BIT_MASKS[bit = id % 8]) == BIT_MASKS[bit];
    }

    public void setBoolean(int id, boolean value) {
        this.ensureCapacity(id / 8 + 1);
        AtomicBuffer buffer = this.getBuffer(0);
        int pos = id / 8;
        byte b = buffer.getByte(pos);
        int bit = id % 8;
        b = value ? (byte)(b | BIT_MASKS[bit]) : (byte)(b & ~BIT_MASKS[bit]);
        buffer.putByte(pos, b);
    }

    public byte getByte(int id) {
        if (id <= 0 || id > this.getMaximumId(1)) {
            return 0;
        }
        int bufferIndex = id / 1966080000;
        int offset = this.getOffset(id, bufferIndex, 1966080000, 1);
        AtomicBuffer buffer = this.getBuffer(bufferIndex);
        return buffer.getByte(offset);
    }

    public void setByte(int id, byte value) {
        this.ensureCapacity(id, 1);
        int bufferIndex = id / 1966080000;
        int offset = this.getOffset(id, bufferIndex, 1966080000, 1);
        AtomicBuffer buffer = this.getBuffer(bufferIndex);
        buffer.putByte(offset, value);
    }

    public short getShort(int id) {
        if (id <= 0 || id > this.getMaximumId(2)) {
            return 0;
        }
        int bufferIndex = id / 983040000;
        int offset = this.getOffset(id, bufferIndex, 983040000, 2);
        AtomicBuffer buffer = this.getBuffer(bufferIndex);
        return buffer.getShort(offset, byteOrder);
    }

    public void setShort(int id, short value) {
        this.ensureCapacity(id, 2);
        int bufferIndex = id / 983040000;
        int offset = this.getOffset(id, bufferIndex, 983040000, 2);
        AtomicBuffer buffer = this.getBuffer(bufferIndex);
        buffer.putShort(offset, value, byteOrder);
    }

    public int getInt(int id) {
        if (id <= 0 || id > this.getMaximumId(4)) {
            return 0;
        }
        int bufferIndex = id / 491520000;
        int offset = this.getOffset(id, bufferIndex, 491520000, 4);
        AtomicBuffer buffer = this.getBuffer(bufferIndex);
        return buffer.getInt(offset, byteOrder);
    }

    public void setInt(int id, int value) {
        this.ensureCapacity(id, 4);
        int bufferIndex = id / 491520000;
        int offset = this.getOffset(id, bufferIndex, 491520000, 4);
        AtomicBuffer buffer = this.getBuffer(bufferIndex);
        buffer.putInt(offset, value, byteOrder);
    }

    public float getFloat(int id) {
        if (id <= 0 || id > this.getMaximumId(4)) {
            return 0.0f;
        }
        int bufferIndex = id / 491520000;
        int offset = this.getOffset(id, bufferIndex, 491520000, 4);
        AtomicBuffer buffer = this.getBuffer(bufferIndex);
        return buffer.getFloat(offset, byteOrder);
    }

    public void setFloat(int id, float value) {
        this.ensureCapacity(id, 4);
        int bufferIndex = id / 491520000;
        int offset = this.getOffset(id, bufferIndex, 491520000, 4);
        AtomicBuffer buffer = this.getBuffer(bufferIndex);
        buffer.putFloat(offset, value, byteOrder);
    }

    public long getLong(int id) {
        if (id <= 0 || id > this.getMaximumId(8)) {
            return 0L;
        }
        int bufferIndex = id / 245760000;
        int offset = this.getOffset(id, bufferIndex, 245760000, 8);
        AtomicBuffer buffer = this.getBuffer(bufferIndex);
        return buffer.getLong(offset, byteOrder);
    }

    public void setLong(int id, long value) {
        this.ensureCapacity(id, 8);
        int bufferIndex = id / 245760000;
        int offset = this.getOffset(id, bufferIndex, 245760000, 8);
        AtomicBuffer buffer = this.getBuffer(bufferIndex);
        buffer.putLong(offset, value, byteOrder);
    }

    public double getDouble(int id) {
        if (id <= 0 || id > this.getMaximumId(8)) {
            return 0.0;
        }
        int bufferIndex = id / 245760000;
        int offset = this.getOffset(id, bufferIndex, 245760000, 8);
        AtomicBuffer buffer = this.getBuffer(bufferIndex);
        return buffer.getDouble(offset, byteOrder);
    }

    public void setDouble(int id, double value) {
        this.ensureCapacity(id, 8);
        int bufferIndex = id / 245760000;
        int offset = this.getOffset(id, bufferIndex, 245760000, 8);
        AtomicBuffer buffer = this.getBuffer(bufferIndex);
        buffer.putDouble(offset, value, byteOrder);
    }

    protected AtomicBuffer getFirstBuffer() {
        return this.getBuffer(0);
    }

    static {
        PrimitiveEntryAtomicStore.BIT_MASKS[0] = 1;
        PrimitiveEntryAtomicStore.BIT_MASKS[1] = 2;
        PrimitiveEntryAtomicStore.BIT_MASKS[2] = 4;
        PrimitiveEntryAtomicStore.BIT_MASKS[3] = 8;
        PrimitiveEntryAtomicStore.BIT_MASKS[4] = 16;
        PrimitiveEntryAtomicStore.BIT_MASKS[5] = 32;
        PrimitiveEntryAtomicStore.BIT_MASKS[6] = 64;
        PrimitiveEntryAtomicStore.BIT_MASKS[7] = -128;
    }
}

