/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.map;

import java.io.File;
import java.io.IOException;
import net.openhft.chronicle.map.ChronicleMap;

public class CharIntPersistedMap {
    private static final String MAP_CURRENT_ENTRIES_KEY = "_mapCurrent$Entries#";
    private static final int BASE_ENTRIES = 100000;
    private final File path;
    private final String name;
    private ChronicleMap<CharSequence, Integer> map;
    private int entries;
    private int maxEntries;
    private int fileIndex;

    public CharIntPersistedMap(File path, String name) {
        this.path = path;
        this.name = name;
        this.init();
    }

    private void init() {
        int index = this.getFileIndex();
        if (index < 0) {
            this.fileIndex = 0;
            this.maxEntries = this.getEntries(this.fileIndex);
            this.entries = 0;
            this.map = this.createMap(this.getStoreFile(this.fileIndex), this.maxEntries);
            this.map.put((Object)MAP_CURRENT_ENTRIES_KEY, (Object)this.entries);
        } else {
            this.fileIndex = index;
            this.maxEntries = this.getEntries(this.fileIndex);
            this.map = this.createMap(this.getStoreFile(this.fileIndex), this.maxEntries);
            this.entries = (Integer)this.map.get((Object)MAP_CURRENT_ENTRIES_KEY);
        }
    }

    private void checkSize() {
        if (this.entries + 1 >= this.maxEntries) {
            ++this.fileIndex;
            this.maxEntries = this.getEntries(this.fileIndex);
            ChronicleMap<CharSequence, Integer> newMap = this.createMap(this.getStoreFile(this.fileIndex), this.maxEntries);
            this.copyMap(this.map, newMap);
            ChronicleMap<CharSequence, Integer> oldMap = this.map;
            newMap.put((Object)MAP_CURRENT_ENTRIES_KEY, (Object)this.entries);
            this.map = newMap;
            oldMap.close();
        }
    }

    private int getFileIndex() {
        int index = 0;
        while (this.getStoreFile(index).exists()) {
            ++index;
        }
        return index - 1;
    }

    private int getEntries(int index) {
        return (int)Math.pow(2.0, index) * 100000;
    }

    private void copyMap(ChronicleMap<CharSequence, Integer> src, ChronicleMap<CharSequence, Integer> dst) {
        for (CharSequence key : src.keySet()) {
            dst.put((Object)key, (Object)((Integer)src.get((Object)key)));
        }
    }

    private ChronicleMap<CharSequence, Integer> createMap(File storeFile, int maxEntries) {
        try {
            ChronicleMap map = ChronicleMap.of(CharSequence.class, Integer.class).name(this.name).entries((long)maxEntries).averageKeySize(30.0).createPersistedTo(storeFile);
            return map;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private File getStoreFile(int index) {
        return new File(this.getPath(), this.getName() + "-" + index + ".idm");
    }

    public File getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void put(String key, int value) {
        if (!this.map.containsKey((Object)key)) {
            ++this.entries;
            this.checkSize();
            this.map.put((Object)MAP_CURRENT_ENTRIES_KEY, (Object)this.entries);
        }
        this.map.put((Object)key, (Object)value);
    }

    public Integer get(String key) {
        return (Integer)this.map.get((Object)key);
    }

    public void close() {
        this.map.close();
    }

    public void drop() {
        this.close();
        this.map = null;
        for (int i = 0; i <= this.fileIndex; ++i) {
            File storeFile = this.getStoreFile(i);
            if (!storeFile.exists()) continue;
            storeFile.delete();
        }
    }
}

