/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.reference.multi;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.AbstractIndex;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.FullTextIndexingOptions;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.buffer.BlockChainAtomicStore;
import org.teamapps.universaldb.index.reference.ReferenceIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceFilter;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.reference.value.MultiReferenceEditValue;
import org.teamapps.universaldb.index.reference.value.MultiReferenceValue;
import org.teamapps.universaldb.index.reference.value.RecordReference;
import org.teamapps.universaldb.index.reference.value.ReferenceIteratorValue;
import org.teamapps.universaldb.transaction.DataType;

public class MultiReferenceIndex
extends AbstractIndex<MultiReferenceValue, MultiReferenceFilter>
implements ReferenceIndex {
    private final BlockChainAtomicStore referenceStore;
    private TableIndex referencedTable;
    private boolean cyclicReferences;
    private boolean cascadeDeleteReferences;
    private SingleReferenceIndex reverseSingleIndex;
    private MultiReferenceIndex reverseMultiIndex;
    private boolean ensureNoDuplicates = true;

    public MultiReferenceIndex(String name, TableIndex table, ColumnType columnType) {
        super(name, table, columnType, FullTextIndexingOptions.NOT_INDEXED);
        this.referenceStore = new BlockChainAtomicStore(table.getDataPath(), name);
    }

    public void setReferencedTable(TableIndex referencedTable, ColumnIndex reverseIndex, boolean cascadeDeleteReferences) {
        this.referencedTable = referencedTable;
        if (reverseIndex != null) {
            if (reverseIndex instanceof SingleReferenceIndex) {
                this.reverseSingleIndex = (SingleReferenceIndex)reverseIndex;
            } else {
                this.reverseMultiIndex = (MultiReferenceIndex)reverseIndex;
            }
            this.cyclicReferences = true;
        }
        this.cascadeDeleteReferences = cascadeDeleteReferences;
    }

    @Override
    public IndexType getType() {
        return IndexType.MULTI_REFERENCE;
    }

    @Override
    public TableIndex getReferencedTable() {
        return this.referencedTable;
    }

    @Override
    public boolean isCascadeDeleteReferences() {
        return this.cascadeDeleteReferences;
    }

    @Override
    public boolean isMultiReference() {
        return true;
    }

    @Override
    public ColumnIndex getReferencedColumn() {
        if (this.reverseSingleIndex != null) {
            return this.reverseSingleIndex;
        }
        return this.reverseMultiIndex;
    }

    @Override
    public MultiReferenceValue getGenericValue(int id) {
        List<Integer> entries = this.referenceStore.getEntries(id);
        return entries != null ? new ReferenceIteratorValue(entries) : null;
    }

    @Override
    public void setGenericValue(int id, MultiReferenceValue value) {
        switch (value.getType()) {
            case REFERENCE_ITERATOR: {
                break;
            }
            case EDIT_VALUE: {
                this.setReferenceEditValue(id, (MultiReferenceEditValue)value);
            }
        }
    }

    @Override
    public void removeValue(int id) {
        this.removeAllReferences(id);
    }

    public boolean isEmpty(int id) {
        return this.referenceStore.isEmpty(id);
    }

    public int getReferencesCount(int id) {
        return this.referenceStore.getEntryCount(id);
    }

    public List<Integer> getReferencesAsList(int id) {
        return this.referenceStore.getEntries(id);
    }

    public boolean containsReference(int id, int reference) {
        return this.referenceStore.containsEntry(id, reference);
    }

    public boolean containsReference(int id, BitSet reference) {
        return this.referenceStore.containsEntry(id, reference);
    }

    public BitSet getReferencesAsBitSet(int id) {
        BitSet bitSet = new BitSet();
        List<Integer> entries = this.referenceStore.getEntries(id);
        if (entries != null) {
            entries.forEach(bitSet::set);
        }
        return bitSet;
    }

    public void setReferenceEditValue(int id, MultiReferenceEditValue editValue) {
        if (!editValue.getSetReferences().isEmpty()) {
            List<Integer> references = RecordReference.createRecordIdsList(editValue.getSetReferences());
            this.setReferences(id, references, false);
        } else if (editValue.isRemoveAll()) {
            this.removeAllReferences(id);
            if (!editValue.getAddReferences().isEmpty()) {
                List<Integer> references = RecordReference.createRecordIdsList(editValue.getAddReferences());
                this.addReferences(id, references, false);
            }
        } else {
            List<Integer> references;
            if (!editValue.getRemoveReferences().isEmpty()) {
                references = RecordReference.createRecordIdsList(editValue.getRemoveReferences());
                this.removeReferences(id, references, false);
            }
            if (!editValue.getAddReferences().isEmpty()) {
                references = RecordReference.createRecordIdsList(editValue.getAddReferences());
                this.addReferences(id, references, false);
            }
        }
    }

    public void setReferences(int id, List<Integer> references, boolean cyclic) {
        List<Integer> previousEntries;
        if (this.cyclicReferences && !cyclic && !(previousEntries = this.referenceStore.getEntries(id)).isEmpty()) {
            this.removeCyclicReferences(id, previousEntries);
        }
        this.referenceStore.setEntries(id, references);
        if (this.cyclicReferences && !cyclic) {
            this.addCyclicReferences(id, references);
        }
    }

    public void addReferences(int id, List<Integer> references, boolean cyclic) {
        if (this.ensureNoDuplicates && !this.referenceStore.isEmpty(id)) {
            HashSet<Integer> existingSet = new HashSet<Integer>(this.referenceStore.getEntries(id));
            references = references.stream().filter(value -> !existingSet.contains(value)).collect(Collectors.toList());
        }
        this.referenceStore.addEntries(id, references);
        if (this.cyclicReferences && !cyclic) {
            this.addCyclicReferences(id, references);
        }
    }

    public void removeReferences(int id, List<Integer> references, boolean cyclic) {
        if (this.referenceStore.isEmpty(id)) {
            return;
        }
        this.referenceStore.removeEntries(id, references);
        if (this.cyclicReferences && !cyclic) {
            this.removeCyclicReferences(id, references);
        }
    }

    public void removeAllReferences(int id, boolean cyclic) {
        if (cyclic) {
            this.referenceStore.removeAllEntries(id);
        } else {
            this.removeAllReferences(id);
        }
    }

    public void removeAllReferences(int id) {
        if (this.referenceStore.isEmpty(id)) {
            return;
        }
        List<Integer> removeEntries = this.referenceStore.getEntries(id);
        this.referenceStore.removeAllEntries(id);
        if (this.cyclicReferences) {
            this.removeCyclicReferences(id, removeEntries);
        }
    }

    private void addCyclicReferences(int id, List<Integer> references) {
        if (this.reverseSingleIndex != null) {
            for (Integer reference : references) {
                int previousValue = this.reverseSingleIndex.getValue(reference);
                if (previousValue > 0 && previousValue != id) {
                    this.removeReferences(previousValue, Collections.singletonList(reference), true);
                }
                this.reverseSingleIndex.setIndexValue(reference, id);
            }
        } else {
            for (Integer reference : references) {
                this.reverseMultiIndex.addReferences(reference, Collections.singletonList(id), true);
            }
        }
    }

    private void removeCyclicReferences(int id, List<Integer> references) {
        if (this.reverseSingleIndex != null) {
            for (Integer reference : references) {
                int previousValue = this.reverseSingleIndex.getValue(reference);
                if (id != previousValue) continue;
                this.reverseSingleIndex.setIndexValue(reference, 0);
            }
        } else {
            for (Integer reference : references) {
                this.reverseMultiIndex.removeReferences(reference, Collections.singletonList(id), true);
            }
        }
    }

    @Override
    public void writeTransactionValue(MultiReferenceValue value, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.getMappingId());
        dataOutputStream.writeByte(DataType.MULTI_REFERENCE.getId());
        dataOutputStream.writeInt(value.getType().getId());
        value.writeValues(dataOutputStream);
    }

    @Override
    public MultiReferenceValue readTransactionValue(DataInputStream dataInputStream) throws IOException {
        return MultiReferenceValue.create(dataInputStream);
    }

    @Override
    public List<SortEntry> sortRecords(List<SortEntry> sortEntries, boolean ascending, UserContext userContext) {
        int order = ascending ? 1 : -1;
        sortEntries.sort((o1, o2) -> {
            int value1 = this.getReferencesCount(o1.getLeafId());
            int value2 = this.getReferencesCount(o2.getLeafId());
            return Integer.compare(value1, value2) * order;
        });
        return sortEntries;
    }

    @Override
    public void dumpIndex(DataOutputStream dataOutputStream, BitSet records) throws IOException {
        int id = records.nextSetBit(0);
        while (id >= 0) {
            List<Integer> references = this.getReferencesAsList(id);
            dataOutputStream.writeInt(id);
            dataOutputStream.writeInt(references.size());
            for (Integer reference : references) {
                dataOutputStream.writeInt(reference);
            }
            id = records.nextSetBit(id + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreIndex(DataInputStream dataInputStream) throws IOException {
        boolean cyclicReferencesValue = this.cyclicReferences;
        this.cyclicReferences = false;
        try {
            int id = dataInputStream.readInt();
            int count = dataInputStream.readInt();
            ArrayList<Integer> references = new ArrayList<Integer>();
            for (int i = 0; i < count; ++i) {
                references.add(dataInputStream.readInt());
            }
            this.setReferences(id, references, true);
        }
        catch (EOFException eOFException) {
        }
        finally {
            this.cyclicReferences = cyclicReferencesValue;
        }
    }

    @Override
    public BitSet filter(BitSet records, MultiReferenceFilter filter) {
        switch (filter.getType()) {
            case EQUALS: {
                return this.filterEquals(records, filter.getReferencesSet());
            }
            case NOT_EQUALS: {
                return this.filterNotEquals(records, filter.getReferencesSet());
            }
            case IS_EMPTY: {
                return this.filterIsEmpty(records);
            }
            case IS_NOT_EMPTY: {
                return this.filterIsNotEmpty(records);
            }
            case CONTAINS_ANY: {
                return this.filterContainsAny(records, filter.getReferencesSet());
            }
            case CONTAINS_NONE: {
                return this.filterContainsNone(records, filter.getReferencesSet());
            }
            case CONTAINS_ALL: {
                return this.filterContainsAll(records, filter.getReferencesSet());
            }
            case CONTAINS_ANY_NOT: {
                return this.filterContainsAnyNot(records, filter.getReferencesSet());
            }
            case ENTRY_COUNT_EQUALS: {
                return this.filterEntryCountEquals(records, filter.getCountFilter());
            }
            case ENTRY_COUNT_GREATER: {
                return this.filterEntryCountGreater(records, filter.getCountFilter());
            }
            case ENTRY_COUNT_LESSER: {
                return this.filterEntryCountSmaller(records, filter.getCountFilter());
            }
        }
        return null;
    }

    @Override
    public void close() {
        this.referenceStore.close();
    }

    @Override
    public void drop() {
        this.referenceStore.drop();
    }

    public BitSet filterEquals(BitSet bitSet, Set<Integer> compareIds) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            HashSet<Integer> referenceSet;
            int count = this.referenceStore.getEntryCount(id);
            if (count == compareIds.size() && (referenceSet = new HashSet<Integer>(this.referenceStore.getEntries(id))).equals(compareIds)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterNotEquals(BitSet bitSet, Set<Integer> compareIds) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int count = this.referenceStore.getEntryCount(id);
            if (count != compareIds.size()) {
                result.set(id);
            } else {
                HashSet<Integer> referenceSet = new HashSet<Integer>(this.referenceStore.getEntries(id));
                if (!referenceSet.equals(compareIds)) {
                    result.set(id);
                }
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterIsEmpty(BitSet bitSet) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            if (this.referenceStore.isEmpty(id)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterIsNotEmpty(BitSet bitSet) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            if (!this.referenceStore.isEmpty(id)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    private BitSet filterContainsAny(BitSet bitSet, Set<Integer> compareIds) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            List<Integer> entries = this.referenceStore.getEntries(id);
            for (Integer entry : entries) {
                if (!compareIds.contains(entry)) continue;
                result.set(id);
                break;
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    private BitSet filterContainsNone(BitSet bitSet, Set<Integer> compareIds) {
        BitSet result = this.filterContainsAny(bitSet, compareIds);
        return MultiReferenceIndex.negateInput(bitSet, result);
    }

    public BitSet filterContainsAll(BitSet bitSet, Set<Integer> compareIds) {
        BitSet result = new BitSet();
        BitSet compareSet = new BitSet();
        compareIds.forEach(compareSet::set);
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            BitSet referencesAsBitSet = this.getReferencesAsBitSet(id);
            referencesAsBitSet.and(compareSet);
            if (referencesAsBitSet.equals(compareSet)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterContainsAnyNot(BitSet bitSet, Set<Integer> compareIds) {
        BitSet containsAll = this.filterContainsAll(bitSet, compareIds);
        return MultiReferenceIndex.negateInput(bitSet, containsAll);
    }

    public BitSet filterEntryCountEquals(BitSet bitSet, int count) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            if (this.referenceStore.getEntryCount(id) == count) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterEntryCountGreater(BitSet bitSet, int count) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            if (this.referenceStore.getEntryCount(id) > count) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterEntryCountSmaller(BitSet bitSet, int count) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            if (this.referenceStore.getEntryCount(id) < count) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }
}

