/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.buffer.index;

import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.teamapps.universaldb.index.buffer.common.PrimitiveEntryAtomicStore;

public class RecordIndex
extends PrimitiveEntryAtomicStore {
    private int maxSetId;
    private int numberOfSetIds;

    public RecordIndex(File path, String name) {
        super(path, name);
        this.recalculateMaxSetIndex();
        this.recalculateNumberOfSetIds();
    }

    private void recalculateMaxSetIndex() {
        int maximumId = (int)(this.getTotalCapacity() * 8L) - 1;
        int maxId = 0;
        for (int id = maximumId; id > 0; --id) {
            if (!this.getBoolean(id)) continue;
            maxId = id;
            break;
        }
        this.maxSetId = maxId;
    }

    private void recalculateNumberOfSetIds() {
        int count = 0;
        for (int id = 1; id <= this.maxSetId; ++id) {
            if (!this.getBoolean(id)) continue;
            ++count;
        }
        this.numberOfSetIds = count;
    }

    @Override
    public void setBoolean(int id, boolean value) {
        if (id > 0 && value != this.getBoolean(id)) {
            this.numberOfSetIds = value ? ++this.numberOfSetIds : --this.numberOfSetIds;
        }
        super.setBoolean(id, value);
        if (value) {
            if (id > this.maxSetId) {
                this.maxSetId = id;
            }
        } else if (id == this.maxSetId) {
            this.recalculateMaxSetIndex();
        }
    }

    public int createRecord() {
        ++this.maxSetId;
        ++this.numberOfSetIds;
        int id = this.maxSetId;
        super.setBoolean(id, true);
        return id;
    }

    public int getCount() {
        return this.numberOfSetIds;
    }

    public BitSet getBitSet() {
        BitSet bitSet = new BitSet(this.maxSetId);
        for (int i = 1; i <= this.maxSetId; ++i) {
            if (!this.getBoolean(i)) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    public List<Integer> getRecords() {
        ArrayList<Integer> recordIds = new ArrayList<Integer>();
        for (int i = 1; i <= this.maxSetId; ++i) {
            if (!this.getBoolean(i)) continue;
            recordIds.add(i);
        }
        return recordIds;
    }

    public int getMaxId() {
        return this.maxSetId;
    }

    public int getNextAvailableId() {
        return this.maxSetId + 1;
    }
}

