/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.file;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HexFormat;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.teamapps.message.protocol.utils.MessageUtils;
import org.teamapps.udb.model.FileContentData;
import org.teamapps.universaldb.index.file.FileDataField;
import org.teamapps.universaldb.index.file.value.FileValueType;
import org.teamapps.universaldb.index.file.value.MimeType;
import org.teamapps.universaldb.index.file.value.UncommittedFile;
import org.teamapps.universaldb.index.text.FullTextIndexValue;

public interface FileValue {
    public static FileValue create(File file) {
        return new UncommittedFile(file);
    }

    public static FileValue create(File file, String fileName) {
        return new UncommittedFile(file, fileName);
    }

    default public void writeValues(DataOutputStream dos) throws IOException {
        if (this.getType() == FileValueType.UNCOMMITTED_FILE) {
            throw new RuntimeException("Error: cannot serialize uncommitted file");
        }
        MessageUtils.writeString((DataOutputStream)dos, (String)this.getFileName());
        MessageUtils.writeString((DataOutputStream)dos, (String)this.getHash());
        dos.writeLong(this.getSize());
        MessageUtils.writeString((DataOutputStream)dos, (String)this.getKey());
        FileContentData contentData = this.getFileContentData();
        dos.writeBoolean(contentData != null);
        if (contentData != null) {
            contentData.write(dos, null);
        }
    }

    public FileValueType getType();

    public InputStream getInputStream() throws IOException;

    default public File getAsFile() {
        try {
            Path path = Files.createTempFile("tmp", "." + this.getFileExtension(), new FileAttribute[0]);
            Files.copy(this.getInputStream(), path, StandardCopyOption.REPLACE_EXISTING);
            return path.toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    default public String getFileExtension() {
        String name = this.getFileName();
        int pos = name.lastIndexOf(46);
        return pos > 0 ? name.substring(pos).toLowerCase() : "tmp";
    }

    default public void copyToFile(File file) throws IOException {
        Files.copy(this.getInputStream(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    default public byte[] toBytes() throws IOException {
        if (this.getSize() > 100000000L) {
            throw new RuntimeException("File too large for byte array:" + this.getSize());
        }
        BufferedInputStream bis = new BufferedInputStream(this.getInputStream());
        return IOUtils.readFully((InputStream)bis, (int)((int)this.getSize()));
    }

    public String getFileName();

    public long getSize();

    public String getHash();

    public String getKey();

    default public byte[] getHashBytes() {
        return HexFormat.of().parseHex(this.getHash());
    }

    default public byte[] getKeyBytes() {
        return this.getKey() != null ? HexFormat.of().parseHex(this.getKey()) : null;
    }

    public FileContentData getFileContentData();

    default public FileContentData getFileContentData(int maxContentLength) {
        return this.getFileContentData();
    }

    public String getDetectedLanguage();

    default public MimeType getMimeTypeData() {
        MimeType mimeType = MimeType.getMimeType(this.getFileName());
        if (mimeType == null && this.getFileContentData() != null) {
            mimeType = MimeType.getMimeTypeByMime(this.getFileContentData().getMimeType());
        }
        return mimeType;
    }

    default public List<FullTextIndexValue> getFullTextIndexData() {
        FileContentData contentData;
        ArrayList<FullTextIndexValue> fullTextIndexValues = new ArrayList<FullTextIndexValue>();
        fullTextIndexValues.add(new FullTextIndexValue(FileDataField.NAME.name(), this.getFileName()));
        String fileExtension = this.getFileExtension();
        if (fileExtension != null && !fileExtension.isBlank()) {
            fullTextIndexValues.add(new FullTextIndexValue(FileDataField.EXTENSION.name(), fileExtension));
        }
        if ((contentData = this.getFileContentData()).getContent() != null) {
            fullTextIndexValues.add(new FullTextIndexValue(FileDataField.CONTENT.name(), contentData.getContent()));
        }
        if (contentData.getMetaValues() != null) {
            String metaData = String.join((CharSequence)", ", contentData.getMetaValues());
            fullTextIndexValues.add(new FullTextIndexValue(FileDataField.META_DATA.name(), metaData));
        }
        return fullTextIndexValues;
    }

    default public String getMimeType() {
        return this.getFileContentData() == null ? null : this.getFileContentData().getMimeType();
    }

    default public String getTextContent() {
        return this.getFileContentData() == null ? null : this.getFileContentData().getContent();
    }

    default public String getLatitude() {
        return this.getFileContentData() == null ? null : this.getFileContentData().getLatitude();
    }

    default public String getLongitude() {
        return this.getFileContentData() == null ? null : this.getFileContentData().getLongitude();
    }

    default public int getPageCount() {
        return this.getFileContentData() == null ? 0 : this.getFileContentData().getPages();
    }

    default public int getImageWidth() {
        return this.getFileContentData() == null ? 0 : this.getFileContentData().getImageWidth();
    }

    default public int getImageHeight() {
        return this.getFileContentData() == null ? 0 : this.getFileContentData().getImageHeight();
    }

    default public String getContentCreatedBy() {
        return this.getFileContentData() == null ? null : this.getFileContentData().getCreatedBy();
    }

    default public Instant getContentCreationDate() {
        return this.getFileContentData() == null ? null : this.getFileContentData().getDateCreated();
    }

    default public String getContentModifiedBy() {
        return this.getFileContentData() == null ? null : this.getFileContentData().getModifiedBy();
    }

    default public Instant getContentModificationDate() {
        return this.getFileContentData() == null ? null : this.getFileContentData().getDateModified();
    }

    default public String getDevice() {
        return this.getFileContentData() == null ? null : this.getFileContentData().getDevice();
    }

    default public String getSoftware() {
        return this.getFileContentData() == null ? null : this.getFileContentData().getSoftware();
    }
}

