/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.transaction;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.index.buffer.common.PrimitiveEntryAtomicStore;
import org.teamapps.universaldb.index.log.DefaultLogIndex;
import org.teamapps.universaldb.index.log.LogIndex;
import org.teamapps.universaldb.index.log.LogIterator;
import org.teamapps.universaldb.index.log.RotatingLogIndex;
import org.teamapps.universaldb.index.transaction.resolved.ResolvedTransaction;
import org.teamapps.universaldb.index.transaction.schema.ModelUpdate;
import org.teamapps.universaldb.model.DatabaseModel;

public class TransactionIndex {
    private static final int FIRST_SYSTEM_START = 1;
    private static final int LAST_SYSTEM_START = 2;
    private static final int TIMESTAMP_SHUTDOWN = 3;
    private static final int LAST_TRANSACTION_ID = 4;
    private static final int LAST_TRANSACTION_STORE_ID = 5;
    private static final int LAST_TRANSACTION_REQUEST_ID = 6;
    private static final int TRANSACTIONS_COUNT = 7;
    private static final int NODE_ID = 8;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final File path;
    private final LogIndex transactionLog;
    private final LogIndex modelsLog;
    private PrimitiveEntryAtomicStore databaseStats;
    private volatile boolean active = true;
    private DatabaseModel currentModel;
    private ModelUpdate currentModelUpdate;

    public TransactionIndex(File path, boolean skipIndexCheck) {
        this.path = path;
        this.transactionLog = new RotatingLogIndex(this.path, "transactions");
        this.modelsLog = new DefaultLogIndex(this.path, "models");
        this.databaseStats = new PrimitiveEntryAtomicStore(this.path, "db-stats");
        this.init();
        if (!skipIndexCheck) {
            this.checkIndex();
        }
    }

    private void init() {
        if (this.getNodeId() == 0L) {
            this.databaseStats.setLong(8, TransactionIndex.createId());
        }
        if (this.getSystemFirstStart() == 0L) {
            this.databaseStats.setLong(1, System.currentTimeMillis());
        }
        this.databaseStats.setLong(2, System.currentTimeMillis());
        this.currentModelUpdate = this.getModelUpdates().stream().reduce((first, second) -> second).orElse(null);
        this.currentModel = this.currentModelUpdate == null ? null : this.currentModelUpdate.getMergedModel();
        logger.info(UniversalDB.SKIP_DB_LOGGING, "STARTED TRANSACTION INDEX: node-id: {}, last-transaction-id: {}, last-transaction-store-id: {}, transaction-count: {}, last-request-id: {}, schema-updates: {}", new Object[]{this.getNodeIdAsString(), this.getLastTransactionId(), this.getLastTransactionStoreId(), this.getTransactionCount(), this.getLastTransactionRequestId(), this.getModelUpdates().size()});
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.active = false;
                logger.info(UniversalDB.SKIP_DB_LOGGING, "SHUTTING DOWN TRANSACTION INDEX: node-id: {}, last-transaction-id: {}, last-transaction-store-id: {}, transaction-count: {}, last-request-id: {}", new Object[]{this.getNodeIdAsString(), this.getLastTransactionId(), this.getLastTransactionStoreId(), this.getTransactionCount(), this.getLastTransactionRequestId()});
                this.databaseStats.setLong(3, System.currentTimeMillis());
                this.transactionLog.close();
                this.modelsLog.close();
                this.databaseStats.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }));
    }

    private boolean checkIndex() {
        LogIterator logIterator = this.transactionLog.readLogs();
        long expectedTransactionId = 1L;
        boolean ok = true;
        logger.info(UniversalDB.SKIP_DB_LOGGING, "Checking transaction index...");
        while (logIterator.hasNext()) {
            ResolvedTransaction transaction = ResolvedTransaction.createResolvedTransaction(logIterator.next());
            if (expectedTransactionId != transaction.getTransactionId()) {
                logger.error(UniversalDB.SKIP_DB_LOGGING, "Wrong transaction id: {}, expected: {}", (Object)transaction.getTransactionId(), (Object)expectedTransactionId);
                ok = false;
            }
            expectedTransactionId = transaction.getTransactionId() + 1L;
        }
        logger.info(UniversalDB.SKIP_DB_LOGGING, "Transaction index check result: {}", (Object)ok);
        if (!ok) {
            throw new RuntimeException("Error in transaction log!");
        }
        logIterator.closeSave();
        return ok;
    }

    public boolean isEmpty() {
        return this.transactionLog.isEmpty();
    }

    public synchronized long createTransactionRequestId() {
        long requestId = this.getLastTransactionRequestId() + 1L;
        this.databaseStats.setLong(6, requestId);
        return requestId;
    }

    public long getSystemFirstStart() {
        return this.databaseStats.getLong(1);
    }

    public long getSystemLastStart() {
        return this.databaseStats.getLong(2);
    }

    public long getLastTransactionId() {
        return this.databaseStats.getLong(4);
    }

    public long getLastTransactionStoreId() {
        return this.databaseStats.getLong(5);
    }

    public long getTransactionCount() {
        return this.databaseStats.getLong(7);
    }

    public long getLastTransactionRequestId() {
        return this.databaseStats.getLong(6);
    }

    public long getNodeId() {
        return this.databaseStats.getLong(8);
    }

    public String getNodeIdAsString() {
        return Long.toHexString(this.getNodeId()).toUpperCase();
    }

    public ResolvedTransaction getLastTransaction() {
        if (this.transactionLog.isEmpty()) {
            return null;
        }
        byte[] bytes = this.transactionLog.readLog(this.getLastTransactionStoreId());
        return ResolvedTransaction.createResolvedTransaction(bytes);
    }

    public synchronized boolean isValidModel(DatabaseModel model) {
        return this.currentModel == null && model.isValid() || this.currentModel.isCompatible(model);
    }

    public synchronized boolean isModelUpdate(DatabaseModel model) {
        if (this.currentModelUpdate != null && this.currentModelUpdate.getDatabaseModel().isSameModel(model)) {
            return false;
        }
        return this.getModelUpdates().stream().noneMatch(update -> update.getDatabaseModel().getPojoBuildTime() == model.getPojoBuildTime());
    }

    public synchronized void writeModelUpdate(ModelUpdate modelUpdate) throws IOException {
        this.currentModelUpdate = modelUpdate;
        DatabaseModel model = modelUpdate.getDatabaseModel();
        if (this.currentModel == null) {
            this.currentModel = model;
            this.currentModel.initialize();
        } else {
            this.currentModel.mergeModel(model);
        }
        modelUpdate.setMergedModel(this.currentModel);
        this.modelsLog.writeLog(modelUpdate.getBytes());
        logger.info(UniversalDB.SKIP_DB_LOGGING, "Updating schema");
    }

    public synchronized DatabaseModel getCurrentModel() {
        return this.currentModel;
    }

    public synchronized void writeTransaction(ResolvedTransaction transaction) throws Exception {
        if (!this.active) {
            throw new RuntimeException("Error transaction index already shut down");
        }
        if (transaction.getTransactionId() != this.getLastTransactionId() + 1L) {
            throw new RuntimeException(String.format("Error wrong transaction id: %s, last transaction id: %s", transaction.getTransactionId(), this.getLastTransactionId()));
        }
        this.transactionLog.writeLog(transaction.getBytes());
        this.databaseStats.setLong(4, transaction.getTransactionId());
        this.databaseStats.setLong(5, this.transactionLog.getPosition());
        this.databaseStats.setLong(7, this.getTransactionCount() + 1L);
    }

    public synchronized List<ModelUpdate> getModelUpdates() {
        if (this.modelsLog.isEmpty()) {
            return Collections.emptyList();
        }
        return this.modelsLog.readAllLogs().stream().map(ModelUpdate::new).collect(Collectors.toList());
    }

    public Stream<ResolvedTransaction> getTransactions(long lastTransactionId) {
        LogIterator logIterator = this.transactionLog.readLogs();
        Stream<byte[]> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(logIterator, 16), false);
        return stream.map(ResolvedTransaction::createResolvedTransaction).filter(transaction -> transaction.getTransactionId() > lastTransactionId);
    }

    public LogIterator getLogIterator() {
        return this.transactionLog.readLogs();
    }

    private static long createId() {
        long id;
        SecureRandom secureRandom = new SecureRandom();
        while (Long.toHexString(id = Math.abs(secureRandom.nextLong())).length() != 16) {
        }
        return id;
    }
}

