/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.teamapps.message.protocol.utils.MessageUtils;
import org.teamapps.universaldb.model.DatabaseModel;
import org.teamapps.universaldb.model.FieldModel;
import org.teamapps.universaldb.model.FieldType;
import org.teamapps.universaldb.model.TableModel;

public class ReferenceFieldModel
extends FieldModel {
    private TableModel referencedTable;
    private final boolean multiReference;
    private final boolean cascadeDelete;
    private ReferenceFieldModel reverseReferenceField;

    protected ReferenceFieldModel(String title, TableModel tableModel, TableModel referencedTable, boolean multiReference, boolean cascadeDelete, ReferenceFieldModel reverseReferenceField) {
        this(title, title, tableModel, referencedTable, multiReference, cascadeDelete, reverseReferenceField);
    }

    protected ReferenceFieldModel(String name, String title, TableModel tableModel, TableModel referencedTable, boolean multiReference, boolean cascadeDelete, ReferenceFieldModel reverseReferenceField) {
        super(name, title, tableModel, multiReference ? FieldType.MULTI_REFERENCE : FieldType.SINGLE_REFERENCE);
        this.referencedTable = referencedTable;
        this.multiReference = multiReference;
        this.cascadeDelete = cascadeDelete;
        this.setReverseReferenceField(reverseReferenceField);
    }

    protected ReferenceFieldModel(DataInputStream dis, TableModel tableModel, List<Function<DatabaseModel, Boolean>> resolveFunctions) throws IOException {
        super(dis, tableModel);
        String referencedTableName = MessageUtils.readString((DataInputStream)dis);
        resolveFunctions.add(databaseModel -> {
            TableModel table = databaseModel.getTable(referencedTableName);
            this.setReferencedTable(table);
            return table != null;
        });
        this.multiReference = dis.readBoolean();
        this.cascadeDelete = dis.readBoolean();
        if (dis.readBoolean()) {
            String reverseReferenceTableName = MessageUtils.readString((DataInputStream)dis);
            String reverseReferenceFieldName = MessageUtils.readString((DataInputStream)dis);
            resolveFunctions.add(databaseModel -> {
                ReferenceFieldModel referenceField = databaseModel.getReferenceField(reverseReferenceTableName, reverseReferenceFieldName);
                this.setReverseReferenceField(referenceField);
                return referenceField != null;
            });
        }
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        super.write(dos);
        MessageUtils.writeString((DataOutputStream)dos, (String)this.referencedTable.getName());
        dos.writeBoolean(this.multiReference);
        dos.writeBoolean(this.cascadeDelete);
        if (this.reverseReferenceField == null) {
            dos.writeBoolean(false);
        } else {
            dos.writeBoolean(true);
            MessageUtils.writeString((DataOutputStream)dos, (String)this.reverseReferenceField.getTableModel().getName());
            MessageUtils.writeString((DataOutputStream)dos, (String)this.reverseReferenceField.getName());
        }
    }

    public TableModel getReferencedTable() {
        return this.referencedTable;
    }

    private void setReferencedTable(TableModel referencedTable) {
        this.referencedTable = referencedTable;
    }

    public boolean isMultiReference() {
        return this.multiReference;
    }

    public boolean isCascadeDelete() {
        return this.cascadeDelete;
    }

    public ReferenceFieldModel getReverseReferenceField() {
        return this.reverseReferenceField;
    }

    protected void setReverseReferenceField(ReferenceFieldModel reverseReferenceField) {
        if (reverseReferenceField == null) {
            return;
        }
        this.reverseReferenceField = reverseReferenceField;
        if (reverseReferenceField.getReverseReferenceField() == null) {
            reverseReferenceField.setReverseReferenceField(this);
        }
    }
}

