/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.pojo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.teamapps.udb.model.FileContentData;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.index.FieldIndex;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.file.FileIndex;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.file.store.DatabaseFileStore;
import org.teamapps.universaldb.index.file.value.FileValueType;
import org.teamapps.universaldb.index.file.value.StoreDescriptionFile;
import org.teamapps.universaldb.index.reference.value.MultiReferenceEditValue;
import org.teamapps.universaldb.index.reference.value.RecordReference;
import org.teamapps.universaldb.index.transaction.request.TransactionRequest;
import org.teamapps.universaldb.index.transaction.request.TransactionRequestRecord;
import org.teamapps.universaldb.index.transaction.request.TransactionRequestRecordValue;
import org.teamapps.universaldb.model.FileFieldModel;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.Entity;

public class EntityChangeSet {
    private final Map<Integer, TransactionRequestRecordValue> changeMap = new HashMap<Integer, TransactionRequestRecordValue>();
    private final Map<Integer, AbstractUdbEntity> changedReferenceMap = new HashMap<Integer, AbstractUdbEntity>();
    private final Map<RecordReference, Entity> entityByReference = new HashMap<RecordReference, Entity>();

    public void addChangeValue(FieldIndex fieldIndex, Object value) {
        TransactionRequestRecordValue requestRecordValue = new TransactionRequestRecordValue(fieldIndex.getMappingId(), fieldIndex.getType(), value);
        this.changeMap.put(requestRecordValue.getColumnId(), requestRecordValue);
    }

    public void addRecordReference(RecordReference reference, Entity entity) {
        this.entityByReference.put(reference, entity);
    }

    public Map<RecordReference, Entity> getEntityByReference() {
        return this.entityByReference;
    }

    public TransactionRequestRecordValue getChangeValue2(FieldIndex index) {
        return this.changeMap.get(index.getMappingId());
    }

    public boolean isChanged(FieldIndex fieldIndex) {
        return this.changeMap.containsKey(fieldIndex.getMappingId());
    }

    public void removeChange(FieldIndex fieldIndex) {
        this.changeMap.remove(fieldIndex);
    }

    public TransactionRequestRecordValue getChangeValue(FieldIndex index) {
        return this.changeMap.get(index.getMappingId());
    }

    public void setTransactionRequestRecordValues(TransactionRequest transactionRequest, TransactionRequestRecord record, UniversalDB database) {
        ArrayList<AbstractUdbEntity> uncommittedEntityReferences = new ArrayList<AbstractUdbEntity>();
        ArrayList<TransactionRequestRecordValue> changeValues = new ArrayList<TransactionRequestRecordValue>(this.changeMap.values());
        for (TransactionRequestRecordValue recordValue : changeValues) {
            IndexType indexType = recordValue.getIndexType();
            Object value = recordValue.getValue();
            if (value == null) {
                record.addRecordValue(recordValue);
                continue;
            }
            switch (indexType) {
                case MULTI_REFERENCE: {
                    Entity entity;
                    MultiReferenceEditValue editValue = (MultiReferenceEditValue)value;
                    for (RecordReference recordReference : editValue.getAddReferences()) {
                        entity = this.entityByReference.get(recordReference);
                        if (entity.getId() == 0) {
                            uncommittedEntityReferences.add((AbstractUdbEntity)entity);
                            continue;
                        }
                        if (recordReference.getRecordId() != 0 || entity.getId() <= 0) continue;
                        recordReference.setRecordId(entity.getId());
                    }
                    for (RecordReference recordReference : editValue.getSetReferences()) {
                        entity = this.entityByReference.get(recordReference);
                        if (entity.getId() == 0) {
                            uncommittedEntityReferences.add((AbstractUdbEntity)entity);
                            continue;
                        }
                        if (recordReference.getRecordId() != 0 || entity.getId() <= 0) continue;
                        recordReference.setRecordId(entity.getId());
                    }
                    record.addRecordValue(recordValue);
                    break;
                }
                case REFERENCE: {
                    RecordReference recordReference = (RecordReference)value;
                    AbstractUdbEntity entity = this.getReferenceChange(recordValue.getColumnId());
                    if (entity.getId() == 0) {
                        uncommittedEntityReferences.add(entity);
                    } else if (recordReference.getRecordId() == 0 && entity.getId() > 0) {
                        recordReference.setRecordId(entity.getId());
                    }
                    record.addRecordValue(recordValue);
                    break;
                }
                case FILE: {
                    FileValue fileValue = (FileValue)value;
                    if (fileValue.getType() == FileValueType.UNCOMMITTED_FILE) {
                        FileContentData contentData;
                        FileIndex fileIndex = (FileIndex)database.getColumnById(recordValue.getColumnId());
                        FileFieldModel model = fileIndex.getFileFieldModel();
                        DatabaseFileStore fileStore = database.getDatabaseIndex().getDatabaseFileStore();
                        String key = fileStore.storeFile(fileValue.getAsFile(), fileValue.getHash(), fileValue.getSize());
                        FileContentData fileContentData = contentData = model.isIndexContent() ? fileValue.getFileContentData(model.getMaxIndexContentLength()) : null;
                        if (model.isIndexContent() && model.isDetectLanguage()) {
                            fileValue.getDetectedLanguage();
                        }
                        StoreDescriptionFile storeDescriptionFile = new StoreDescriptionFile(null, fileValue.getFileName(), fileValue.getSize(), fileValue.getHash(), key, contentData);
                        record.addRecordValue(fileIndex, storeDescriptionFile);
                        break;
                    }
                    throw new RuntimeException("Error wrong file value type to save:" + String.valueOf((Object)fileValue.getType()));
                }
                default: {
                    record.addRecordValue(recordValue);
                }
            }
        }
        for (AbstractUdbEntity entity : uncommittedEntityReferences) {
            entity.saveRecord(transactionRequest, database);
        }
    }

    public void setReferenceChange(FieldIndex index, AbstractUdbEntity reference) {
        this.changedReferenceMap.put(index.getMappingId(), reference);
    }

    public AbstractUdbEntity getReferenceChange(int columnId) {
        return this.changedReferenceMap.get(columnId);
    }
}

