/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.query;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.teamapps.universaldb.index.FieldIndex;
import org.teamapps.universaldb.index.file.FileFilter;
import org.teamapps.universaldb.index.text.TextFieldFilter;
import org.teamapps.universaldb.index.text.TextFilter;
import org.teamapps.universaldb.query.Filter;
import org.teamapps.universaldb.query.IndexPath;

public class IndexFilter<TYPE, FILTER>
implements Filter {
    private final FieldIndex<TYPE, FILTER> fieldIndex;
    private final FILTER filter;
    private final boolean fullTextFilter;
    private IndexPath indexPath;

    public static List<TextFieldFilter> createTextFilters(List<IndexFilter> filters) {
        ArrayList<TextFieldFilter> textFieldFilters = new ArrayList<TextFieldFilter>();
        for (IndexFilter filter : filters) {
            FieldIndex fieldIndex = filter.getColumnIndex();
            if (filter.getFilter() instanceof TextFilter) {
                TextFilter textFilter = (TextFilter)filter.getFilter();
                textFieldFilters.add(TextFieldFilter.create(textFilter, fieldIndex.getName()));
                continue;
            }
            if (!(filter.getFilter() instanceof FileFilter)) continue;
        }
        return textFieldFilters;
    }

    public IndexFilter(FieldIndex<TYPE, FILTER> fieldIndex, FILTER filter) {
        this(fieldIndex, filter, new IndexPath());
    }

    public IndexFilter(FieldIndex<TYPE, FILTER> fieldIndex, FILTER filter, IndexPath indexPath) {
        this.fieldIndex = fieldIndex;
        this.filter = filter;
        this.fullTextFilter = filter instanceof TextFilter || filter instanceof FileFilter;
        this.indexPath = indexPath;
    }

    public boolean isFullTextFilter() {
        return this.fullTextFilter;
    }

    public FieldIndex<TYPE, FILTER> getColumnIndex() {
        return this.fieldIndex;
    }

    public FILTER getFilter() {
        return this.filter;
    }

    @Override
    public BitSet filter(BitSet input) {
        BitSet localRecords = this.indexPath.calculatePathBitSet(input);
        BitSet result = this.localFilter(localRecords);
        return this.indexPath.calculateReversePath(result, input);
    }

    @Override
    public BitSet localFilter(BitSet localRecords) {
        return this.fieldIndex.filter(localRecords, this.filter);
    }

    @Override
    public IndexPath getPath() {
        return this.indexPath;
    }

    @Override
    public void prependPath(IndexPath path) {
        IndexPath copy = path.copy();
        if (this.indexPath == null) {
            this.indexPath = copy;
        } else {
            copy.addPath(this.indexPath);
            this.indexPath = copy;
        }
    }

    @Override
    public String explain(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getExplainTabs(level));
        if (this.indexPath != null && !this.indexPath.isLocalPath()) {
            sb.append(this.indexPath).append(": ");
        }
        sb.append(this.fieldIndex.getFQN()).append(": ").append(this.filter);
        sb.append("\n");
        return sb.toString();
    }

    public String toString() {
        return this.explain(0);
    }
}

