/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.transaction.schema;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.teamapps.universaldb.model.DatabaseModel;

public class ModelUpdate {
    private final DatabaseModel databaseModel;
    private final long timestamp;
    private final long transactionId;
    private DatabaseModel mergedModel;

    public ModelUpdate(DatabaseModel databaseModel, long transactionId, long timestamp) {
        this.databaseModel = databaseModel;
        this.timestamp = timestamp;
        this.transactionId = transactionId;
    }

    public ModelUpdate(byte[] data) {
        this(new DataInputStream(new ByteArrayInputStream(data)));
    }

    public ModelUpdate(DataInputStream dis) {
        try {
            this.databaseModel = new DatabaseModel(dis);
            this.timestamp = dis.readLong();
            this.transactionId = dis.readLong();
            if (dis.readBoolean()) {
                this.mergedModel = new DatabaseModel(dis);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading log update", e);
        }
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.write(dos);
        return bos.toByteArray();
    }

    public void write(DataOutputStream dos) throws IOException {
        this.databaseModel.write(dos);
        dos.writeLong(this.timestamp);
        dos.writeLong(this.transactionId);
        if (this.mergedModel == null) {
            dos.writeBoolean(false);
        } else {
            dos.writeBoolean(true);
            this.mergedModel.write(dos);
        }
    }

    public DatabaseModel getDatabaseModel() {
        return this.databaseModel;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public DatabaseModel getMergedModel() {
        return this.mergedModel;
    }

    public void setMergedModel(DatabaseModel mergedModel) {
        this.mergedModel = mergedModel;
    }
}

