/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.teamapps.message.protocol.utils.MessageUtils;
import org.teamapps.universaldb.model.DatabaseModel;
import org.teamapps.universaldb.model.EnumModel;
import org.teamapps.universaldb.model.FieldModel;
import org.teamapps.universaldb.model.FieldType;
import org.teamapps.universaldb.model.TableModel;

public class EnumFieldModel
extends FieldModel {
    private EnumModel enumModel;

    protected EnumFieldModel(String title, TableModel tableModel, EnumModel enumModel) {
        this(title, title, tableModel, enumModel);
    }

    protected EnumFieldModel(String name, String title, TableModel tableModel, EnumModel enumModel) {
        super(name, title, tableModel, FieldType.ENUM);
        this.enumModel = enumModel;
    }

    protected EnumFieldModel(DataInputStream dis, TableModel model, DatabaseModel databaseModel) throws IOException {
        super(dis, model);
        String enumModelName = MessageUtils.readString((DataInputStream)dis);
        this.enumModel = databaseModel.getEnumModel(enumModelName);
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        super.write(dos);
        MessageUtils.writeString((DataOutputStream)dos, (String)this.enumModel.getName());
    }

    public EnumModel getEnumModel() {
        return this.enumModel;
    }

    protected void setEnumModel(EnumModel enumModel) {
        this.enumModel = enumModel;
    }
}

