/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.teamapps.message.protocol.utils.MessageUtils;
import org.teamapps.universaldb.model.BaseFieldModel;
import org.teamapps.universaldb.model.FieldType;
import org.teamapps.universaldb.model.NamingUtils;
import org.teamapps.universaldb.model.TableModel;

public class FieldModel
implements BaseFieldModel {
    private static final int FIELD_MODEL_VERSION = 1;
    private final String name;
    private String title;
    private final TableModel tableModel;
    private final FieldType fieldType;
    private int fieldId;
    private boolean deprecated;
    private boolean deleted;
    private int dateCreated;
    private int dateModified;
    private int versionCreated;
    private int versionModified;

    protected FieldModel(String title, TableModel tableModel, FieldType fieldType) {
        this(title, title, tableModel, fieldType);
    }

    protected FieldModel(String name, String title, TableModel tableModel, FieldType fieldType) {
        NamingUtils.checkName(name, title);
        this.name = NamingUtils.createName(name);
        this.title = NamingUtils.createTitle(title);
        this.tableModel = tableModel;
        this.fieldType = fieldType;
    }

    protected FieldModel(DataInputStream dis, TableModel model) throws IOException {
        int modelVersion = dis.readInt();
        this.name = MessageUtils.readString((DataInputStream)dis);
        this.title = MessageUtils.readString((DataInputStream)dis);
        this.tableModel = model;
        this.fieldType = FieldType.getTypeById(dis.readInt());
        this.fieldId = dis.readInt();
        this.deprecated = dis.readBoolean();
        this.deleted = dis.readBoolean();
        this.dateCreated = dis.readInt();
        this.dateModified = dis.readInt();
        this.versionCreated = dis.readInt();
        this.versionModified = dis.readInt();
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(1);
        MessageUtils.writeString((DataOutputStream)dos, (String)this.name);
        MessageUtils.writeString((DataOutputStream)dos, (String)this.title);
        dos.writeInt(this.fieldType.getId());
        dos.writeInt(this.fieldId);
        dos.writeBoolean(this.deprecated);
        dos.writeBoolean(this.deleted);
        dos.writeInt(this.dateCreated);
        dos.writeInt(this.dateModified);
        dos.writeInt(this.versionCreated);
        dos.writeInt(this.versionModified);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    @Override
    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Override
    public int getFieldId() {
        return this.fieldId;
    }

    protected void setFieldId(int fieldId) {
        if (this.fieldId != 0) {
            throw new RuntimeException("Error: field id already set:" + this.fieldId + ", new:" + fieldId);
        }
        this.fieldId = fieldId;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    protected void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    protected void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public int getDateCreated() {
        return this.dateCreated;
    }

    protected void setDateCreated(int dateCreated) {
        this.dateCreated = dateCreated;
    }

    public int getDateModified() {
        return this.dateModified;
    }

    protected void setDateModified(int dateModified) {
        this.dateModified = dateModified;
    }

    public int getVersionCreated() {
        return this.versionCreated;
    }

    protected void setVersionCreated(int versionCreated) {
        this.versionCreated = versionCreated;
    }

    public int getVersionModified() {
        return this.versionModified;
    }

    protected void setVersionModified(int versionModified) {
        this.versionModified = versionModified;
    }

    public boolean isMetaField() {
        return TableModel.isReservedMetaName(this.name);
    }

    public String toString() {
        return this.name + " (" + this.title + "): " + this.fieldType.name() + " [" + this.fieldId + "]";
    }
}

