/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.query;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.universaldb.index.FieldIndex;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.text.TextFilter;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.index.translation.TranslatableTextIndex;
import org.teamapps.universaldb.query.AndFilter;
import org.teamapps.universaldb.query.IndexFilter;
import org.teamapps.universaldb.query.IndexPath;
import org.teamapps.universaldb.query.OrFilter;

public interface Filter {
    public static Map<IndexPath, List<Filter>> mapFilters(List<Filter> filters) {
        HashMap<IndexPath, List<Filter>> filtersByPath = new HashMap<IndexPath, List<Filter>>();
        filters.stream().filter((? super T filter) -> filter.getPath() != null).forEach(filter -> filtersByPath.computeIfAbsent(filter.getPath(), f -> new ArrayList()).add(filter));
        return filtersByPath;
    }

    public static List<List<Filter>> mapFiltersByPathAndExpense(List<Filter> filters) {
        Map<IndexPath, List<Filter>> map = Filter.mapFilters(filters);
        ArrayList<IndexPath> keys = new ArrayList<IndexPath>(map.keySet());
        Collections.sort(keys);
        ArrayList<List<Filter>> mappedFilters = new ArrayList<List<Filter>>();
        for (IndexPath key : keys) {
            mappedFilters.add(map.get(key));
        }
        List filtersWithoutPath = filters.stream().filter((? super T filter) -> filter.getPath() == null).collect(Collectors.toList());
        if (filtersWithoutPath != null && !filtersWithoutPath.isEmpty()) {
            mappedFilters.add(filtersWithoutPath);
        }
        return mappedFilters;
    }

    public static List<IndexFilter> getCollectionFullTextFilters(List<Filter> filters) {
        return filters.stream().filter((? super T filter) -> filter.isCollectionFullTextFilter(false)).map(filter -> (IndexFilter)filter).collect(Collectors.toList());
    }

    public static List<Filter> getNonCollectionFullTextFilters(List<Filter> filters) {
        return filters.stream().filter((? super T filter) -> !filter.isCollectionFullTextFilter(false)).collect(Collectors.toList());
    }

    public static List<IndexFilter> getCollectionFullTextFiltersWithLocalIndexFilterPart(List<Filter> filters) {
        List<IndexFilter> collectionFullTextFilters = Filter.getCollectionFullTextFilters(filters);
        return collectionFullTextFilters.stream().filter((? super T filter) -> !filter.isCollectionFullTextFilter(true)).collect(Collectors.toList());
    }

    public BitSet filter(BitSet var1);

    public BitSet localFilter(BitSet var1);

    public IndexPath getPath();

    public void prependPath(IndexPath var1);

    default public Filter and(Filter filter) {
        if (filter == null) {
            return this;
        }
        return new AndFilter(this, filter);
    }

    default public Filter or(Filter filter) {
        if (filter == null) {
            return this;
        }
        return new OrFilter(this, filter);
    }

    default public Filter asOrFilter() {
        return new OrFilter(this);
    }

    default public boolean isCollectionFullTextFilter(boolean checkExclusive) {
        if (this instanceof IndexFilter) {
            IndexFilter indexFilter = (IndexFilter)this;
            FieldIndex fieldIndex = indexFilter.getColumnIndex();
            if (fieldIndex.getType() == IndexType.TEXT) {
                TextFilter textFilter = (TextFilter)indexFilter.getFilter();
                TextIndex textIndex = (TextIndex)fieldIndex;
                if (checkExclusive) {
                    return textIndex.isFilteredExclusivelyByCollectionTextIndex(textFilter);
                }
                return textIndex.isFilteredByCollectionTextIndex(textFilter);
            }
            if (fieldIndex.getType() == IndexType.TRANSLATABLE_TEXT) {
                TextFilter textFilter = (TextFilter)indexFilter.getFilter();
                TranslatableTextIndex textIndex = (TranslatableTextIndex)fieldIndex;
                if (checkExclusive) {
                    return textIndex.isFilteredExclusivelyByCollectionTextIndex(textFilter);
                }
                return textIndex.isFilteredByCollectionTextIndex(textFilter);
            }
        }
        return false;
    }

    public String explain(int var1);

    default public String getExplainTabs(int tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t".repeat(tabs));
        return sb.toString();
    }
}

