/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index;

import java.util.BitSet;
import org.teamapps.universaldb.index.FieldIndex;
import org.teamapps.universaldb.index.IndexMetaData;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.model.FieldModel;
import org.teamapps.universaldb.model.FieldType;

public abstract class AbstractIndex<TYPE, FILTER>
implements FieldIndex<TYPE, FILTER> {
    private final FieldModel fieldModel;
    private final TableIndex table;

    public AbstractIndex(FieldModel fieldModel, TableIndex table) {
        this.table = table;
        this.fieldModel = fieldModel;
        new IndexMetaData(table.getDataPath(), fieldModel.getName(), this.getFQN(), fieldModel.getFieldType().getId(), fieldModel.getFieldId());
    }

    @Override
    public String getName() {
        return this.fieldModel.getName();
    }

    @Override
    public String getFQN() {
        return this.table.getFQN() + "." + this.getName();
    }

    @Override
    public TableIndex getTable() {
        return this.table;
    }

    @Override
    public FieldType getFieldType() {
        return this.fieldModel.getFieldType();
    }

    @Override
    public FieldModel getFieldModel() {
        return this.fieldModel;
    }

    @Override
    public int getMappingId() {
        return this.fieldModel.getFieldId();
    }

    public String toString() {
        return "field: " + this.getName() + ", type:" + this.getType().name() + ", id:" + this.getMappingId();
    }

    public static BitSet negateInput(BitSet records, BitSet input) {
        BitSet data = (BitSet)records.clone();
        data.andNot(input);
        return data;
    }
}

