/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.buffer.index;

import java.io.File;
import java.util.Arrays;
import java.util.BitSet;
import java.util.stream.IntStream;
import org.teamapps.universaldb.index.buffer.common.BlockEntryAtomicStore;

public class ByteArrayAtomicMappedIndex {
    private BlockEntryAtomicStore atomicStore;

    public ByteArrayAtomicMappedIndex(File path, String name) {
        this.atomicStore = new BlockEntryAtomicStore(path, name);
    }

    public byte[] getValue(int id) {
        return this.atomicStore.getBytes(id);
    }

    public void setValue(int id, byte[] value) {
        this.atomicStore.setBytes(id, value);
    }

    public void removeValue(int id) {
        this.atomicStore.removeText(id);
    }

    public boolean isEmpty(int id) {
        return this.atomicStore.isEmpty(id);
    }

    public int getMaximumId() {
        return this.atomicStore.getLastNonEmptyId();
    }

    public int getLastNonEmptyId() {
        return this.atomicStore.getLastNonEmptyId();
    }

    public IntStream getIndexStream() {
        return IntStream.range(1, this.getMaximumId() + 1);
    }

    public BitSet filterEquals(byte[] value, BitSet bitSet) {
        return this.filterEquals(value, bitSet.stream());
    }

    public BitSet filterEquals(byte[] value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> Arrays.equals(this.atomicStore.getBytes(id), value)).forEach(result::set);
        return result;
    }

    public BitSet filterNotEquals(byte[] value, BitSet bitSet) {
        return this.filterNotEquals(value, bitSet.stream());
    }

    public BitSet filterNotEquals(byte[] value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> !Arrays.equals(this.atomicStore.getBytes(id), value)).forEach(result::set);
        return result;
    }

    public void flush() {
        this.atomicStore.flush();
    }

    public void close() {
        this.atomicStore.close();
    }

    public void drop() {
        this.atomicStore.drop();
    }
}

