/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.commons.util.collections.ByKeyComparisonResult;
import org.teamapps.commons.util.collections.CollectionUtil;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.AbstractIndex;
import org.teamapps.universaldb.index.DatabaseIndex;
import org.teamapps.universaldb.index.FieldIndex;
import org.teamapps.universaldb.index.IndexMetaData;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.MappedObject;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.binary.BinaryIndex;
import org.teamapps.universaldb.index.bool.BooleanIndex;
import org.teamapps.universaldb.index.buffer.index.RecordIndex;
import org.teamapps.universaldb.index.file.FileIndex;
import org.teamapps.universaldb.index.numeric.DoubleIndex;
import org.teamapps.universaldb.index.numeric.FloatIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.index.numeric.ShortIndex;
import org.teamapps.universaldb.index.reference.CyclicReferenceUpdate;
import org.teamapps.universaldb.index.reference.ReferenceIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.text.CollectionTextSearchIndex;
import org.teamapps.universaldb.index.text.FullTextIndexValue;
import org.teamapps.universaldb.index.text.TextFilter;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.universaldb.index.translation.TranslatableTextIndex;
import org.teamapps.universaldb.index.versioning.RecordVersioningIndex;
import org.teamapps.universaldb.model.FieldModel;
import org.teamapps.universaldb.model.FieldType;
import org.teamapps.universaldb.model.FileFieldModel;
import org.teamapps.universaldb.model.TableModel;
import org.teamapps.universaldb.query.AndFilter;
import org.teamapps.universaldb.query.Filter;
import org.teamapps.universaldb.query.IndexFilter;
import org.teamapps.universaldb.query.OrFilter;

public class TableIndex
implements MappedObject {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final DatabaseIndex databaseIndex;
    private final TableModel tableModel;
    private final String name;
    private final File dataPath;
    private final File fullTextIndexPath;
    private final RecordIndex records;
    private final List<FieldIndex> fieldIndices;
    private final Map<String, FieldIndex<?, ?>> fieldIndexByName;
    private boolean keepDeletedRecords;
    private RecordIndex deletedRecords;
    private CollectionTextSearchIndex collectionTextSearchIndex;
    private List<String> fileFieldNames;
    private List<TextIndex> textFields;
    private List<TranslatableTextIndex> translatedTextFields;
    private RecordVersioningIndex recordVersioningIndex;
    private long lastFullTextIndexCheck;

    public TableIndex(DatabaseIndex databaseIndex, TableModel tableModel) {
        this.databaseIndex = databaseIndex;
        this.tableModel = tableModel;
        this.name = tableModel.getName();
        this.dataPath = new File(databaseIndex.getDataPath(), this.name);
        this.fullTextIndexPath = new File(databaseIndex.getFullTextIndexPath(), this.name);
        this.dataPath.mkdir();
        this.fullTextIndexPath.mkdir();
        this.records = new RecordIndex(this.dataPath, "coll-recs");
        this.fieldIndices = new ArrayList<FieldIndex>();
        this.fieldIndexByName = new HashMap();
        if (tableModel.isRecoverableRecords()) {
            this.keepDeletedRecords = true;
            this.deletedRecords = new RecordIndex(this.dataPath, "coll-del-recs");
        }
        new IndexMetaData(this.dataPath, this.name, this.getFQN(), 0, tableModel.getTableId());
        if (tableModel.isVersioning()) {
            this.recordVersioningIndex = new RecordVersioningIndex(this);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
    }

    public void installOrMerge(TableModel tableModel) {
        ByKeyComparisonResult compareResult = CollectionUtil.compareByKey(this.fieldIndices, tableModel.getFields(), FieldIndex::getName, FieldModel::getName, (boolean)true);
        if (!compareResult.getAEntriesNotInB().isEmpty()) {
            throw new RuntimeException("Unknown fields that are not within the model:" + compareResult.getAEntriesNotInB().stream().map(FieldIndex::getName).collect(Collectors.joining(", ")));
        }
        for (FieldIndex fieldIndex : compareResult.getAEntriesInB()) {
        }
        for (FieldModel fieldModel : compareResult.getBEntriesNotInA()) {
            FieldIndex fieldIndex = this.createField(this, fieldModel);
            this.addIndex(fieldIndex);
        }
    }

    private FieldIndex createField(TableIndex tableIndex, FieldModel fieldModel) {
        AbstractIndex column = null;
        switch (fieldModel.getFieldType().getIndexType()) {
            case BOOLEAN: {
                column = new BooleanIndex(fieldModel, tableIndex);
                break;
            }
            case SHORT: {
                column = new ShortIndex(fieldModel, tableIndex);
                break;
            }
            case INT: {
                column = new IntegerIndex(fieldModel, tableIndex);
                break;
            }
            case LONG: {
                column = new LongIndex(fieldModel, tableIndex);
                break;
            }
            case FLOAT: {
                column = new FloatIndex(fieldModel, tableIndex);
                break;
            }
            case DOUBLE: {
                column = new DoubleIndex(fieldModel, tableIndex);
                break;
            }
            case TEXT: {
                column = new TextIndex(fieldModel, tableIndex, tableIndex.getCollectionTextSearchIndex());
                break;
            }
            case TRANSLATABLE_TEXT: {
                column = new TranslatableTextIndex(fieldModel, tableIndex, tableIndex.getCollectionTextSearchIndex());
                break;
            }
            case REFERENCE: {
                column = new SingleReferenceIndex(fieldModel, tableIndex);
                break;
            }
            case MULTI_REFERENCE: {
                column = new MultiReferenceIndex(fieldModel, tableIndex);
                break;
            }
            case FILE: {
                column = new FileIndex((FileFieldModel)fieldModel, tableIndex);
                break;
            }
            case BINARY: {
                column = new BinaryIndex(fieldModel, tableIndex);
            }
        }
        return column;
    }

    public void addIndex(FieldIndex index) {
        this.fieldIndices.add(index);
        this.fieldIndexByName.put(index.getName(), index);
        this.fileFieldNames = null;
        this.textFields = null;
    }

    public CollectionTextSearchIndex getCollectionTextSearchIndex() {
        if (this.collectionTextSearchIndex == null) {
            this.collectionTextSearchIndex = new CollectionTextSearchIndex(this.fullTextIndexPath, "coll-text");
        }
        return this.collectionTextSearchIndex;
    }

    public void checkFullTextIndex() {
        if (this.collectionTextSearchIndex == null) {
            return;
        }
        if (!this.records.getBoolean(0) && this.getCount() > 0 && System.currentTimeMillis() - this.lastFullTextIndexCheck > 300000L || this.getCount() > 0 && this.collectionTextSearchIndex.getMaxDoc() == 0) {
            long time = System.currentTimeMillis();
            logger.warn("RECREATING FULL TEXT INDEX FOR: " + this.getName() + " (RECORDS:" + this.getCount() + ", MAX-DOC:" + this.collectionTextSearchIndex.getMaxDoc() + ")");
            this.recreateFullTextIndex();
            this.lastFullTextIndexCheck = System.currentTimeMillis();
            logger.warn("RECREATING FINISHED FOR: " + this.getName() + " (TIME:" + (System.currentTimeMillis() - time) + ")");
        }
        this.records.setBoolean(0, false);
    }

    public void forceFullTextIndexRecreation() {
        logger.warn("FORCED RECREATING FULL TEXT INDEX FOR: " + this.getName() + " (RECORDS:" + this.getCount() + ", MAX-DOC:" + this.collectionTextSearchIndex.getMaxDoc() + ")");
        this.recreateFullTextIndex();
    }

    private void recreateFullTextIndex() {
        try {
            this.collectionTextSearchIndex.deleteAllDocuments();
            BitSet bitSet = this.records.getBitSet();
            int id = bitSet.nextSetBit(0);
            while (id >= 0) {
                Object value;
                ArrayList<FullTextIndexValue> values = new ArrayList<FullTextIndexValue>();
                for (TextIndex textField : this.getTextFields()) {
                    value = textField.getValue(id);
                    if (value == null) continue;
                    values.add(new FullTextIndexValue(textField.getName(), (String)value));
                }
                for (TranslatableTextIndex translatableTextIndex : this.getTranslatedTextFields()) {
                    value = translatableTextIndex.getValue(id);
                    if (value == null) continue;
                    values.add(new FullTextIndexValue(translatableTextIndex.getName(), (TranslatableText)value));
                }
                if (!values.isEmpty()) {
                    this.collectionTextSearchIndex.setRecordValues(id, values, false);
                }
                id = bitSet.nextSetBit(id + 1);
            }
            this.collectionTextSearchIndex.commit(false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public RecordVersioningIndex getRecordVersioningIndex() {
        return this.recordVersioningIndex;
    }

    public File getDataPath() {
        return this.dataPath;
    }

    public File getFullTextIndexPath() {
        return this.fullTextIndexPath;
    }

    public BitSet getRecords() {
        return this.records.getBitSet();
    }

    public boolean isStored(int id) {
        return this.records.getBoolean(id);
    }

    public int getCount() {
        return this.records.getCount();
    }

    public BitSet getDeletedRecords() {
        if (!this.keepDeletedRecords) {
            return null;
        }
        return this.deletedRecords.getBitSet();
    }

    public int getDeletedRecordsCount() {
        return this.keepDeletedRecords ? this.deletedRecords.getCount() : 0;
    }

    public boolean isDeleted(int id) {
        if (this.deletedRecords != null) {
            return this.deletedRecords.getBoolean(id);
        }
        return !this.records.getBoolean(id);
    }

    public Filter createFullTextFilter(String query, String ... fieldNames) {
        String[] terms;
        AndFilter andFilter = new AndFilter();
        if (query == null || query.isBlank()) {
            return andFilter;
        }
        for (String term : terms = query.split(" ")) {
            if (term.isBlank()) continue;
            boolean isNegation = term.startsWith("!");
            TextFilter textFilter = this.parseTextFilter(term);
            Filter fullTextFilter = this.createFullTextFilter(textFilter, !isNegation, fieldNames);
            andFilter.and(fullTextFilter);
        }
        return andFilter;
    }

    private TextFilter parseTextFilter(String term) {
        boolean negation = false;
        boolean similar = false;
        boolean startsWith = false;
        boolean equals = false;
        if (term.startsWith("!")) {
            negation = true;
            term = term.substring(1);
        }
        if (term.endsWith("+")) {
            similar = true;
            term = term.substring(0, term.length() - 1);
        }
        if (term.endsWith("*")) {
            startsWith = true;
            term = term.substring(0, term.length() - 1);
        }
        if (term.contains("\"")) {
            equals = true;
            term = term.replace("\"", "");
        }
        if (equals) {
            return negation ? TextFilter.termEqualsFilter(term) : TextFilter.termNotEqualsFilter(term);
        }
        if (similar) {
            return negation ? TextFilter.termNotSimilarFilter(term) : TextFilter.termSimilarFilter(term);
        }
        if (startsWith) {
            return negation ? TextFilter.termStartsNotWithFilter(term) : TextFilter.termStartsWithFilter(term);
        }
        return negation ? TextFilter.termContainsNotFilter(term) : TextFilter.termContainsFilter(term);
    }

    public Filter createFullTextFilter(TextFilter textFilter, String ... fieldNames) {
        return this.createFullTextFilter(textFilter, true, fieldNames);
    }

    public Filter createFullTextFilter(TextFilter textFilter, boolean orQuery, String ... fieldNames) {
        Filter filter;
        Filter filter2 = filter = orQuery ? new OrFilter() : new AndFilter();
        if (fieldNames == null || fieldNames.length == 0) {
            this.fieldIndices.stream().filter(columnIndex -> columnIndex.getType() == IndexType.TEXT || columnIndex.getType() == IndexType.TRANSLATABLE_TEXT).forEach(columnIndex -> {
                IndexFilter indexFilter = new IndexFilter(columnIndex, textFilter);
                if (orQuery) {
                    filter.or(indexFilter);
                } else {
                    filter.and(indexFilter);
                }
            });
        } else {
            for (String fieldName : fieldNames) {
                FieldIndex<?, ?> fieldIndex = this.fieldIndexByName.get(fieldName);
                if ((fieldIndex == null || fieldIndex.getType() != IndexType.TEXT) && fieldIndex.getType() != IndexType.TRANSLATABLE_TEXT) continue;
                IndexFilter indexFilter = new IndexFilter(fieldIndex, textFilter);
                if (orQuery) {
                    filter.or(indexFilter);
                    continue;
                }
                filter.and(indexFilter);
            }
        }
        return filter;
    }

    public List<SortEntry> sortRecords(String columnName, BitSet records, boolean ascending, UserContext userContext, SingleReferenceIndex ... path) {
        FieldIndex index = null;
        index = path != null && path.length > 0 ? path[path.length - 1].getReferencedTable().getFieldIndex(columnName) : this.getFieldIndex(columnName);
        if (index == null) {
            return null;
        }
        List<SortEntry> sortEntries = SortEntry.createSortEntries(records, path);
        return index.sortRecords(sortEntries, ascending, userContext);
    }

    public int createRecord(int recordId) {
        int id = 0;
        if (recordId == 0) {
            id = this.keepDeletedRecords ? Math.max(this.records.getNextAvailableId(), this.deletedRecords.getNextAvailableId()) : this.records.getNextAvailableId();
        } else {
            id = recordId;
            if (this.keepDeletedRecords && this.deletedRecords.getBoolean(recordId)) {
                this.deletedRecords.setBoolean(recordId, false);
            }
        }
        this.records.setBoolean(id, true);
        return id;
    }

    public void updateFullTextIndex(int id, List<FullTextIndexValue> values, boolean update) {
        if (update) {
            Set textFieldNames = values.stream().map(FullTextIndexValue::getFieldName).collect(Collectors.toSet());
            ArrayList<FullTextIndexValue> recordFullTextIndexValues = new ArrayList<FullTextIndexValue>(values);
            for (TextIndex textField : this.getTextFields()) {
                if (textFieldNames.contains(textField.getName())) continue;
                recordFullTextIndexValues.add(new FullTextIndexValue(textField.getName(), textField.getValue(id)));
            }
            for (TranslatableTextIndex translatableTextIndex : this.getTranslatedTextFields()) {
                TranslatableText translatableTextValue;
                if (textFieldNames.contains(translatableTextIndex.getName()) || (translatableTextValue = translatableTextIndex.getValue(id)) == null) continue;
                recordFullTextIndexValues.add(new FullTextIndexValue(translatableTextIndex.getName(), translatableTextValue));
            }
            this.collectionTextSearchIndex.setRecordValues(id, recordFullTextIndexValues, true);
        } else {
            this.collectionTextSearchIndex.setRecordValues(id, values, false);
        }
    }

    private List<Integer> getReferencedRecords(int id, FieldIndex<?, ?> referenceColumn) {
        if (referenceColumn.getFieldType() == FieldType.MULTI_REFERENCE) {
            MultiReferenceIndex multiReferenceIndex = (MultiReferenceIndex)referenceColumn;
            return multiReferenceIndex.getReferencesAsList(id);
        }
        SingleReferenceIndex singleReferenceIndex = (SingleReferenceIndex)referenceColumn;
        int reference = singleReferenceIndex.getValue(id);
        return reference > 0 ? Collections.singletonList(reference) : Collections.emptyList();
    }

    public List<CyclicReferenceUpdate> deleteRecord(int id) {
        return this.deleteRecord(id, null);
    }

    private List<CyclicReferenceUpdate> deleteRecord(int id, FieldIndex<?, ?> cascadeOriginIndex) {
        this.records.setBoolean(id, false);
        if (this.keepDeletedRecords) {
            if (this.deletedRecords.getBoolean(id)) {
                return Collections.emptyList();
            }
            this.deletedRecords.setBoolean(id, true);
        }
        ArrayList<CyclicReferenceUpdate> cyclicReferenceUpdates = new ArrayList<CyclicReferenceUpdate>();
        for (FieldIndex fieldIndex : this.getReferenceFields()) {
            boolean isMultiBackReference;
            ReferenceIndex referenceIndex = (ReferenceIndex)fieldIndex;
            if (fieldIndex == cascadeOriginIndex || referenceIndex.getReferenceFieldModel().getReferencedTable().isRemoteTable()) continue;
            boolean isCascadeDelete = referenceIndex.isCascadeDeleteReferences();
            TableIndex referencedTable = referenceIndex.getReferencedTable();
            boolean isReferenceKeepDeletedRecords = referencedTable.isKeepDeletedRecords();
            boolean isMultiReference = referenceIndex.isMultiReference();
            FieldIndex backReferenceColumn = fieldIndex.getReferencedColumn();
            boolean isWithBackReferenceColumn = backReferenceColumn != null;
            boolean bl = isMultiBackReference = backReferenceColumn != null && backReferenceColumn.getFieldType() == FieldType.MULTI_REFERENCE;
            List<Integer> referencedRecords = this.getReferencedRecords(id, fieldIndex);
            if (referencedRecords.isEmpty()) continue;
            if (this.keepDeletedRecords) {
                if (isReferenceKeepDeletedRecords) {
                    if (isCascadeDelete) {
                        referencedRecords.forEach(refId -> referencedTable.deleteRecord((int)refId, backReferenceColumn));
                        continue;
                    }
                    if (!isWithBackReferenceColumn) continue;
                    List<CyclicReferenceUpdate> referenceUpdates = this.removeBackReferences(id, backReferenceColumn, isMultiBackReference, referencedRecords);
                    cyclicReferenceUpdates.addAll(referenceUpdates);
                    continue;
                }
                if (isCascadeDelete) {
                    if (isMultiReference) {
                        MultiReferenceIndex multiReferenceColumn = (MultiReferenceIndex)fieldIndex;
                        multiReferenceColumn.removeAllReferences(id, false);
                    } else {
                        SingleReferenceIndex singleReferenceColumn = (SingleReferenceIndex)fieldIndex;
                        singleReferenceColumn.setValue(id, 0, false);
                    }
                    referencedRecords.forEach(referencedTable::deleteRecord);
                    continue;
                }
                if (!isWithBackReferenceColumn) continue;
                this.removeBackReferences(id, backReferenceColumn, isMultiBackReference, referencedRecords);
                continue;
            }
            if (!isCascadeDelete) continue;
            referencedRecords.forEach(referencedTable::deleteRecord);
        }
        if (!this.keepDeletedRecords) {
            for (FieldIndex<Object, Object> fieldIndex : this.fieldIndices) {
                fieldIndex.removeValue(id);
            }
            if (this.collectionTextSearchIndex != null) {
                this.collectionTextSearchIndex.delete(id, this.getFileFieldNames());
            }
        }
        return cyclicReferenceUpdates;
    }

    private List<CyclicReferenceUpdate> removeBackReferences(int id, FieldIndex<?, ?> backReferenceColumn, boolean isMultiBackReference, List<Integer> referencedRecords) {
        ArrayList<CyclicReferenceUpdate> cyclicReferenceUpdates = new ArrayList<CyclicReferenceUpdate>();
        if (isMultiBackReference) {
            MultiReferenceIndex multiBackReferenceColumn = (MultiReferenceIndex)backReferenceColumn;
            referencedRecords.forEach(refId -> {
                multiBackReferenceColumn.removeReferences((int)refId, Collections.singletonList(id), true);
                cyclicReferenceUpdates.add(new CyclicReferenceUpdate(multiBackReferenceColumn, true, (int)refId, id));
            });
        } else {
            SingleReferenceIndex singleBackReferenceColumn = (SingleReferenceIndex)backReferenceColumn;
            referencedRecords.forEach(refId -> {
                int value = singleBackReferenceColumn.getValue((int)refId);
                if (id == value) {
                    singleBackReferenceColumn.setValue((int)refId, 0, true);
                    cyclicReferenceUpdates.add(new CyclicReferenceUpdate(singleBackReferenceColumn, true, (int)refId, id));
                }
            });
        }
        return cyclicReferenceUpdates;
    }

    public List<CyclicReferenceUpdate> restoreRecord(int id) {
        return this.restoreRecord(id, null);
    }

    public List<CyclicReferenceUpdate> restoreRecord(int id, FieldIndex<?, ?> cascadeOriginIndex) {
        if (!this.keepDeletedRecords || !this.deletedRecords.getBoolean(id)) {
            return Collections.emptyList();
        }
        this.deletedRecords.setBoolean(id, false);
        ArrayList<CyclicReferenceUpdate> cyclicReferenceUpdates = new ArrayList<CyclicReferenceUpdate>();
        for (FieldIndex fieldIndex : this.getReferenceFields()) {
            boolean isMultiBackReference;
            ReferenceIndex referenceIndex = (ReferenceIndex)fieldIndex;
            if (fieldIndex == cascadeOriginIndex || referenceIndex.getReferenceFieldModel().getReferencedTable().isRemoteTable()) continue;
            boolean isCascadeDelete = referenceIndex.isCascadeDeleteReferences();
            TableIndex referencedTable = referenceIndex.getReferencedTable();
            boolean isReferenceKeepDeletedRecords = referencedTable.isKeepDeletedRecords();
            boolean isMultiReference = referenceIndex.isMultiReference();
            FieldIndex backReferenceColumn = fieldIndex.getReferencedColumn();
            boolean isWithBackReferenceColumn = backReferenceColumn != null;
            boolean bl = isMultiBackReference = backReferenceColumn != null && backReferenceColumn.getFieldType().isMultiReference();
            List<Integer> referencedRecords = this.getReferencedRecords(id, fieldIndex);
            if (referencedRecords.isEmpty()) continue;
            if (isReferenceKeepDeletedRecords) {
                if (isCascadeDelete) {
                    referencedRecords.forEach(refId -> referencedTable.restoreRecord((int)refId, backReferenceColumn));
                    continue;
                }
                if (!isWithBackReferenceColumn) continue;
                List<CyclicReferenceUpdate> referenceUpdates = this.restoreBackReferences(id, fieldIndex, referencedTable, isMultiReference, backReferenceColumn, isMultiBackReference, referencedRecords);
                cyclicReferenceUpdates.addAll(referenceUpdates);
                continue;
            }
            if (isCascadeDelete || !isWithBackReferenceColumn) continue;
            this.restoreBackReferences(id, fieldIndex, referencedTable, isMultiReference, backReferenceColumn, isMultiBackReference, referencedRecords);
        }
        this.records.setBoolean(id, true);
        return cyclicReferenceUpdates;
    }

    private List<CyclicReferenceUpdate> restoreBackReferences(int id, FieldIndex<?, ?> referenceColumn, TableIndex referencedTable, boolean isMultiReference, FieldIndex<?, ?> backReferenceColumn, boolean isMultiBackReference, List<Integer> referencedRecords) {
        ArrayList<CyclicReferenceUpdate> cyclicReferenceUpdates = new ArrayList<CyclicReferenceUpdate>();
        if (isMultiBackReference) {
            MultiReferenceIndex multiBackReferenceColumn = (MultiReferenceIndex)backReferenceColumn;
            referencedRecords.forEach(refId -> {
                if (referencedTable.isStored((int)refId)) {
                    multiBackReferenceColumn.addReferences((int)refId, Collections.singletonList(id), true);
                    cyclicReferenceUpdates.add(new CyclicReferenceUpdate(multiBackReferenceColumn, false, (int)refId, id));
                } else if (isMultiReference) {
                    MultiReferenceIndex multiReferenceColumn = (MultiReferenceIndex)referenceColumn;
                    multiReferenceColumn.removeAllReferences(id, true);
                } else {
                    SingleReferenceIndex singleReferenceColumn = (SingleReferenceIndex)referenceColumn;
                    singleReferenceColumn.setValue(id, 0, true);
                }
            });
        } else {
            SingleReferenceIndex singleBackReferenceColumn = (SingleReferenceIndex)backReferenceColumn;
            referencedRecords.forEach(refId -> {
                if (referencedTable.isStored((int)refId)) {
                    int value = singleBackReferenceColumn.getValue((int)refId);
                    if (value == 0) {
                        singleBackReferenceColumn.setValue((int)refId, id, true);
                        cyclicReferenceUpdates.add(new CyclicReferenceUpdate(singleBackReferenceColumn, false, (int)refId, id));
                    } else if (isMultiReference) {
                        MultiReferenceIndex multiReferenceColumn = (MultiReferenceIndex)referenceColumn;
                        multiReferenceColumn.removeAllReferences(id, true);
                    } else {
                        SingleReferenceIndex singleReferenceColumn = (SingleReferenceIndex)referenceColumn;
                        singleReferenceColumn.setValue(id, 0, true);
                    }
                }
            });
        }
        return cyclicReferenceUpdates;
    }

    private List<String> getFileFieldNames() {
        if (this.fileFieldNames == null) {
            this.fileFieldNames = this.fieldIndices.stream().filter(index -> index.getType() == IndexType.FILE).map(FieldIndex::getName).collect(Collectors.toList());
        }
        return this.fileFieldNames;
    }

    private List<TextIndex> getTextFields() {
        if (this.textFields == null) {
            this.textFields = this.fieldIndices.stream().filter(index -> index.getType() == IndexType.TEXT).map(index -> (TextIndex)index).collect(Collectors.toList());
        }
        return this.textFields;
    }

    private List<TranslatableTextIndex> getTranslatedTextFields() {
        if (this.translatedTextFields == null) {
            this.translatedTextFields = this.fieldIndices.stream().filter(index -> index.getType() == IndexType.TRANSLATABLE_TEXT).map(index -> (TranslatableTextIndex)index).collect(Collectors.toList());
        }
        return this.translatedTextFields;
    }

    public BitSet getRecordBitSet() {
        return this.records.getBitSet();
    }

    public BitSet getDeletedRecordsBitSet() {
        if (!this.keepDeletedRecords) {
            return null;
        }
        return this.deletedRecords.getBitSet();
    }

    public List<FieldIndex> getFieldIndices() {
        return this.fieldIndices;
    }

    public List<ReferenceIndex<?, ?>> getReferenceFields() {
        return this.fieldIndices.stream().filter(fieldIndex -> fieldIndex.getFieldType().isReference()).map(f -> (ReferenceIndex)f).collect(Collectors.toList());
    }

    public FieldIndex getFieldIndex(String name) {
        return this.fieldIndexByName.get(name);
    }

    public boolean isKeepDeletedRecords() {
        return this.keepDeletedRecords;
    }

    @Override
    public int getMappingId() {
        return this.tableModel.getTableId();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("collection: ").append(this.name).append(", id:").append(this.getMappingId()).append("\n");
        for (FieldIndex column : this.fieldIndices) {
            sb.append("\t").append(column.toString()).append("\n");
        }
        return sb.toString();
    }

    public void close() {
        try {
            logger.info(UniversalDB.SKIP_DB_LOGGING, "Shutdown on collection:" + this.name);
            if (this.collectionTextSearchIndex != null) {
                this.collectionTextSearchIndex.commit(true);
            }
            this.records.setBoolean(0, true);
            this.records.close();
            for (FieldIndex column : this.fieldIndices) {
                column.close();
            }
            if (this.recordVersioningIndex != null) {
                this.recordVersioningIndex.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void drop() {
        this.collectionTextSearchIndex.drop();
        for (FieldIndex column : this.fieldIndices) {
            column.drop();
        }
    }

    @Override
    public String getFQN() {
        return this.databaseIndex.getName() + "." + this.name;
    }

    public String getName() {
        return this.name;
    }

    public DatabaseIndex getDatabaseIndex() {
        return this.databaseIndex;
    }
}

